<?php

namespace App\Controllers;
use \CodeIgniter\Controller;
use App\Models\User_model;
use App\Libraries\fpdf;

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class Levelcoordinator extends BaseController
{
	public $session;
	public $fpdf;

	public function __construct(){
		
		$this->fpdf = new FPDF();
		$this->session = \Config\Services::session();
		
	}
	
	public function construction(){
		return view("levelcoordinator/construction");
	}

	public function login(){
		return view("levelcoordinator/login");
	}

	public function logout(){
		$this->session->remove('levelcoordinator_logged');
		$this->session->remove('name');
		$this->session->remove('department');
		$this->session->destroy();
		return redirect()->to(base_url()."/lev-login");
	}
	
		public function login_checker()
	{
		if($this->request->getMethod() == 'post'){
			$username = $this->request->getVar("email");
			$password = $this->request->getVar("password");

			$check_login = $this->levelcoordinator_model->verify_levelcoordinator($username);
			

			if($check_login){
				if($check_login['status'] == 'active'){
				    
					if(password_verify($password, $check_login['password'])){
						$username = $check_login['email'];
    				    $dept_id = $check_login['dept_id'];
    				    $dept_details = $this->levelcoordinator_model->get_department_details($dept_id);
    				    $faculty_id = $dept_details['faculty_id'];
    				    $faculty = $this->levelcoordinator_model->get_faculty_details($faculty_id)['title'];
					    $num = $this->levelcoordinator_model->get_number_of_programmes_allocated($username);
					    
					    if($num == 1){
					        
					        $this->session->set('levelcoordinator_logged', true);
    						$this->session->set('username', $check_login['username']);
    						$this->session->set('staff_id', $check_login['staff_id']);
    						$this->session->set('staff_no', $check_login['stfn']);
    						$this->session->set('email', $check_login['email']);
    						$this->session->set('id', $check_login['id']);
    						
    						$programme_name = $this->levelcoordinator_model->get_programme_name($check_login['programme_id']);
    						$sname = $this->levelcoordinator_model->get_staff_name($username);
    						$department = $this->lecturer_model->get_department_name($dept_id)['title'];
    						$this->session->set('faculty', $faculty);
    						$this->session->set('name', $sname['name']);
    						$this->session->set('department', $department);
    						$this->session->set('programme_id', $check_login['programme_id']);
    						$this->session->set('programme_name', $programme_name['title']);
    						$this->session->set('department', $department);
    						
    						$initial = substr($check_login['username'], 3, 2);
						    $current = substr($this->portal_config['reg_session'], 2, 2);
                			$f_level = 0;
                			
                			
                			if($current - $initial == 0 || $current - $initial == 1){
                			    $f_level = (($current - $initial) * 100) + 100;
                			}else if($current - $initial == 3 || $current - $initial == 4){
                			    $f_level = ($current - $initial) * 100;
                			}else if($current - $initial == 5){
                			    $f_level = "SO1";
                			}else if($current - $initial == 6){
                			    $f_level = "SO2";
                			}
	                    
    						//$level = ;
    						//$year = (int) $sess;
    						
    						$this->session->set('level', $f_level);
    						$this->session->set('session_started', $check_login['session_started']);
    						$this->session->set('current_session', $this->portal_config['reg_session']);
    						
    						return redirect()->to(base_url().'/lev-index');
						
					    }else{
					        $programme_detail = $this->levelcoordinator_model->get_programmes_levels($username);
    						$program = [];
    						$level = [];
    						$programme_name = [];
    						foreach($programme_detail as $prog){
    						    
    						    $initial = substr($prog->current_level, 0, 4);
        						$current = substr($this->portal_config['reg_session'], 0, 4);
        						
        						$level_ = ($current - $initial) + 100;
    						    
    						    array_push($program, $prog->programme_id);
    						
    						    array_push($level, $level_);
    						    array_push($programme_name, $this->levelcoordinator_model->get_programme_name($prog->programme_id)['title']);
    						}
    						
    						$this->session->set('login_id', $username);
    						$this->session->set('programmes', $program);
    						$this->session->set('levels', $level);
    						$this->session->set('programme_name', $programme_name);
					        return redirect()->to('check_programme');
					    }
						
					}else{
						$this->session->setTempdata('loginError', 'Incorrect Password', 3);
						return redirect()->to(base_url().'/lev-login');
					}
				}else{
						$this->session->setTempdata('loginError', 'Your account is suspended/deleted. Contanct your HOD', 3);
						return redirect()->to(base_url().'/lev-login');
				}
				
			}else{
				$this->session->setTempdata('loginError', 'Invalid Email or Staff No.', 3);
				return redirect()->to(base_url().'/lev-login');
			}
	}

	} // end of login checker
	
		public function check_programme()
	{

		
		$data = [
			'page_title' => 'Programmes',
			'page_subtitle' => ''
		];
		$data['programmes'] = $this->session->get('programmes');
		$data['levels'] = $this->session->get('levels');
		$data['programme_names'] = $this->session->get('programme_name');
		
		return view("levelcoordinator/check_programme", $data);
		
	}
	
	public function programme_login(){
	    
		if($this->request->getMethod() == 'post'){
		    
			$programme = $this->request->getVar("programme");
			$email = $this->session->get('login_id');
			
			$verfication = $this->levelcoordinator_model->final_verify_levelcoordinator($email, $programme);
			
		    $this->session->set('levelcoordinator_logged', true);
			$this->session->set('username', $verfication['username']);
			$this->session->set('staff_id', $verfication['staff_id']);
			$this->session->set('staff_no', $verfication['stfn']);
			$this->session->set('email', $verfication['email']);
			$this->session->set('id', $verfication['id']);
			$dept_id = $verfication['dept_id'];
			$programme_name = $this->levelcoordinator_model->get_programme_name($verfication['programme_id']);
			$sname = $this->levelcoordinator_model->get_staff_name($email);
			$department = $this->lecturer_model->get_department_name($dept_id)['title'];
		    $dept_details = $this->levelcoordinator_model->get_department_details($dept_id);
		    $faculty_id = $dept_details['faculty_id'];
		    $faculty = $this->levelcoordinator_model->get_faculty_details($faculty_id)['title'];
			$this->session->set('name', $sname['name']);
			$this->session->set('department', $department);
			$this->session->set('faculty', $faculty);
			$this->session->set('programme_id', $verfication['programme_id']);
			$this->session->set('programme_name', $programme_name['title']);
			$this->session->set('department', $department);
			
			//$initial = substr($check_login['username'], 3, 2);
		    //$current = substr($this->portal_config['reg_session'], 2, 2);
		    $initial = substr($verfication['username'], 3, 2);
			$current = substr($this->portal_config['reg_session'], 2, 2);
			$f_level = 0;
			if($current - $initial == 0 || $current - $initial == 1){
			    $f_level = (($current - $initial) * 100) + 100;
			}else if($current - $initial == 3 || $current - $initial == 4){
			    $f_level = ($current - $initial) * 100;
			}else if($current - $initial == 5){
			    $f_level = "SO1";
			}else if($current - $initial == 6){
			    $f_level = "SO2";
			}
			
			
			$this->session->set('level', $f_level);
			$this->session->set('session_started', $verfication['session_started']);
			$this->session->set('current_session', $this->portal_config['reg_session']);
			
			return redirect()->to(base_url().'/lev-index');
						
        }  
    
	}
	
	public function dashboard()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'Dashboard',
			'page_subtitle' => '',
			'user' => $this->session->get('name'),
			'id' => $this->session->get('id')
		];

		$id = $this->session->get('id');
		$programme = $this->session->get('programme_id');
		$level = $this->session->get('level');
		$session = $this->session->get('current_session');
		$students = $this->levelcoordinator_model->count_all_students($programme, $level, $session);
		$data['active'] = 0;
		$data['graduated'] = 0;
		$data['suspended'] = 0;
		$data['expelled'] = 0;
		
		$data['courses'] = $this->levelcoordinator_model->get_courses_by_programme($programme);

		if($students){
			foreach($students as $cat){
				if($cat->status == 'Student'){
					$data['active'] += $cat->num;
				}
				if($cat->status == 'Graduated'){
					$data['graduated'] += $cat->num;
				}
				if($cat->status == 'Suspended'){
					$data['suspended'] += $cat->num;
				}
				if($cat->status == 'Expelled'){
					$data['expelled'] += $cat->num;
				}
			}
		}
		
		return view("levelcoordinator/dashboard", $data);
		
	}

	public function test(){
		echo json_encode($this->levelcoordinator_model->get_staff_name('abgarko@yahoo.com'));
	}

	public function view_courses()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'My Courses',
			'page_subtitle' => '',
			'user' => $this->session->get('name')
		];
		$data['result'] = $this->lecturer_model->get_course_allocation('P2013/0383', '2020/2021');
		//$data['user'] = $this->session->get('logged_hod');
		echo view('templates/lecturer_header', $data);
		echo view('lecturer/view_courses');
		echo view('templates/lecturer_footer');
		
	}

	public function view_previous_courses()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'My Previous Courses',
			'page_subtitle' => '',
			'user' => $this->session->get('name')
		];
		$data['result'] = $this->lecturer_model->get_previous_course_allocation('P2013/0383', '2020/2021');
		//$data['user'] = $this->session->get('logged_hod');
		echo view('templates/lecturer_header', $data);
		echo view('lecturer/view_previous_courses');
		echo view('templates/lecturer_footer');
		
	}

	public function view_students()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'My Students',
			'page_subtitle' => 'View My Students',
			'user' => $this->session->get('name')
		];

		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;

		return view("levelcoordinator/view_students", $data);
	}
	
	public function registration_configurations()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$data = [
			'page_title' => 'Settings',
			'page_subtitle' => 'Configurations',
			'user' => $this->session->get('name')
		];

		$programme = $this->session->get('programme_id');
		$username = $this->session->get('username');
		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}

		$available_courses = [];
		
		$selected_courses = $this->levelcoordinator_model->get_selected_courses($programme);

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
		$data['course'] = $this->levelcoordinator_model->get_available_courses($programme);
		$data['detail'] = $this->levelcoordinator_model->get_level_details($username);

		$data['courses_selected'] = $this->levelcoordinator_model->get_selected_courses($programme);

		return view("levelcoordinator/registration_configurations", $data);
	}
	
		public function transfer_students()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$programme = $this->session->get('programme_id');
		$data = [
			'page_title' => 'My Students',
			'page_subtitle' => 'Transfer Students',
			'user' => $this->session->get('name')
		];

		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;
		$data['courses'] = $this->levelcoordinator_model->get_courses_by_programme($programme);

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;

		return view("levelcoordinator/transfer_students", $data);
	}

	public function course_registrations()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$data = [
			'page_title' => 'My Students',
			'page_subtitle' => 'Course Registrations',
			'user' => $this->session->get('name')
		];
		
		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
	
		return view("levelcoordinator/course_registrations", $data);
		
	}
	
	public function course_enrollments()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$data = [
			'page_title' => 'My Students',
			'page_subtitle' => 'Course Enrollments',
			'user' => $this->session->get('name')
		];
		
		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
	
		return view("levelcoordinator/course_enrollments", $data);
		
	}

	public function password(){

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		if($this->request->getMethod() == 'post'){
		    $pass = password_hash($this->request->getVar('pass1'), PASSWORD_BCRYPT);
            $error = '';
            $success = '';
			if($this->levelcoordinator_model->update_password($this->session->get('username'), $pass)){
				$success = "Password updated successfully";
			}else{
				$error = "Oops! Something went wrong. Try later.";
			}

            $output = array(
                'error'		=>	$error,
                'success'	=>	$success
            );
        	echo json_encode($output);
		}else{
    		$data = [
    			'page_title' => 'Settings',
    			'page_subtitle' => 'Change Password',
    			'user' => $this->session->get('name')
    		];
    		
    		return view('levelcoordinator/change_password', $data);
		}
		
	}

	public function student_course_registrations()
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		if($this->request->getMethod() == 'post'){
			
			$id = $this->session->get('programme_id');
			$level = $this->session->get('level')."";

			$student = $this->levelcoordinator_model->get_registered_students($id, $level);
			
			foreach($student as $stud){
				//echo $stud->student_id;
				if(isset($_POST[$stud->student_id])){
					$id = $_POST[$stud->student_id];
					
					$data = [
						'page_title' => 'Student Course Registration',
						'user' => $this->session->get('name')
					];
					
					$data['course'] =  $this->levelcoordinator_model->get_courses("Computer Science");
					$data['student'] = $this->levelcoordinator_model->get_student_courses($id);
					$data['detail'] = $this->levelcoordinator_model->get_student_details($id);
					//$data['user'] = $this->session->get('logged_hod');
					echo view('templates/levelcoordinator_header', $data);
					echo view('levelcoordinator/student_course_registrations');
					echo view('templates/levelcoordinator_footer');
				}
			}
		}
			

		
	}
	
	public function lecturers_submission()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'Exam Results',
			'page_subtitle' => 'Lecturers Submission',
			'current_ss' => $this->portal_config['reg_session'],
			'user' => $this->session->get('name')
		];

		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}
		

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
		
		return view('levelcoordinator/lecturers_submission', $data);
		
	}

	public function course_submitted($id)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
			
			//$id = $this->session->get('programme_id');
			$level = $this->session->get('level')."";
            //$id = str_replace(",", "/", $id);

			//$submission = $this->levelcoordinator_model->get_programme_submitted_result('CSC20', '1st', '2020/2021');
			$data = [
				'page_title' => 'Course Submission',
				'page_subtitle' => '',
				'user' => $this->session->get('name')
			];
					
			$data['course'] =  $this->levelcoordinator_model->get_courses("Computer Science");
			$data['submission'] = $this->levelcoordinator_model->get_marks($id);
			$data['detail'] = $this->levelcoordinator_model->get_course_detail_($id);
			//$data['user'] = $this->session->get('logged_hod');

			echo view('templates/levelcoordinator_header', $data);
			echo view('levelcoordinator/course_submitted');
			echo view('templates/levelcoordinator_footer');
		
	}
	
	public function session_report()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'Exam Results',
			'page_subtitle' => 'Report',
			'current_ss' => $this->portal_config['reg_session'],
			'user' => $this->session->get('name')
		];

		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}
		
		//$data['session'] =  $this->levelcoordinator_model->get_session(58);
		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
		
		return view('levelcoordinator/session_report', $data);

	}
	
	public function compute_result()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'Exam Results',
			'page_subtitle' => 'Results',
			'user' => $this->session->get('name')
		];

		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}
		
		//$data['session'] =  $this->levelcoordinator_model->get_session(58);
		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
		
		return view('levelcoordinator/compute_result', $data);

	}
	
	public function verify_result()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'Exam Results',
			'page_subtitle' => 'Verification',
			'current_ss' => $this->portal_config['reg_session'],
			'user' => $this->session->get('name')
		];

		$session = $this->session->get('current_session');
		$id = $this->session->get('programme_id');
		$level = $this->session->get('level');

		$data['student'] = $this->levelcoordinator_model->get_registered_students($id, $level, $session);
		
		return view('levelcoordinator/verify_result', $data);

	}

	public function configuration_action(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		if($this->request->getMethod() == 'post'){
		    
		    $session = $this->session->get("current_session");

			if($this->request->getPost('action') == 'credit_limit'){

			    $username = $this->session->get('username');
				$minimum = $this->request->getVar("minimum");
				$maximum = $this->request->getVar("maximum");
                
                if($minimum >= 15){
                    if($this->levelcoordinator_model->update_credit_limit($username, $minimum, $maximum)){
					//$this->session->setTempdata('saveSuccess','Credit Unit Added Successfully',3);
					return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveSuccess', 'Saved Successfully');
    				}else{
    					//$this->session->setTempdata('saveError','Oops! Something went wrong',3);
    					return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveError','Oops! Something went wrong');
    				}
                }else{
                    return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveError','Oops! Minimum credit units sholud not be less than 15');
                }
				

			}// End of Save Credit Limit

			if($this->request->getPost('action') == 'core_course'){

				$username = $this->session->get('username');
				$core_courses = $this->request->getVar("core_course");
	
				foreach($core_courses as $co){
					
					$selected_core = explode("-",$co);
					
					$code = $selected_core[0];
					$title = $selected_core[1];
					$unit = $selected_core[2];
					$semester = $selected_core[3];
	
					$data = [
						'code' => $code,
						'title' => $title,
						'unit' => (int) $unit,
						'semester' => $semester,
						'selected_programme' => $this->session->get('programme_id'),
						'status' => 'Core',
						'added_by' => $this->session->get('staff_id'),
						'session' => $session
					];
	
					$save_status = "";
					if($this->levelcoordinator_model->save_core_courses($data)){
						$save_status = true;
						//$this->session->setTempdata('saveSuccess','Credit Unit Added Successfully',3);
						//return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveSuccess', 'Saved Successfully');
					}else{
						$save_status = false;
						//$this->session->setTempdata('saveError','Oops! Something went wrong',3);
						//return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveError','Oops! Something went wrong');
					}
				}
	
				if($save_status){
					return redirect()->to(base_url('lev-configurations'))->with('saveSuccess', 'Saved Successfully');
				}else{
					return redirect()->to(base_url('lev-configurations'))->with('saveError','Oops! Something went wrong');
				}
	
			}//End Save Core Course

			if($this->request->getPost('action') == 'elective_course'){

				$username = $this->session->get('username');
				$core_courses = $this->request->getVar("elective_course");

				foreach($core_courses as $co){
					
					$selected_core = explode("-",$co);
					
					$code = $selected_core[0];
					$title = $selected_core[1];
					$unit = $selected_core[2];
					$semester = $selected_core[3];

					$data = [
						'code' => $code,
						'title' => $title,
						'unit' => (int) $unit,
						'semester' => $semester,
						'selected_programme' => $this->session->get('programme_id'),
						'status' => 'Elective',
						'added_by' => $this->session->get('staff_id'),
						'session' => $session
					];

					$save_status = "";
					if($this->levelcoordinator_model->save_elective_courses($data)){
						$save_status = true;
						//$this->session->setTempdata('saveSuccess','Credit Unit Added Successfully',3);
						//return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveSuccess', 'Saved Successfully');
					}else{
						$save_status = false;
						//$this->session->setTempdata('saveError','Oops! Something went wrong',3);
						//return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveError','Oops! Something went wrong');
					}
				}

				if($save_status){
				    //return redirect()->to(base_url('lev-verify'))->with('saveError','Oops! Something went wrong');
					return redirect()->to(base_url('lev-configurations'))->with('saveSuccess', 'Saved Successfully');
				}else{
					return redirect()->to(base_url('lev-configurations'))->with('saveError','Oops! Something went wrong');
				}

			}//End of Save Elective Coure

			if($this->request->getPost('action') == 'delete_course'){
	            $error = '';
	            $success = '';
				if($this->levelcoordinator_model->delete_selected_course($this->request->getPost('id'))){
					$success = "Course deleted successfully";
				}else{
					$error = "Oops! Something went wrong. Try later.";
				}
    
	            $output = array(
	                'error'		=>	$error,
	                'success'	=>	$success
	            );
            	echo json_encode($output);

			}//End of Delete Course
		}		

	}

	public function credit_limit_action()
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$username = $this->session->get('username');
		$minimum = $this->request->getVar("minimum");
		$maximum = $this->request->getVar("maximum");

		if($this->levelcoordinator_model->update_credit_limit($username, $minimum, $maximum)){
			//$this->session->setTempdata('saveSuccess','Credit Unit Added Successfully',3);
			return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveSuccess', 'Saved Successfully');
		}else{
			//$this->session->setTempdata('saveError','Oops! Something went wrong',3);
			return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveError','Oops! Something went wrong');
		}
	}

	public function add_drop()
	{
	
		if($this->request->getMethod() == 'post'){

			if(isset($_POST['add_course'])){
				echo "jhh";
			}else if(isset($_POST['drop_course'])){

			}

		}
	}
	
	function save_transfer_grades()
	{
	
		if($this->request->getMethod() == 'post'){
		    
		    $profile_id = $this->request->getPost('transfer_id');
		    
		    foreach($this->request->getPost('transfer_course') as $key => $value){
		        
		        $data = [
					'profile_id' => $profile_id,
					'course_id' => $value,
					'semester' => '1st',
					'grade' => $this->request->getPost('transfer_grade')[$key]
				];
    		    
    		    $flag = $this->levelcoordinator_model->save_transfer_grade($data);
		    }

			if($flag){
					return redirect()->to(base_url('lev-transfer'))->with('saveSuccess', 'Saved Successfully');
			}else{
				return redirect()->to(base_url('lev-transfer'))->with('saveError','Oops! Something went wrong');
			}
		
		}
	}

	// get semesters available
	function get_semester_submission($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$staff_no = $this->session->get('id');
		$username = $this->session->get('username');
		$programme = $this->levelcoordinator_model->get_semester($username, $session);
		
		$value = [];
		$output = "";
		if(!empty($programme)){
			$output .= '<div class="form-group">
			<label class="label"><b>Select Semester:</b></label><br/>
			<select class="form-control select2" name="semester" id="semester" onchange="spawn_submission()" required> 
			<option selected disabled value="">-Semester-</option>';
			foreach($programme as $prog){
				$output .= "<option value = ".$prog->semester.">".$prog->semester."</option>";                                            
			}
			$output .= "</select> <i></i><b class='tooltip tooltip-bottom-right'>Labels</b></section>";
		}else{
			$output .= '<br/><div class="alert alert-danger alert-dismissible"><i class="icon fas fa-exclamation-triangle"></i> No result submission for this session!</div>';
		}
					
		echo $output;
	}
	
	// get students verification available
	function get_student_verification($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$staff_no = $this->session->get('id');

		$id = $this->session->get('programme_id');
		$level = $this->session->get('level');
		
		$session_started = $this->session->get('session_started');
		
		$initial = substr($session_started, 0, 4);
		$current = substr($session, 0, 4);
		
		$f_level = 0;
		if($current - $initial == 0){
		    $f_level = 100;
		}else{
		    $f_level = (($current - $initial) * 100) + 100;
		}
		
		$student = $this->levelcoordinator_model->get_registered_students($id, $f_level, $session);
		
		$value = [];
		$output = "";
		if(!empty($student)){
			$output .= '<div class="form-group">
					<label class="label"><b>Select Student:</b></label>
					<select class="form-control select2" name="semester" id="student" onchange="spawn_verify_courses()" required> 
					<option selected disabled value="">-Student-</option>';
			foreach($student as $stud){
			    $stud_id = $stud->student_id;
			    $output .= "<option value = ".$stud->student_id.">".$stud->registration_no."</option>";                                                          
				                                          
			}
			$output .= "</select>";
		}else{
			//$output .= "<br/><br/><h4>There is no result available for this session</h4>";
			$output .= '<br/><div class="alert alert-danger alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                  <i class="icon fas fa-exclamation-triangle"></i> No student registered for this session yet!
                </div>';
		}
					
		echo $output;
	}

	// get semesters available
	function get_semester_available($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$staff_no = $this->session->get('id');

		$username = $this->session->get('username');
		$programme = $this->levelcoordinator_model->get_semester($username, $session);
		
		$value = [];
		$output = "";
		if(!empty($programme)){
			$output .= '<div class="form-group">
					<label class="label"><b>Select Semester:</b></label>
					<select class="form-control select2" name="semester" id="semester" onchange="spawn_result()" required> 
					<option selected disabled value="">-Semester-</option>';
			foreach($programme as $prog){
				$output .= "<option value = ".$prog->semester.">".$prog->semester."</option>";                                            
			}
			$output .= "</select>";
		}else{
			//$output .= "<br/><br/><h4>There is no result available for this session</h4>";
			$output .= '<br/><div class="alert alert-danger alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                  <i class="icon fas fa-exclamation-triangle"></i> No result available for this session yet!
                </div>';
		}
					
		echo $output;
	}
	
	function get_verification_course($session, $student)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$student = urldecode($student);
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		
		$courses = $this->levelcoordinator_model->get_student_courses($student, $session);
		
		
		$output = "";
		if(!empty($courses)){
			$output .= '<div class="form-group">
					<label class="label"><b>Select Course:</b></label>
					<select class="form-control select2" name="semester" id="course" onchange="spawn_verify_grades()" required> 
					<option selected disabled value="">-Course-</option>';
					foreach($courses as $co){
				        $output .= "<option value = ".$co->course_id.">".$co->title."</option>";                                            
			        }
			
			$output .= "</select>";
		}else{
			//$output .= "<br/><br/><h4>There is no result available for this session</h4>";
			$output .= '<br/><div class="alert alert-danger alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                  <i class="icon fas fa-exclamation-triangle"></i> The Student did not register for any course!
                </div>';
		}
					
		echo $output;
	}
	
	function get_verification_grades($session, $student, $course)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$student = urldecode($student);
		$course = urldecode($course);
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		
		$grades = $this->levelcoordinator_model->get_verify_grade($student, $course, $session);
		
		
		$output = "";
		if(!empty($grades)){
		    foreach($grades as $gr){
		        $reg_no = $gr->reg_no;
		        $ca = $gr->ca_marks;
		        $exam = $gr->exam_marks;
		        $total = $gr->total_marks;
		        $grade = $gr->grade;
		        $instance_id = $gr->result_instance_id;
		    }
		    
			$output .= '<div class="row">';
			$output .= '<input type = "text" name = "reg_no" value = '.$reg_no.' hidden>';
			$output .= '<input type = "text" name = "instance" value = '.$instance_id.' hidden>';
			$output .=    "<div class='col-md-3'><div class='form-group'><strong>CA:</strong> <input class='form-control' type = 'text' value = ".$ca." name = 'ca' id = 'ca' onchange = ca_validation()></div></div>";
			$output .=    "<div class='col-md-3'><div class='form-group'><strong>Exam:</strong> <input class='form-control' type = 'text' value = ".$exam." name = 'exam' id = 'exam' onchange = exam_validation()></div></div>";
			$output .=    "<div class='col-md-3'><div class='form-group'><strong>Total:</strong> <input class='form-control' type = 'text' value = ".$total." name = 'total' id = 'total' readonly></div></div>";
			$output .=    "<div class='col-md-3'><div class='form-group'><strong>Grade:</strong> <input class='form-control' type = 'text' value = ".$grade." name = 'grade' id = 'grade' readonly></div></div>";
			    
			$output .= '<div class="row">
			    <div class="col-md-12"><div class="form-group"><button class="btn btn-primary save" type = "submit">Save Changes</button></div></div>';	
			
			$output .= "</div>";
		}else{
		
			$output .= '<br/><div class="alert alert-danger alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                  <i class="icon fas fa-exclamation-triangle"></i> No Submission for such course!
                </div>';
		}
					
		echo $output;
	}
	
	public function save_verify_result(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		if($this->request->getMethod() == 'post'){

		    $reg_no = $this->request->getVar("reg_no");
			$instance = $this->request->getVar("instance");
			$ca = $this->request->getVar("ca");
			$exam = $this->request->getVar("exam");
			$total = $this->request->getVar("total");
			$grade = $this->request->getVar("grade");

			if($this->levelcoordinator_model->save_verify_result($reg_no, $instance, $ca, $exam, $total, $grade)){
				//$this->session->setTempdata('saveSuccess','Credit Unit Added Successfully',3);
				return redirect()->to(base_url('lev-verify'))->with('saveSuccess', 'Saved Successfully');
			}else{
				//$this->session->setTempdata('saveError','Oops! Something went wrong',3);
				return redirect()->to(base_url('lev-verify'))->with('saveError','Oops! Something went wrong');
			}
			
		}
		
	}

	//View students
	function get_students($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$session_value = urldecode($session);
		$session = str_replace("_","/",$session_value);
		$id = $this->session->get('programme_id');
		$username = $this->session->get('username');
		
		$session_started = $this->session->get('session_started');
		
		/*$initial = substr($username, 0, 4);
		$current = substr($username, 0, 4);
		
		$f_level = 0;
		if($current - $initial == 0){
		    $f_level = 100;
		}else{
		    $f_level = (($current - $initial) * 100) + 100;
		}*/
		
		$initial = substr($username, 3, 2);
	    $current = substr($this->portal_config['reg_session'], 2, 2);
		$f_level = 0;
		
		if($current - $initial == 0 || $current - $initial == 1){
		    $f_level = (($current - $initial) * 100) + 100;
		}else if($current - $initial == 3 || $current - $initial == 4){
		    $f_level = ($current - $initial) * 100;
		}else if($current - $initial == 5){
		    $f_level = "SO1";
		}else if($current - $initial == 6){
		    $f_level = "SO2";
		}
		
		echo $f_level;

		$student = $this->levelcoordinator_model->get_registered_students($id, $f_level, $session);
		//$student = $this->levelcoordinator_model->get_registered_students($level, $session);
		$output = "";
		$course_registration_dialog = "";
		
		if($student){

			
			$output .= "<div class='row'  >
	
			<div class='col-md-12 table-responsive' > 
			<table id='example1' class='table table-bordered table-striped'>
					<thead>
				   <tr>
						<th>S/N</th> 
						<th>Full Name</th>
						<th>Registration Number</th>
						<th>Current Level</th>
						<th class='text-center'>Action</th>
						
					  </tr>
			   </thead>
			<tbody>";
			$i = 1;
			foreach($student as $stud){	

				$reg_no = $stud->registration_no;
				$id_value = "#".$stud->registration_no;
				$output .= "<tr><td>".$i."</td>";
				$output .= "<td>".$stud->first_name." ".$stud->middle_name." ".$stud->last_name."</td>";
				$output .= "<td>".$stud->registration_no."</td>";
				$output .= "<td>".$stud->level."</td>";
				$output .= '<td class="text-center"><button data-id = '.$stud->id.' class="btn btn-primary btn-xs view_student"> <i class="fas fa-user"> View Details</i></button></td>';
				$output .= "</tr>";
				$i++;
				
			}							
	
			$output .="</tbody>
			</table>
			</div>
			</div>";


		}else{
			$output .= '<div class="alert alert-danger"><i class="icon fas fa-exclamation-triangle"></i> No students for the selected session</div>';
		}
	
		echo $output;
		
	}
	
	//View transfer students
	function get_transfer_students($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$session_value = urldecode($session);
		$session = str_replace("_","/",$session_value);
		$id = $this->session->get('programme_id');
		
		$session_started = $this->session->get('session_started');
		
		$initial = substr($session_started, 0, 4);
		$current = substr($session, 0, 4);
		
		$f_level = 0;
		if($current - $initial == 0){
		    $f_level = 100;
		}else{
		    $f_level = (($current - $initial) * 100) + 100;
		}
		
		$year = substr($session, 0, 4);

		$transfer_student = $this->levelcoordinator_model->get_transfered_students($id, $f_level, $current);
		//$student = $this->levelcoordinator_model->get_registered_students($level, $session);
		$output = "";
		$course_registration_dialog = "";
		
		if($transfer_student){

			
			$output .= "<div class='row'  >
	
			<div class='col-md-12 table-responsive' > 
			<table id='example1' class='table table-bordered table-striped'>
					<thead>
				   <tr>
						<th>S/N</th> 
						<th>Full Name</th>
						<th>Registration Number</th>
						<th>Admitted Level</th>
						<th class='text-center'>Action</th>
						
					  </tr>
			   </thead>
			<tbody>";
			$i = 1;
			foreach($transfer_student as $stud){
			    
			    $grade_status = $this->levelcoordinator_model->get_transfer_grade_status($stud->id);

				$reg_no = $stud->registration_no;
				$id_value = "#".$stud->registration_no;
				$output .= "<tr><td>".$i."</td>";
				$output .= "<td>".$stud->first_name." ".$stud->middle_name." ".$stud->last_name."</td>";
				$output .= "<td>".$reg_no."</td>";
				$output .= "<td>".$stud->level."</td>";
				
				$output .= ($grade_status) ? '<td class="text-center"><button data-id = '.$stud->id.' class="btn btn-primary btn-xs transfer_students_grades"> <i class="fas fa-eye">  View Course</i></button></td>' : '<td class="text-center"><button data-id = '.$stud->id.' class="btn btn-primary btn-xs transfer_students"> <i class="fas fa-book">  Configure</i></button></td>';
				$output .= "</tr>";
				$i++;
				
			}							
	
			$output .="</tbody>
			</table>
			</div>
			</div>";


		}else{
			$output .= '<div class="alert alert-danger"><i class="icon fas fa-exclamation-triangle"></i> No students for the selected session</div>';
		}
	
		echo $output;
		
	}

	function get_student_details(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		if ($this->request->getPost()) {
			$my_id = $this->request->getPost("my_id");
			$student = $this->levelcoordinator_model->get_student_details($my_id);
			$output = "";

			if($student){

				foreach($student as $stud){	
					$student_name = $stud->first_name." ".$stud->middle_name." ".$stud->last_name;
					$output .= '
		              	<div class="tab-content">
	  						<div class="active tab-pane" id="biodata">
	  							<div class="row text-center">
	  								<div class="col-md-12">
	  								<img class="profile-user-img img-fluid img-circle" src=" '.base_url('public/pictures/1539.jpg').'" style="width: 120px;" alt="Student profile picture">
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-12">
	  								<div class="form-group">
									<label>Full Name</label>
									<input class="form-control" value = "'.$student_name.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>UTME No.</label>
									<input class="form-control" value = "'.$stud->utme_no.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Registration No.</label>
									<input class="form-control" value = "'.$stud->registration_no.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>level</label>
									<input class="form-control" value = "'.$stud->level.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Gender</label>
									<input class="form-control" value = "'.$stud->gender.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Date of Birth</label>
									<input class="form-control" value = "'.$stud->birthdate.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Marital</label>
									<input class="form-control" value = "'.$stud->marital_status.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Religion</label>
									<input class="form-control" value = "'.$stud->religion.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Tribe</label>
									<input class="form-control" value = "'.$stud->tribe.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>State of Origin</label>
									<input class="form-control" value = "'.$stud->state_of_origin.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  						</div>
	  						<div class="tab-pane" id="contact">
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Email</label>
									<input class="form-control" value = "'.$stud->email.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Phone</label>
									<input class="form-control" value = "'.$stud->phone.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Contact Address</label>
									<textarea class="form-control" rows="3" disabled>'.$stud->contact_address.'</textarea>
	  								</div>
	  								</div>
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Permanent Address</label>
									<textarea class="form-control" rows="3" disabled>'.$stud->contact_address.'</textarea>
	  								</div>
	  								</div>
	  							</div>
	  						</div>
	  						<div class="tab-pane" id="nok">
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Name</label>
									<input class="form-control" value = "'.$stud->next_of_kin_name.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Phone</label>
									<input class="form-control" value = "'.$stud->next_of_kin_phone.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Address</label>
									<textarea class="form-control" rows="3" disabled>'.$stud->next_of_kin_address.'</textarea>
	  								</div>
	  								</div>
	  							</div>
	  						</div>
	  						<div class="tab-pane" id="sponsor">
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Sponsorship Type</label>
									<input class="form-control" value = "'.$stud->sponsorship_type.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Sponsor Name</label>
									<input class="form-control" value = "'.$stud->sponsor_name.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Sponsor Phone</label>
									<input class="form-control" value = "'.$stud->sponsor_phone.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Sponsor Email</label>
									<input class="form-control" value = "'.$stud->sponsor_email.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Sponsor Address</label>
									<textarea class="form-control" rows="3" disabled>'.$stud->sponsor_address.'</textarea>
	  								</div>
	  								</div>
	  							</div>
	  						</div>
		              	</div>';
				}
	    	}else{
	    		$output .="No record found";
	    	}
	        echo json_encode($output);
		}
	}
	
	function get_transfer_courses(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		if ($this->request->getPost()) {
		    
			$my_id = $this->request->getPost("my_id");
			$student = $this->levelcoordinator_model->get_student_details($my_id);
			
			$courses = $this->levelcoordinator_model->get_courses_by_programme($this->session->get('programme_id'));
			$output = "";
			
		
		    $courses = $this->levelcoordinator_model->get_courses_by_programme($this->session->get('programme_id'));
			$output .= '
  							<input type = "text" id = "profile_id" name = "transfer_id" value ="'.$my_id.'" hidden>
  							<div id = "show_item">
  							
  						<div class="row">
  							<div class="col-md-8">
  							<div class="form-group">
						    <select class="form-control select2" name="transfer_course[]" id="course" required> 
	                            <option selected disabled value="">-Course-</option>';
	                            foreach($courses as $co){
	                                $output .= '<option value='.$co->id.'>'.$co->id.' - '.$co->title.'</option>';
	                            }
	                            $output .='</select>
  							</div>
  							</div>
  							
  							<div class="col-md-2">
  							<div class="form-group">
							<select class="form-control select2" name="transfer_grade[]" id="grade"  required> 
	                            <option selected disabled value="">-Grade-</option>
	                            <option value="A">A</option>
	                            <option value="B">B</option>
	                            <option value="C">C</option>
	                            <option value="D">D</option>
	                            <option value="E">E</option>
	                            <option value="F">F</option>
	                            </select>
  							</div>
  							</div>
  							
  							<div class="col-md-2">
  							    <button class ="btn btn-success add_course_btn" >Add More</button>
  							</div>
  							
  							
  						</div>
  						
  						</div>
  						';
	
	        echo json_encode($output);
		}
	}
	
		function get_transfer_courses_grades(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		if ($this->request->getPost()) {
		    
			$my_id = $this->request->getPost("my_id");
			$student = $this->levelcoordinator_model->get_student_details($my_id);
			$transfer_grade = $this->levelcoordinator_model->get_transfer_grades($my_id);
			$output = "";
			$output .= "<div class='col-md-12 table-responsive' > 
			<table id='example1' class='table table-bordered table-striped'>
					<thead>
				   <tr>
						<th>S/N</th> 
						<th>Code</th>
						<th>Title</th>
						<th>Semester</th>
						<th>Grade</th>
						
					  </tr>
			   </thead>
			<tbody>";
			$i = 1;
			foreach($transfer_grade as $stud){
			    
			    $grade_status = $this->levelcoordinator_model->get_transfer_grade_status($stud->id);

				$output .= "<tr><td>".$i."</td>";
				$output .= "<td>".$stud->profile_id."</td>";
				$output .= "<td>".$stud->course_id."</td>";
				$output .= "<td>".$stud->semester."</td>";
				$output .= "<td>".$stud->grade."</td>";
				$output .= "</tr>";
				$i++;
				
			}							
	
			$output .="</tbody>
			</table>
			</div>
			</div>";
				
			
	        echo json_encode($output);
		}
		
		}
//
	//View list course registrations
	function get_course_registrations($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$session_value = urldecode($session);
		$session = str_replace("_","/",$session_value);
		$id = $this->session->get('programme_id');
		$session_started = $this->session->get('session_started');
		
		$initial = substr($session_started, 0, 4);
		$current = substr($session, 0, 4);
		
		$f_level = 0;
		if($current - $initial == 0){
		    $f_level = 100;
		}else{
		    $f_level = (($current - $initial) * 100) + 100;
		}

		$student = $this->levelcoordinator_model->get_registered_students($id, $f_level, $session);
		$output = "";
		$course_registration_dialog = "";
		$add_course_dialog = "";
		
		if($student){

			foreach($student as $stud){
				if($this->levelcoordinator_model->get_registration_status($stud->student_id, $session)){				
					$stud->status = "Registered";
				}else{
					$stud->status = "Not Registered";
				}
			}
			
			$output .= "<div class='row'  >
	
			<div class='col-md-12 table-responsive' > 
			<table id='example1' class='table table-bordered table-striped'>
					<thead>
				   <tr>
						<th>S/N</th> 
						<th>Full Name</th>
						<th>Registration Number</th>
						<th>Status</th>
						<th>Action</th>
						
					  </tr>
			   </thead>
			<tbody>";
			$i = 1;
			foreach($student as $stud){		
				$reg_no = $stud->registration_no;
				$id_value = "#".$stud->registration_no;
				$output .= "<tr><td>".$i."</td>";
				$output .= "<td>".$stud->first_name." ".$stud->middle_name." ".$stud->last_name."</td>";
				$output .= "<td>".$stud->registration_no."</td>";
				if($stud->status == "Not Registered"){ 
				    $output .= "<td><span class='badge badge-danger'>".$stud->status."</span></td>";
					$output .= "<td><button type = 'submit' disabled class='btn btn-primary btn-xs'><i class='fa fa-eye' disabled></i> View CRF</button></td>";
				}else{ 
					//echo $stud->status;
				    $output .= "<td><span class='badge badge-success'>".$stud->status."</span></td>";
					$output .= '<td><a href = '.$id_value.'  data-toggle="modal"><button  class="btn btn-primary btn-xs"><i class="fa fa-eye"></i> View CRF</button></a></td>';
				} 
				$output .= "</tr>";
				$i++;

				$add_dialog_id = "#".$reg_no."_";
				$course_registration_dialog .= '<div class="modal hide fade in" data-backdrop="static" id='.$reg_no.' >
							<div class="modal-dialog modal-xl">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"><span class="badge badge-secondary">Full Name: </span>'.$stud->first_name.' '.$stud->middle_name.' '.$stud->last_name.'<br/><span class="badge badge-secondary">Reg. No.: </span>'.$reg_no.'<br/><span class="badge badge-secondary">Session: </span>'.$session.'<br/></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body">
								<table id="example11" class="table table-bordered table-striped" width="100%">
								<thead>
								<tr>
									<th>S/N</th> 
									<th>Course Code</th>
									<th>Course Title</th>
									<th>Credits Unit</th>
									<th>Semester</th>
								</tr>
						</thead>
						<tbody>';
								
						$courses = $this->levelcoordinator_model->get_student_courses($stud->student_id, $session);

						$index = 1;
						if($courses){
						   foreach($courses as $co){
							$course_registration_dialog .= "<tr><td>".$index++."</td>";
							$course_registration_dialog .= "<td>".$co->course_id."</td>";
							$course_registration_dialog .= "<td>".$co->title."</td>";
							$course_registration_dialog .= "<td>".$co->credit_units."</td>";
							$course_registration_dialog .= "<td>".$co->semester."</td>";
							$course_registration_dialog .= "</tr>";
						  } 
						}else{
						    
						}
						
								$course_registration_dialog .="
								</tbody>
								</table>
								<div class='modal-footer justify-content-between'>
								<button type='button' class='btn btn-default' data-dismiss='modal'>Close</button>
								
								</div>
								</div>
								</div>
								</div>
								</div>";

								

			}							
	
			$output .="</tbody>
			</table>
			</div>
			</div>";


		}else{
			$output .= '<div class="alert alert-danger"><i class="icon fas fa-exclamation-triangle"></i> No students for the selected session</div>';
		}
	
		echo $output;
		echo $course_registration_dialog;
		echo $add_course_dialog;
	}
	
	//View list of registered course
	function get_course_enrollments($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$session_value = urldecode($session);
		$session = str_replace("_","/",$session_value);
		$programme_id = $this->session->get('programme_id');
		$username = $this->session->get('username');
		$year_admitted =  substr($username, 3, 2);
		$year_admitted = (int) "20".$year_admitted;
		$current_session = substr($session, 0, 4);
		$level = ((int) substr($session, 0, 4) - $year_admitted) * 100;
		if($level == 0){
		    $level = 100;
		}
		//$level = (int) $level;

		$courses = $this->levelcoordinator_model->get_student_registered_courses($programme_id, $session, $level);
		$output = "";
		$course_registration_dialog = "";
		
		
		if($courses){

			
			
			$output .= "<div class='row'  >
	
			<div class='col-md-12 table-responsive' > 
			<table id='example1' class='table table-bordered table-striped'>
					<thead>
				   <tr>
						<th>S/N</th> 
						<th>Code</th>
						<th>Title</th>
						<th>Number of Students</th>
						<th>Semester</th>
						<th>Action</th>
						
					  </tr>
			   </thead>
			<tbody>";
			$i = 1;
			foreach($courses as $co){		
				$code = $co->course_id;
				$id_value = "#".$co->course_id;
				$students_enrollemnt = $this->levelcoordinator_model->get_enrolled_students($programme_id, $code, $level, $session);
				
				$output .= "<tr><td>".$i."</td>";
				$output .= "<td>".$code."</td>";
				$output .= "<td>".$co->title."</td>";
				$output .= "<td>".count($students_enrollemnt)."</td>";
				$output .= "<td>".$co->semester."</td>";
			    $output .= '<td><a href = '.$id_value.'  data-toggle="modal"><button  class="btn btn-primary btn-xs"><i class="fa fa-eye"></i> View CRF</button></a></td>';
			
				$output .= "</tr>";
				$i++;
				
				
				
				$course_registration_dialog .= '<div class="modal hide fade in" data-backdrop="static" id='.$code.' >
							<div class="modal-dialog modal-xl">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"><span class="badge badge-secondary">Full Name: </span>'.$code.'<br/><span class="badge badge-secondary">Reg. No.: </span>'.$co->title.'<br/><span class="badge badge-secondary">Session: </span>'.$session.'<br/></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body">
								<table id="example11" class="table table1 table-bordered table-striped" width="100%">
								<thead>
								<tr>
									<th>S/N</th> 
									<th>Registration Number</th>
									<th>Full Name</th>
									<th>Contact Number</th>
									
								</tr>
						</thead>
						<tbody>';
								
						        	$index = 1;
						if($students_enrollemnt){
						   foreach($students_enrollemnt as $stud){
							$course_registration_dialog .= "<tr><td>".$index++."</td>";
							$course_registration_dialog .= "<td>".$stud->registration_no."</td>";
							$course_registration_dialog .= "<td>".$stud->first_name.' '.$stud->middle_name.' '.$stud->last_name."</td>";
							$course_registration_dialog .= "<td>".$stud->phone."</td>";
							$course_registration_dialog .= "</tr>";
						  } 
						}else{
						    
						}
						
								$course_registration_dialog .="
								</tbody>
								</table>
								<div class='modal-footer justify-content-between'>
								<button type='button' class='btn btn-default' data-dismiss='modal'>Close</button>
								
								</div>
								</div>
								</div>
								</div>
								</div>";

								

			}							
	
			$output .="</tbody>
			</table>
			</div>
			</div>";


		}else{
			$output .= '<div class="alert alert-danger"><i class="icon fas fa-exclamation-triangle"></i> No courses enrollments for this session</div>';
		}
	
		echo $output;
		echo $course_registration_dialog;
	}

	//View list of submitted result
	function get_result_submitted($semester, $session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$semester = urldecode($semester);
		$programme_id = $this->session->get("programme_id");
		$username = $this->session->get('username');
		$year_admitted = substr($username, 3, 2);
		$year_admitted = (int) "20".$year_admitted;
		$level = (int) substr($session, 0, 4) - $year_admitted + 100; //naz echo $level.' '.(int) substr($session, 0, 4).' '.$year_admitted;
		
		$program_details = $this->levelcoordinator_model->get_program_detail($programme_id);
		$output = "";
		$view_dialog = "";
		if(!empty($semester)){
			$submission = $this->levelcoordinator_model->get_submission_instance_result($username, $session, $semester);

			if($submission){
				foreach($submission as $sub){  //naz
					if($sub->lecturer_id == "GSP" || $sub->lecturer_id == "GST"){
						$sub->lecturer = "GSP Coordinator";
					}else{
						$details = $this->hod_model->get_staff_details($sub->lecturer_id);
						$sub->lecturer = $details['name']; 
					}
	
					$cdetails = $this->levelcoordinator_model->get_course_details($sub->course_id);
					$sub->course_title = $cdetails['title']; 
				}
				
				$output .= "<div class='row'>
		
				<div class='col-md-12 table-responsive' > 
				<table id='example1' class='table table-bordered table-striped'>
						<thead>
					   <tr>
							<th>S/N</th> 
							<th>Course Code</th>
							<th>Course Title</th>
							<th>Lecturer</th>
							<th>Action</th>
							
						  </tr>
				   </thead>
				<tbody>";
				$i = 1;
				foreach($submission as $sub){	
					
					$output .= "<tr><td>".$i++."</td>";
					$output .= "<td>".$sub->course_id."</td>";
					$output .= "<td>".$sub->course_title."</td>";
					$output .= "<td>".$sub->lecturer."</td>";
						$id_value = "#".$sub->id;
						$id_real = $sub->id;
						$output .= '<td><button title="View" class="btn btn-info btn-xs" data-target = '.$id_value.' data-toggle="modal" ><i class="fas fa-eye"></i> View</button> 
						</td>';
						
						$view_dialog .= '<div class="modal fade" id='.$sub->id.' >
								<div class="modal-dialog modal-lg">
								  <div class="modal-content">
									<div class="modal-header">
    								  <h5 class="modal-title"><span class="badge badge-secondary">Course: </span>'.$sub->course_id.': '.$sub->course_title.'<br/>
    								  <span class="badge badge-secondary">Session: </span>'.$session.'</h5>
									  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
										<span aria-hidden="true">&times;</span>
									  </button>
									</div>
									<div class="modal-body">
									
									<table id="example11" class="table table1 table-bordered table-striped">
									<thead>
									<tr>
										<th>S/N</th> 
										<th style="width:15%" >Registration Number</th>
										<th style="width:45%" >Full Name</th>
										<th>CA</th>
										<th>Exam</th>
										<th>Total</th>
										<th>Grade</th>
									</tr>
									</thead>
									<tbody>';
				
									$result = $this->lecturer_model->get_marks($sub->id);
									$index = 1;
									$color = '';
									if(!empty($result)){
									foreach($result as $res){
										if($res->grade == 'F'){
											$color = 'text-danger';
										}

										$view_dialog .= '<tr class="'.$color.'">';
										$view_dialog .= '<td>'.$index++.'</td>';
										$view_dialog .= '<td>'.$res->reg_no.'</td>';
										$view_dialog .= '<td>'.$res->first_name.' '.$res->middle_name.' '.$res->last_name.'</td>';
										$view_dialog .= '<td>'.$res->ca_marks.'</td>';
										$view_dialog .= '<td>'.$res->exam_marks.'</td>';
										$view_dialog .= '<td>'.$res->total_marks.'</td>';
										$view_dialog .= '<td>'.$res->grade.'</td>';
										$view_dialog .= '</tr>';
										$color = '';
									}
									}
									
									$view_dialog .="</tbody>
									</table>
									</div>
									</div>
									</div>
									</div>";
	
					
					$output .= "</tr>";
					
					
				}							
		
				$output .="</tbody>
				</table>
				</div>
				</div>";
			}else{
				$output .= "No record found";
			}
			
			
		}else{
			$output .= "List of Submmission";
		}
		
	
		echo $output;
		echo $view_dialog;
	}

	function gtest(){
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$id = $this->session->get('programme_id');
		$semester = '2nd';
		$session = '2020/2021';
		$programme_id = $this->session->get('programme_id');
		$username = $this->session->get('username');
		$year_admitted = substr($username, 3, 2);
		$year_admitted = (int) "20".$year_admitted;
		$level = (int) substr($session, 0, 4) - $year_admitted + 100;

		echo 'LEVEL = '.$level;
		echo '<br/>ID = '.$id;
		echo '<br/>PROG ID = '.$programme_id;
		echo '<br/>USERNAME = '.$username;
		echo '<br/>YR AD = '.$year_admitted;
		echo '<br/>';

		$submission = $this->levelcoordinator_model->get_submission_instance_result_($programme_id, $session, $semester, $level);
		echo json_encode($submission);

		echo '<br/>';

		$submission_status = "";
		$result_label = "";
		foreach($submission as $sub){
			$result_status = $this->levelcoordinator_model->get_submission_status($sub->course_id, $username, $session);
			if($result_status){	
				if($result_status['hod_status'] == 'Accepted'){
					echo $sub->course_id.'<br/>';
					echo $username.'<br/>';
					echo $session.'<br/>';
					echo 'All is well<br/>';
				}else{
					echo $sub->course_id.'<br/>';
					echo $username.'<br/>';
					echo $session.'<br/>';
					echo "One of the result is yet to be approved<br/>";
				}			
			}else{
					echo $sub->course_id.'<br/>';
					echo $username.'<br/>';
					echo $session.'<br/>';
				echo "Lecturers did not make full submission<br/>";
				break;
			}
		}
	}
	
	// get semesters available
	function get_download_report($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$id = $this->session->get('programme_id');
		$output='';
		
		       $output .= '<div class="row">
		       <div class="col-12">
		        <button type="submit" name = "raw_marks" value = "raw_marks" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Session Report</button>
				</div>
			        
				</div>';
		echo $output;
		
	}
	
	public function download_report(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		if($this->request->getMethod() == 'post'){
		    
		    $this->fpdf->AliasNbPages();
    		$this->fpdf->SetAutoPageBreak(1,13);
    		$this->fpdf->AddPage('P','A4');
    		
    		$logo = "assets/img/nwu_logo.png";
    		
    		// Logo
    		$this->fpdf->Image($logo, 6, 8, 30);
    		// Arial bold 15
    		// Move to the right
    		$this->fpdf->Cell(80);
    		// Title
    		$this->fpdf->setFont('Arial','B',14);
    		$this->fpdf->SetTextColor(0, 0, 0);
    		$this->fpdf->Cell(45,10,'NORTHWEST UNIVERSITY, KANO',0,0,'C');
    		
    		// Line break
    		$this->fpdf->Ln(5);
    		$this->fpdf->setFont('times','',11);
    		$this->fpdf->Cell(190,10,'KANO STATE, NIGERIA',0,0,'C');
    		// Line break
    		$this->fpdf->Ln(7);
    		
    		// Line break
    		$this->fpdf->setFont('times','B',14);
    		$this->fpdf->Cell(190,10,'STUDENT\'S END OF SESSION REPORT FORM',0,0,'C');
    		// Line break
    		$this->fpdf->Ln(2);
    		$this->fpdf->Ln(2);
    		
    		$this->fpdf->SetMargins(5, 0, 0, 0);
    
    		$this->fpdf->Ln(2);
    		$this->fpdf->SetFont('times','B',12);
    
    		$this->fpdf->Ln(8);
    		$this->fpdf->setFillColor(169,169,169);
    		$this->fpdf->Cell(190, 7, 'PERSONAL INFORMATION', 0,0, 'C', 1);
    		
    		$this->fpdf->SetFont('times','B',11);
			$this->fpdf->Ln(6);
			$this->fpdf->Cell(45, 10, 'FULL NAME: ',0,0,'R');
			$this->fpdf->SetFont('times','',11);
    		$this->fpdf->Cell(50, 10, "ABDULAZIZ AMINU");
			
			$this->fpdf->Cell(90, 10, 'REG. NUMBER: ', 0,0,'R');
			//$this->fpdf->Cell("SESSION", 150, 53, 28, 28);
		
    		//$pdf->Cell(30, 80, $pdf->Image($image, $pdf->GetX, $pdf->GetY, 30), 0, 0, 'L');
    		
    		$this->fpdf->SetFont('times','',11);
    		$this->fpdf->Cell(105, 10, "");
    		
    		$this->fpdf->Ln(6);
    		$this->fpdf->SetFont('times','B',11);
    		$this->fpdf->Cell(45, 10, 'FACULTY: ',0,0,'R');
    		
    		$this->fpdf->Cell(105, 10, 'SESSION: ', 0,0,'R');
    		
    		$this->fpdf->SetFont('times','',11);
    		$this->fpdf->Cell(105, 10, "");
    		
    		$this->fpdf->Ln(6);
    		$this->fpdf->SetFont('times','B',11);
    		$this->fpdf->Cell(45, 10, 'DEPARTMENT: ',0,0,'R');
    		
    		$this->fpdf->Cell(105, 10, 'LEVEL: ', 0,0,'R');
    		
    		$this->fpdf->SetFont('times','',11);
    		$this->fpdf->Cell(105, 10, "");
    		
    		$this->fpdf->Ln(6);
    		$this->fpdf->SetFont('times','B',11);
    		$this->fpdf->Cell(45, 10, 'PROGRAMME: ',0,0,'R');
    		
    		$this->fpdf->Cell(105, 10, 'PREVIOUS CGPA: ', 0,0,'R');
    		
    		$this->fpdf->SetFont('times','',11);
    		$this->fpdf->Cell(105, 10, "");
    		
    		
    		$this->fpdf->Ln(8);
    		$this->fpdf->SetFont('times','B',12);
    		$this->fpdf->setFillColor(169,169,169);
    		$this->fpdf->Cell(190, 7, 'REGISTERED COURSES', 0,0, 'C', 1);
    		
    		$this->fpdf->Ln(2);
    		$this->fpdf->SetFont('times','B',12);
    		$this->fpdf->Cell(90, 20, 'First Semester Registered Courses', 0, 0, 'C');
    		$this->fpdf->Cell(100, 20, 'Second Semester Registered Courses', 0, 0, 'C');
    		
    		$this->fpdf->Ln(12);
    		$this->fpdf->SetFont('times','B',10);
    		$this->fpdf->setFillColor(169,169,169);
    		$this->fpdf->Cell(12, 7, "Code", 1, 0, 'L', 1);
    		$this->fpdf->Cell(65, 7, "Title", 1, 0, 'L', 1);
    		$this->fpdf->Cell(10, 7, "Unit", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "Grade", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "GP", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "PE", 1, 0, 'L', 1);
    		
    		$this->fpdf->Cell(3, 7, "", 0, 0, 'L');
    		
    		$this->fpdf->Cell(12, 7, "Code", 1, 0, 'L', 1);
    		$this->fpdf->Cell(65, 7, "Title", 1, 0, 'L', 1);
    		$this->fpdf->Cell(10, 7, "Unit", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "Grade", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "GP", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "PE", 1, 0, 'L', 1);
    
    		$this->fpdf->Ln();
    		$this->fpdf->SetFont('times','',10);
    		
    		$this->response->setHeader('Content-Type','application/pdf');
		    $this->fpdf->Output();
		    
		}
	}

	// get semesters available
	function get_result($semester, $session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$id = $this->session->get('programme_id');
		$semester = urldecode($semester);
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$programme_id = $this->session->get('programme_id');
		$username = $this->session->get('username');
		$year_admitted = substr($username, 3, 2);
		$year_admitted = (int) "20".$year_admitted;
		$level = $this->session->get('level');
		//$level = (int) substr($session, 0, 4) - $year_admitted + 100;
		$lvlCdetails=$this->levelcoordinator_model->get_level_details($username);
	
		$programme = $this->levelcoordinator_model->get_semester($programme_id, $session);
		
		//$submission = $this->levelcoordinator_model->get_student_registered_courses($programme_id, $semester, $session, 100);
		//$submission = $this->levelcoordinator_model->get_submission_instance_result_($programme_id, $session, $semester, $lvlCdetails['current_level']);
			 
		$course = $this->levelcoordinator_model->get_student_registered_semester_courses($programme_id, $semester, $session, $level);
		$student = $this->levelcoordinator_model->get_registered_students_result($programme_id, $level,$session);

		$submission_status = "false";
		$result_label = "";
		//$yet_to_be = "";
		
		/*foreach($course as $sub){ 
			$result_status = $this->levelcoordinator_model->get_submission_status($sub->course_id, $username, $session);
			
			if($result_status){	
				if($result_status['hod_status'] == 'Accepted'){
					$submission_status = true;
				}else{
				    //$yet_to_be .= $sub->course_id.": Not Approved by the Department<br/>";
					
					$submission_status = false;
					$result_label .= "<strong>".$sub->course_id."</strong>: Not Approved by the Department<br/>"; 
				}			
			}else{
			    //$yet_to_be .= "<strong>".$sub->course_id.'</strong><br>';
				$submission_status = false;
				
				$result_label .= "<strong>".$sub->course_id.'</strong>: Not Uploaded <br>';                
				
			}
		}*/

		/*foreach($student as $stud){
			foreach($course as $co){
				$mark = $this->levelcoordinator_model->get_student_marks($stud->id, $co->course_id);
//				$mark = $this->levelcoordinator_model->get_student_marks($stud->profile_id, $co->id);

				$name = $co->course_id;
				if($mark){					
					$stud->$name = $mark['total_marks'];
				}else{
					$stud->$name = "";
				}
			}
		}*/
				
		$value = [];
		$output = "";
		$average_dialog = "";
		$raw_marks_dialog = "";
		$summary_dialog = "";
		
		
		//if(!$submission_status){
		    
		    
		//<button type="submit" name = "mbbs_summary" value = "mbbs_summary" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> View Summary</button>
					
			if($programme_id == 72){
			    $output .= '<div class="row">
			    
			        <div class="col-6">
			        <button type="submit" name = "raw_marks" value = "raw_marks" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Raw Marks</button>
					</div>
			        <div class="col-6">
			        <button type="submit" name = "mbbs_summary" value = "mbbs_summary" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Summary</button>
					</div>
				
				</div>';
			}else{
			    $output .= '<div class="row">
					<div class="col-3">
					<button  type="submit" name = "raw_marks" value = "raw_marks" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Raw Marks</button>
					</div>
					<div class="col-3">
					
					<button type="submit" name = "summary" value = "summary" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Summary</button>
					</div>
					<div class="col-3">
					
					<button type="submit" name = "score_sheet" value = "score_sheet" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Score Sheet</button>
					</div>
					<div class="col-3">
					
					<button type="submit" name = "statistics" value = "statistics" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Statistics</button>
					</div>
					
				</div>';
			}
			
				
		/*}else{
			$output .= '<div class="alert alert-warning alert-dismissible">
                  <h5><i class="icon fas fa-exclamation-triangle"></i> <strong>Alert! The result cannot be compiled due to the following reasons</strong></h5>
                  '.$result_label.'
                </div>';
		}*/
		echo $output;			
		
	}
	
	function get_grade_point($grade) {
        
        if($grade == 'A')
            return 5;
        else if($grade == 'B')
            return 4;
        else if($grade == 'C')
            return 3;
        else if($grade == 'D')
            return 2;
        else if($grade == 'E')
            return 1;
        else if($grade == 'F')
            return 0;
    }

	
	public function download_result(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		if($this->request->getMethod() == 'post'){
		    
		    $id = $this->session->get('programme_id');
	        $session = $this->request->getVar("session");
	        $session = str_replace("_","/",$session);
		    $semester = $this->request->getVar("semester");
		    
		    $programme_id = $this->session->get('programme_id');
    		$username = $this->session->get('username');
    		
    		$initial = substr($username, 3, 2);
		    $current = substr($session, 2, 2);
			$level = 0;
			
			if($current - $initial == 0 || $current - $initial == 1){
			    $level = (($current - $initial) * 100) + 100;
			}else if($current - $initial == 3 || $current - $initial == 4){
			    $level = ($current - $initial) * 100;
			}else if($current - $initial == 5){
			    $level = "SO1";
			}else if($current - $initial == 6){
			    $level = "SO2";
			}
 //   		$level = (int) substr($session, 0, 4) - $year_admitted + 100;
			$lvlCdetails=$this->levelcoordinator_model->get_level_details($username);
//			$level=$lvlCdetails['current_level'];
			   
    		$faculty = $this->session->get('faculty');
			$department = $this->session->get('department');
		    $programme_name = $this->levelcoordinator_model->get_programme_name($programme_id)['title'];
		    
		    $programme = $this->levelcoordinator_model->get_semester($programme_id, $session);
        	$student = $this->levelcoordinator_model->get_registered_students_result($programme_id, $level,$session);	
    		$submission = $this->levelcoordinator_model->get_submission_instance_result($programme_id, $session, $semester, $level);
    		
    		//$course = $this->levelcoordinator_model->get_submitted_result_semester($username, $semester, $session);
    		$course = $this->levelcoordinator_model->get_student_registered_semester_courses($programme_id, $semester, $session, $level);
    		//$student = $this->levelcoordinator_model->get_registered_students($id, $lvlCdetails['current_level'],$session);
    		
    		$num_courses = count($course) + 3;
	        $alpha = array('A','B','C','D','E','F','G','H','I','J','K', 'L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','AA','AB','AC','AD','AE','AF','AG','AH','AI','AJ','AK', 'AL','AM','AN','AO','AP','AQ','AR','AS','AT','AU','AV','AW','AX','AY','AZ','BA','BB','BC','BD','BE','BF','BG','BH','BI','BJ','BK', 'BL','BM','BN','BO','BP','BQ','BR','BS','BT','BU','BV','BW','BX','BY','BZ','CA','CB','CC','CD','CE','CF','CG','CH','CI','CJ','CK', 'CL','CM','CN','CO','CP','CQ','CR','CS','CT','CU','CV','CW','CX','CY','CZ');
	        
	        $highest_letter = $alpha[$num_courses-1];
	        //echo $highest_letter;
	        //exit();
    
    		//$submission_status = "false";
    		
    		
		    if($semester == '1st'){
		        
		        $first = 0;
		        $second_upper = 0;
		        $second_lower = 0;
		        $third = 0;
		        $pass = 0;
		        $probation = 0;
		        
		        $pass_all = 0;
		        $carry_over_case = 0;
		        
    			/*foreach($student as $stud){
    			    
    			    $absent_through = true;
    			    $abs_flag = false; //indicates absent for a course
    			    $absent_flag = false; //indicates absent throughouth the semester
                    $abs = 'ABS in: ';
                    $imcomplete = 'INC in: ';
    			    
    				$tcr = 0;
    				$tce = 0;
    				$tp = 0;
    				$inc = 0; // to sum credit units of incomplete courses
    				$carry_over = "";
    				$remark = "";
    				//$tcr = $this->levelcoordinator_model->get_total_credits($stud->student_id)['total_credits'];
    				
    				$num_course = 0;
    				foreach($course as $co){ 
    					$mark = $this->levelcoordinator_model->get_student_marks($stud->id, $co->id);
    					$name = $co->course_id;
    
    				//	$course_detail = $this->levelcoordinator_model->get_course_detail($co->course_id,$programme_id,$semester); 
						if($lvlCdetails['current_level']==100){
							$course_detail = $this->levelcoordinator_model->get_course_detail($co->course_id,$programme_id,$semester);
					  }else{ echo $semester; 
						$course_detail = $this->levelcoordinator_model->get_course_details_($co->course_id,$semester);
					  }
	                   
					  	if($mark){		
    						//$tcr += $course_detail['credit_unit'];					
    						if($mark['total_marks'] == 'ABS'){
    						    $abs_flag = true;
    						    $absent_flag = true;
    						    
    							$tcr += $course_detail['credit_unit'];
    							$tp += 0 * $course_detail['credit_unit'];
    							$carry_over .= $name.", ";
    							$abs .= $name.', ';
    						}else if($mark['total_marks'] == "I"){
    							$tcr += $course_detail['credit_unit'];
    							$inc += $course_detail['credit_unit'];
    							$remark .= $incomplete.$name.', ';
    							$absent_flag = false;
    							$absent_through = false;
    						}else if($mark['total_marks'] >= 40){
    						    $absent_flag = false;
    						    $absent_through = false;
    							$tcr += $course_detail['credit_unit'];
    							$tce += $course_detail['credit_unit'];
    							if($mark['grade'] == 'A'){
    								$tp += 5 * $course_detail['credit_unit'];	
    							}else if($mark['grade'] == 'B'){
    								$tp += 4 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'C'){
    								$tp += 3 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'D'){
    								$tp += 2 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'E'){
    								$tp += 1 * $course_detail['credit_unit'];
    							}													
    						}else if($mark['total_marks'] < 40){
    						    $absent_through = false;
    						    $absent_flag = false;
    							$tcr += $course_detail['credit_unit'];
    							$tp += 0 * $course_detail['credit_unit'];
    							$carry_over .= $name.", ";
    						}
    					}
    					$num_course++;
    				}
    				if($abs_flag){
    				    	$remark = $abs;
    				}else{
    				    
    				}
    				$stud->tce = $tce;
    				$stud->tcr = $tcr;
    				// if student apply for imcomplete grading in all semester 
    				if($tcr == $inc){
    					$gpa = (double) $tp/1;
    				}else{	
    					$gpa = (double) $tp/($tcr - $inc); // subtract incomplete grading ( 0 if no incomplete grade)
    				}
        			$gpa = round($gpa, 2);
    				$stud->gpa = strlen(strval($gpa)) == 1 ? $gpa.".00" : $gpa;
    				//if($gpa < 1.00)
    					//$remark .= "<br/>On Probarion";
    				$stud->carry_over = $carry_over;
    				$stud->remark = $remark;
    				if($absent_through){
    				    $stud->absent = true;
    				}else{
    				   $stud->absent = false; 
    				}
    				
    			}*/
    	

                $grades_lookup = []; 
                $marks_lookup = []; 
                $units_lookup = []; 

                /*foreach ($grades_data as $row) {
                    
                    $profile_id = $row['profile_id'];     
                    $course_id = $row['course_id'];
                    $units = $row['credit_unit'];
                    $total_marks = $row['total_marks'];  
                    $grade = $row['grade'];
                    
                    // Populate the lookup table with profile_id as the first key and course_id as the second key
                    $grades_lookup[$profile_id][$course_id] = $grade;
                    $marks_lookup[$profile_id][$course_id] = $total_marks;
                    $units_lookup[$profile_id][$course_id] = $units;
                }*/

                                // Assuming this is inside your student loop:
                foreach ($student as $stud) {
                    
                    $profile_id = $stud->id;
                    
                    //if($this->session->get('level') == 100){
                      //  $grades_data = $this->levelcoordinator_model->get_all_grades_each_student_1($profile_id, $programme_id, $semester, $session);
                    //}else{
                        $grades_data = $this->levelcoordinator_model->get_all_grades_each_student_revisited($profile_id, $semester, $session);
                    //}
                    
                    
                    
                    $absent_through = true;
    			    $abs_flag = false; //indicates absent for a course
    			    $absent_flag = false; //indicates absent throughouth the semester
                    $abs = 'ABS in: ';
                    $imcomplete = 'INC in: ';
    			    
    				$tcr = 0;
    				$tce = 0;
    				$tp = 0;
    				$inc = 0; // to sum credit units of incomplete courses
    				$carry_over = "";
    				$remark = "";
    				
    				$num_course = 0;
    				
                    $course_pool = [];
                    // Iterate through each course for the student
                    if ($grades_data) {
                        
                        foreach ($grades_data as $gr) {
                            
                            //if(!in_array($gr->course_id, $course_pool)){
                                
                                //array_push($course_pool, $gr->course_id);
                                
                                $unit = $gr->credit_unit;  
                                $grade = $gr->grade;
                                $total_marks = $gr->total_marks;
                                $course_id = $gr->course_id;
                                
                                //$grades_lookup[$profile_id][$course_id] = $grade;
                                $marks_lookup[$profile_id][$course_id] = $total_marks;
                                $units_lookup[$profile_id][$course_id] = $unit;
                                
                                if($grade == 'ABS' || $grade == '-' || $grade == NULL){
        						    $abs_flag = true;
        						    $absent_flag = true;
        						    
        							$tcr += $unit;
        							$tp += 0 * $unit;
        							$carry_over .= $course_id.", ";
        							$abs .= $course_id.', ';
        						}else if($grade == "I"){
        							$tcr += $unit;
        							$inc += $unit;
        							$remark .= $incomplete.$course_id.', ';
        							$absent_flag = false;
        							$absent_through = false;
        						}else if($grade == 'F'){
        						    
        						    $absent_through = false;
        						    $absent_flag = false;
        							$tcr += $unit;
        							$tp += 0 * $unit;
        							$carry_over .= $course_id.", ";
        						 
        							
        						}else if($grade == 'A' || $grade == 'B' || $grade == 'C' || $grade == 'D' || $grade == 'E'){
        						    
        						    $absent_flag = false;
        						    $absent_through = false;
        							$tcr += $unit;
        							$tce += $unit;
        							
        							$tp += $unit * $this->get_grade_point($grade);
        						    
        						}
                            //}//dd
                        }
                    }
                
                    $stud->tce = $tce;
    				$stud->tcr = $tcr;
    				// if student apply for imcomplete grading in all semester 
    				if($tcr == $inc){
    					$gpa = (double) $tp/1;
    				}else{	
    					$gpa = (double) $tp/($tcr - $inc); // subtract incomplete grading ( 0 if no incomplete grade)
    				}
        			$gpa = round($gpa, 2);
        			if($gpa >= 4.50 && $gpa <= 5.0){
        			    $first++;
        			}else if($gpa >= 3.50 && $gpa <= 4.49){
        			    $second_upper++;
        			}else if($gpa >= 2.40 && $gpa <= 3.49){
        			    $second_lower++;
        			}else if($gpa >= 1.50 && $gpa <= 2.39){
        			    $third++;
        			}else if($gpa >= 1.00 && $gpa <= 1.49){
        			    $pass++;
        			}else if($gpa >= 0.00 && $gpa <= 0.99){
        			    $probation++;
        			}
        			
        			if($tcr == $tce){
        			    $pass_all++;
        			}else{
        			    $carry_over_case++;
        			}
        			
    				$stud->gpa = strlen(strval($gpa)) == 1 ? $gpa.".00" : $gpa;
    				//if($gpa < 1.00)
    					//$remark .= "<br/>On Probarion";
    				$stud->carry_over = $carry_over;
    				$stud->remark = $remark;
    				if($absent_through){
    				    $stud->absent = true;
    				}else{
    				   $stud->absent = false; 
    				}
                }
                

		}else if($semester == '2nd'){


			$overall_courses = $this->levelcoordinator_model->get_overall_courses($id, $this->session->get('username'));
		
			foreach($student as $stud){
			    
			    $absent_through = true;
			    $abs_flag = false; //indicates absent for a course
			    $absent_flag = false; //indicates absent throughouth the semester
                $abs = 'ABS in: ';
                $imcomplete = 'INC in: ';
                
				$tcr = 0;
				$tce = 0;
				$tp = 0;
				$inc = 0; // to sum credit units of incomplete courses
				$overall_inc = 0; // to sum credit units of incomplete courses

				$overall_tcr = 0;
				$overall_tce = 0;
				$overall_tp = 0;

				$carry_over = "";
				$remark = "";
				//$tcr = $this->levelcoordinator_model->get_total_credits($stud->student_id)['total_credits'];
				
				// Calculate Semester GPA
				foreach($course as $co){ 
					$mark = $this->levelcoordinator_model->get_student_marks($stud->id, $co->id);
					$name = $co->course_id;
				//	$course_detail = $this->levelcoordinator_model->get_course_detail($co->course_id,$programme_id,$semester);//($co->course_id);
				if($lvlCdetails['current_level']==100){
					$course_detail = $this->levelcoordinator_model->get_course_detail($co->course_id,$programme_id,$semester);
			  }else{
				$course_detail = $this->levelcoordinator_model->get_course_details_($co->course_id,$semester);
			  }

					
					if($mark){		
						//$tcr += $course_detail['credit_unit'];					
						if($mark['total_marks'] == 'ABS'){
    						    $abs_flag = true;
    						    $absent_flag = true;
    						    
    							$tcr += $course_detail['credit_unit'];
    							$tp += 0 * $course_detail['credit_unit'];
    							$carry_over .= $name.", ";
    							$abs .= $name.', ';
    						}else if($mark['total_marks'] == "I"){
    							$tcr += $course_detail['credit_unit'];
    							$inc += $course_detail['credit_unit'];
    							$remark .= $incomplete.$name.', ';
    							$absent_flag = false;
    							$absent_through = false;
    						}else if($mark['total_marks'] >= 40){
    						    $absent_flag = false;
    						    $absent_through = false;
    							$tcr += $course_detail['credit_unit'];
    							$tce += $course_detail['credit_unit'];
    							if($mark['grade'] == 'A'){
    								$tp += 5 * $course_detail['credit_unit'];	
    							}else if($mark['grade'] == 'B'){
    								$tp += 4 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'C'){
    								$tp += 3 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'D'){
    								$tp += 2 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'E'){
    								$tp += 1 * $course_detail['credit_unit'];
    							}													
    						}else if($mark['total_marks'] < 40){
    						    $absent_through = false;
    						    $absent_flag = false;
    							$tcr += $course_detail['credit_unit'];
    							$tp += 0 * $course_detail['credit_unit'];
    							$carry_over .= $name.", ";
    						}
					}
					
				}
				// Calculate CGPA
				foreach($overall_courses as $co){ 
					$mark = $this->levelcoordinator_model->get_student_marks($stud->id, $co->id);
					$name = $co->course_id;
				//	$course_detail = $this->levelcoordinator_model->get_course_detail($co->course_id,$programme_id,$semester);
				if($lvlCdetails['current_level']==100){
					$course_detail = $this->levelcoordinator_model->get_course_detail($co->course_id,$programme_id,$semester);
			  }else{
				$course_detail = $this->levelcoordinator_model->get_course_details_($co->course_id,$semester);
			  }

					
					if($mark){		
						//$tcr += $course_detail['credit_unit'];					
						if($mark['total_marks'] == 'ABS'){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tp += 0 * $course_detail['credit_unit'];
							//$carry_over .= $name.", ";
							//$remark .= "ABS in: ".$name;
						}else if($mark['total_marks'] == "I"){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_inc += $course_detail['credit_unit'];
							//$remark .= "INC in: ".$name;
						}else if($mark['total_marks'] >= 40){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tce += $course_detail['credit_unit'];
							if($mark['grade'] == 'A'){
								$overall_tp += 5 * $course_detail['credit_unit'];	
							}else if($mark['grade'] == 'B'){
								$overall_tp += 4 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'C'){
								$overall_tp += 3 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'D'){
								$overall_tp += 2 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'E'){
								$overall_tp += 1 * $course_detail['credit_unit'];
							}													
						}else if($mark['total_marks'] < 40){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tp += 0 * $course_detail['credit_unit'];
							//$carry_over .= $name.", ";
						}
					}
					
				}
                
                if($abs_flag){
                    $remark .= $abs;
                }
				$stud->tce = $tce;
				$stud->tcr = $tcr;
				//gpa
				if($tcr == $inc){
					$gpa = (double) $tp/1;
				}else{	
					$gpa = (double) $tp/($tcr - $inc); // subtract incomplete grading ( 0 if no incomplete grade)
				}
				//cgpa
				if($tcr == $overall_inc){
					$cgpa = (double) $overall_tp/1;
				}else{	
					 // subtract incomplete grading ( 0 if no incomplete grade)
					$cgpa = (double) $overall_tp/($overall_tcr - $overall_inc);
				}
				$gpa = round($gpa, 2);
				$stud->gpa = strlen(strval($gpa)) == 1 ? $gpa.".00" : $gpa;
				$stud->cgpa = number_format($cgpa, 2);
				if($cgpa < 1.00){
					$remark .= "On Probation";
				}
					
				$stud->carry_over = $carry_over;
				$stud->remark = $remark;
				if($absent_through){
    				    $stud->absent = true;
    			}else{
    				   $stud->absent = false; 
    			}
			}
		}
		    
		if(isset($_POST['raw_marks'])){
			
			$spreadsheet = new Spreadsheet();

			$row_counter = 12;
			//STYLING THE PAGE
			$spreadsheet->getActiveSheet()->setShowGridlines(true);
			$spreadsheet->getActiveSheet()->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd(11, 11);
			$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.'G13')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('B2BEB5');
			$spreadsheet->getDefaultStyle()->getFont()->setSize(12);
			$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

			//$spreadsheet->getActiveSheet()->mergeCells('A18:E22');
			
			$spreadsheet->getActiveSheet()->getCell('A1')->setValue('NORTHWEST UNIVERSITY, KANO');
			$spreadsheet->getActiveSheet()->mergeCells('A1:'.$highest_letter.'1');

			$spreadsheet->getActiveSheet()->getCell('A2')->setValue('FACULTY OF '.strtoupper($faculty));
			$spreadsheet->getActiveSheet()->mergeCells('A2:'.$highest_letter.'2');
			$spreadsheet->getActiveSheet()->mergeCells('A3:'.$highest_letter.'3');

			$spreadsheet->getActiveSheet()->getCell('A4')->setValue("DEPARTMENT OF ".strtoupper($department));
			$spreadsheet->getActiveSheet()->mergeCells('A4:'.$highest_letter.'4');
			$spreadsheet->getActiveSheet()->mergeCells('A5:'.$highest_letter.'5');

			$spreadsheet->getActiveSheet()->getCell('A6')->setValue('Submission to the Senate through SBC (Raw Marks)');
			$spreadsheet->getActiveSheet()->mergeCells('A6:'.$highest_letter.'6');
			$spreadsheet->getActiveSheet()->getCell('A7')->setValue(' ');
			$spreadsheet->getActiveSheet()->mergeCells('A7:'.$highest_letter.'7');

			$spreadsheet->getActiveSheet()->getCell('B8')->setValue('Session: '.$session);
			$spreadsheet->getActiveSheet()->getCell('B9')->setValue('Semester: '.$semester);
			$spreadsheet->getActiveSheet()->getCell('C9')->setValue('Level: '.$lvlCdetails['current_level']);
			$spreadsheet->getActiveSheet()->getCell('D9')->setValue('Date: '.date("d/m/Y")); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('D9:G9');
			
			$spreadsheet->getActiveSheet()->getCell('C8')->setValue('Programme: '.$programme_name);
			$spreadsheet->getActiveSheet()->mergeCells('C8:G8');
			$spreadsheet->getActiveSheet()->mergeCells('E8:G8');
			$spreadsheet->getActiveSheet()->getStyle('E8')
				->getAlignment()->setWrapText(true);
			$spreadsheet->getActiveSheet()->mergeCells('H8:I8');
//			$spreadsheet->getActiveSheet()->mergeCells('G8:'.$highest_letter.'8');
			// Apply text format to the entire column A
            

			// END OF STYLES

			$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooterDrawing();
			$drawing->setName('PhpSpreadsheet logo');
			$drawing->setPath('assets/img/nwu_logo.png');
			$drawing->setHeight(100);
			$drawing->setWidth(100);
			//$spreadsheet->getActiveSheet()->getHeaderFooter()->addImage($drawing, \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooter::IMAGE_HEADER_LEFT);
			$drawing->setCoordinates('A1');
			$drawing->setWorksheet($spreadsheet->getActiveSheet());

			$worksheet = $spreadsheet->getActiveSheet(); 
			// set excel headers  

			$worksheet->getCell('A11')->setValue('S/No.');
			$worksheet->getCell('B11')->setValue('Registration No.');
			$worksheet->getCell('C11')->setValue('Name');
			
			$cell_counter = 3;
			$level_tracker = true;
			foreach($course as $co){
			    $worksheet->getCell($alpha[$cell_counter].'11')->setValue($co->course_id);
			    
			    $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter].'')->setWidth('5');
			    $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter].'')->setAutoSize(false);
			    
			    $spreadsheet->getActiveSheet()->getStyle($alpha[$cell_counter].'11')
				->getAlignment()->setTextRotation(90);
				
				if($level == 200 && $co->level != 200 && $level_tracker == true){
				    $worksheet->getCell($alpha[$cell_counter].'11')->setValue('OTHER COURSE(S)');
				    $spreadsheet->getActiveSheet()->mergeCells($alpha[$cell_counter].'11:'.$alpha[count($course)+3].'11');
				    $spreadsheet->getActiveSheet()->getStyle($alpha[$cell_counter].'11')
            ->getAlignment()->setTextRotation(0);
				    $level_tracker = false;
				}
				
				$cell_counter++;
			}
			
			/*foreach($course as $co){
                $currentCell = $alpha[$cell_counter] . '11';
            
                // Set the course_id or 'OTHER COURSE(S)' as the cell value based on the level
                if($co->level != 200 && $level_tracker) {
                    $worksheet->getCell($currentCell)->setValue('OTHER COURSE(S)');
                    $spreadsheet->getActiveSheet()->mergeCells($currentCell . ':' . $alpha[$cell_counter+7] . '11');
                    // Set text rotation to 0 for "OTHER COURSE(S)"
                    $spreadsheet->getActiveSheet()->getStyle($currentCell)
                        ->getAlignment()->setTextRotation(0);
                    $level_tracker = false;
                }else{
                    $worksheet->getCell($currentCell)->setValue($co->course_id);
                    // Set text rotation to 90 for regular course_ids
                    $spreadsheet->getActiveSheet()->getStyle($currentCell)
                        ->getAlignment()->setTextRotation(90);
                }
            
                // Set column width and disable autosize
                $columnDimension = $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter]);
                $columnDimension->setWidth(5);
                $columnDimension->setAutoSize(false);
            
                // Move to the next column
                $cell_counter++;
            }*/

			
			$count = 1;
			
			foreach ($student as $stud) {
                $worksheet->getCell('A'.$row_counter)->setValue($count++);
                $worksheet->getCell('B'.$row_counter)->setValue($stud->registration_no);
                $worksheet->getCell('C'.$row_counter)->setValue($stud->middle_name." ".$stud->last_name." ".$stud->first_name);
            
                $cell_counter = 3;  // Initialize to start filling grades in columns from 'D'
                $other_course = ""; // Initialize empty string to collect marks for different level courses
                $has_other_level_course = false; // Flag to check if student has other level courses
            
                foreach ($course as $co) {
                    // Check if the grade exists in the lookup array
                    $mark = isset($marks_lookup[$stud->id][$co->course_id]) ? $marks_lookup[$stud->id][$co->course_id] : '';
                    
                    // Format the mark (add leading zero for single-digit marks)
                    $mark = (($mark < 10) && is_numeric($mark)) ? "0".$mark : $mark;
            
                    // Check if the course level matches the current student's level
                    if ($level == 200 && $co->level != 200) {
                        // If level doesn't match, collect the mark for this course
                        if(!empty($mark)){
                            $other_course .= $co->course_id."(".$mark."), "; // Add course code and mark
                        }
                        $has_other_level_course = true; // Set the flag to true
                    } else {
                        // If level matches, assign the mark to the corresponding column
                        $worksheet->getCell($alpha[$cell_counter].$row_counter)->setValue($mark);
                        $cell_counter++; // Move to the next column
                    }
                }
            
                // After the loop, if the student has other level courses, write the collected information
                if ($has_other_level_course) {
                    $worksheet->getCell($alpha[$cell_counter].$row_counter)->setValue(rtrim($other_course, ', ')); // Remove trailing comma
                    // Merge the cells vertically across all student rows if necessary
                    $spreadsheet->getActiveSheet()->mergeCells($alpha[$cell_counter].$row_counter.':'.$alpha[count($course)+2].$row_counter);; // Merge cells in the 'Other Course' column
                }
            
                $row_counter++; // Move to the next row for the next student
            }

			
			$counter = $row_counter + 2;
			$spreadsheet->getActiveSheet()->getCell('A'.$counter)->setValue('LEVEL COORDINATOR               EXAMINATIONS OFFICER              HEAD OF DEPARTMENT                                DEAN'); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('A'.$counter.':'.$highest_letter.$counter);
			
				//end of headers
				
				$row_counter = $row_counter - 1;

            $spreadsheet->getActiveSheet()->getStyle('B'.$row_counter.':'.$highest_letter.$row_counter)
            				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			
			$spreadsheet->getActiveSheet()->getStyle('A12:C'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
			$spreadsheet->getActiveSheet()->getStyle('D12:G'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
				// SET HEADERS TO CENTER
			$spreadsheet->getActiveSheet()->getStyle('A1:H6')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			$spreadsheet->getActiveSheet()->getStyle('A8:L8')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				
				//wrap
			//$spreadsheet->getActiveSheet()->getHighestRow()->getStyle('D8:G8') ->getAlignment()->setWrapText(true);
			
		    $spreadsheet->getActiveSheet()->getStyle('D8:G8')->getAlignment()->setWrapText(true); 
//sa
			/*$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'')    
				->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') 
					->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);*/
			//$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') ->getBorders()->getLeft()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			//$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') ->getBorders()->getRight()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'') 
					->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
			$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			
			
	//end
			$spreadsheet->getActiveSheet()->getStyle('A8:'.$highest_letter.'8')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
						// SET FONT BOLD
			$spreadsheet->getActiveSheet()->getStyle('A1:'.$highest_letter.'11')->getFont()->setBold(true);

					//END OF BORDER

				
			$writer = new Xlsx($spreadsheet);
            
			//header('Content-Type: Application/vnd.ms-excel');
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			//header('Content-Disposition: attachment; filename="hideMeTest5.xlsx"');
			header('Content-Disposition: attachment; filename= '.$programme_name.'_'.$session."_Result_Raw_Marks.xlsx");
			ob_end_clean();
			$writer->save('php://output');
			exit;

		}else if(isset($_POST['summary'])){
	    
			$spreadsheet = new Spreadsheet();

			$row_counter = 12;
			//STYLING THE PAGE
			$spreadsheet->getActiveSheet()->setShowGridlines(true);
			$spreadsheet->getActiveSheet()->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd(11, 11);
			$spreadsheet->getActiveSheet()->getStyle('A11:H11')->getFill()
				->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
				->getStartColor()->setARGB('B2BEB5');
			$spreadsheet->getDefaultStyle()->getFont()->setSize(12);
			$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('G')->setWidth(30);
			
			//$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

			//$spreadsheet->getActiveSheet()->mergeCells('A18:E22');
			$spreadsheet->getActiveSheet()->getCell('A1')->setValue('NORTHWEST UNIVERSITY, KANO');
			$spreadsheet->getActiveSheet()->mergeCells('A1:H1');

			$spreadsheet->getActiveSheet()->getCell('A2')->setValue('FACULTY OF '.strtoupper($faculty));
			$spreadsheet->getActiveSheet()->mergeCells('A2:H2');
			$spreadsheet->getActiveSheet()->mergeCells('A3:H3');
            
			$spreadsheet->getActiveSheet()->getCell('A4')->setValue("DEPARTMENT OF ".strtoupper($department));
			$spreadsheet->getActiveSheet()->mergeCells('A4:H4');
			$spreadsheet->getActiveSheet()->mergeCells('A5:H5');

			$spreadsheet->getActiveSheet()->getCell('A6')->setValue('Submission to the Senate through SBC (Summary)');
			$spreadsheet->getActiveSheet()->mergeCells('A6:H6');
			$spreadsheet->getActiveSheet()->getCell('A7')->setValue(' ');
			$spreadsheet->getActiveSheet()->mergeCells('A7:H7');
            
			$spreadsheet->getActiveSheet()->getCell('A8')->setValue('Session: '.$session.'    Semester: '.$semester.'       Programme:    ' .$programme_name.'    Level: '.$lvlCdetails['current_level'].'    Date:    '.date("d/m/Y"));
			$spreadsheet->getActiveSheet()->mergeCells('A8:H8');
			/*
			$spreadsheet->getActiveSheet()->getCell('E8')->setValue('Semester: '.$semester);
			
			$spreadsheet->getActiveSheet()->getCell('C8')->setValue('Programme: '.$programme_name);
			$spreadsheet->getActiveSheet()->mergeCells('C8:D8');
			$spreadsheet->getActiveSheet()->mergeCells('E8:G8');
			$spreadsheet->getActiveSheet()->getStyle('E8')
				->getAlignment()->setWrapText(true);
			$spreadsheet->getActiveSheet()->getCell('H8')->setValue('Level: '.$level);
			$spreadsheet->getActiveSheet()->mergeCells('H8:I8');
			$spreadsheet->getActiveSheet()->getCell('J8')->setValue('            Date: '.date("d/m/Y")); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('J8:'.$highest_letter.'8'); 
			*/
			// END OF STYLES

			$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooterDrawing();
			$drawing->setName('PhpSpreadsheet logo');
			$drawing->setPath('assets/img/nwu_logo.png');
			$drawing->setHeight(100);
			$drawing->setWidth(100);
			//$spreadsheet->getActiveSheet()->getHeaderFooter()->addImage($drawing, \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooter::IMAGE_HEADER_LEFT);
			$drawing->setCoordinates('A1');
			$drawing->setWorksheet($spreadsheet->getActiveSheet());
			//

			$worksheet = $spreadsheet->getActiveSheet(); 
			// set excel headers  

			$worksheet->getCell('A11')->setValue('S/No.');
			$worksheet->getCell('B11')->setValue('Registration No.');
			$worksheet->getCell('C11')->setValue('Name');
			$worksheet->getCell('D11')->setValue('TCR');
			$worksheet->getCell('E11')->setValue('TCE');
			$worksheet->getCell('F11')->setValue('GPA');
			if($semester == '2nd'){
			    $worksheet->getCell('G11')->setValue('CGPA');
			    $worksheet->getCell('H11')->setValue('Course(s) to Carry Over');
			    $worksheet->getCell('I11')->setValue('REMARK        ');
			    
			   
			}else{
			    $worksheet->getCell('G11')->setValue('Course(s) to Carry Over');
			    $worksheet->getCell('H11')->setValue('REMARK        ');
			    
			}
			
			$count = 1;
			
			foreach($student as $stud){
			    
			    $worksheet->getCell('A'.$row_counter)->setValue($count++);
				$worksheet->getCell('B'.$row_counter)->setValue($stud->registration_no);
				$worksheet->getCell('C'.$row_counter)->setValue($stud->middle_name." ".$stud->last_name." ".$stud->first_name);
				if($stud->tcr == 0){
				    $worksheet->getCell('D'.$row_counter)->setValue('DID NOT REGISTER FOR THE SESSION, RECOMMENDED FOR WITHDRAWAL');
				    $spreadsheet->getActiveSheet()->mergeCells('D'.$row_counter.':'.'H'.$row_counter);
				    
				}else{
				    $worksheet->getCell('D'.$row_counter)->setValue($stud->tcr);
				}
				
				$worksheet->getCell('E'.$row_counter)->setValue($stud->tce);
				// Apply number formatting for two decimal places
                $worksheet->getStyle('F'.$row_counter)
                      ->getNumberFormat()
                      ->setFormatCode('0.00');
				$worksheet->getCell('F'.$row_counter)->setValue($stud->gpa);
				
				if($semester == '1st'){
				   
				    $worksheet->getCell('G'.$row_counter)->setValue($stud->carry_over);
				    $spreadsheet->getActiveSheet()->getStyle('G'.$row_counter)->getAlignment()->setWrapText(true);
				   if($stud->absent){
				       $worksheet->getCell('H'.$row_counter)->setValue('ABSENT THROUGHOUT THE SEMESTER, RECOMMENDED FOR WITHDRAWAL');
				       $spreadsheet->getActiveSheet()->getStyle('H'.$row_counter)->getAlignment()->setWrapText(true);
				    }else{
				       $worksheet->getCell('H'.$row_counter)->setValue($stud->remark);
				       $spreadsheet->getActiveSheet()->getStyle('H'.$row_counter)->getAlignment()->setWrapText(true);
				    }
				}else{
				    $worksheet->getStyle('G'.$row_counter)
                      ->getNumberFormat()
                      ->setFormatCode('0.00');
				    $worksheet->getCell('G'.$row_counter)->setValue($stud->cgpa);
				    $worksheet->getCell('H'.$row_counter)->setValue($stud->carry_over);
				    if($stud->absent){
				       $worksheet->getCell('I'.$row_counter)->setValue('ABSENT THROUGHOUT THE SEMESTER, RECOMMENDED FOR WITHDRAWAL');
				       $spreadsheet->getActiveSheet()->getStyle('H'.$row_counter)->getAlignment()->setWrapText(true);
				    }else{
				       $worksheet->getCell('I'.$row_counter)->setValue($stud->remark);
				       $spreadsheet->getActiveSheet()->getStyle('H'.$row_counter)->getAlignment()->setWrapText(true);
				    }
				    $spreadsheet->getActiveSheet()->getStyle('I'.$row_counter)->getAlignment()->setWrapText(true);
				}
				
				$row_counter++;
			}
			
					
			if($semester == '1st'){
			    $counter = $row_counter + 2;
			$spreadsheet->getActiveSheet()->getCell('A'.$counter)->setValue('LEVEL COORDINATOR           EXAMINATIONS OFFICER                   HEAD OF DEPARTMENT                                DEAN'); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('A'.$counter.':H'.$counter);
			
				//end of headers
				
			$row_counter = $row_counter - 1;

            $spreadsheet->getActiveSheet()->getStyle('B'.$row_counter.':H'.$row_counter)
            				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			
			$spreadsheet->getActiveSheet()->getStyle('A12:C'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
			$spreadsheet->getActiveSheet()->getStyle('D12:H'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				// SET HEADERS TO CENTER
			$spreadsheet->getActiveSheet()->getStyle('A1:H6')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			$spreadsheet->getActiveSheet()->getStyle('A8:L8')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				
				//wrap
			//$spreadsheet->getActiveSheet()->getHighestRow()->getStyle('D8:G8') ->getAlignment()->setWrapText(true);
			
		    
//sa
			$spreadsheet->getActiveSheet()->getStyle('A11:H11')    
				->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:H'.$row_counter) 
					->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:H'.$row_counter) ->getBorders()->getLeft()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:H'.$row_counter) ->getBorders()->getRight()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:H'.$row_counter) 
					->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
			$spreadsheet->getActiveSheet()->getStyle('A11:H'.$row_counter)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			
	//end
			$spreadsheet->getActiveSheet()->getStyle('A8:H8')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
						// SET FONT BOLD
			$spreadsheet->getActiveSheet()->getStyle('A1:H11')->getFont()->setBold(true);

					//END OF BORDER
			}else{
			    $counter = $row_counter + 2;
			$spreadsheet->getActiveSheet()->getCell('A'.$counter)->setValue('LEVEL COORDINATOR                        EXAMINATIONS OFFICER                   HEAD OF DEPARTMENT                                DEAN'); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('A'.$counter.':H'.$counter);
			
				//end of headers
				
				$row_counter = $row_counter - 1;

            $spreadsheet->getActiveSheet()->getStyle('B'.$row_counter.':H'.$row_counter)
            				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			
			$spreadsheet->getActiveSheet()->getStyle('A12:C'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
			$spreadsheet->getActiveSheet()->getStyle('D12:I'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				// SET HEADERS TO CENTER
			$spreadsheet->getActiveSheet()->getStyle('A1:I6')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			$spreadsheet->getActiveSheet()->getStyle('A8:K8')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				
				//wrap
			//$spreadsheet->getActiveSheet()->getHighestRow()->getStyle('D8:G8') ->getAlignment()->setWrapText(true);
			
		    
//sa
			$spreadsheet->getActiveSheet()->getStyle('A11:I11')    
				->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:I'.$row_counter) 
					->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:I'.$row_counter) ->getBorders()->getLeft()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:I'.$row_counter) ->getBorders()->getRight()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:I'.$row_counter) 
					->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
			$spreadsheet->getActiveSheet()->getStyle('A11:I'.$row_counter)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			
	//end
			$spreadsheet->getActiveSheet()->getStyle('A8:I8')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
						// SET FONT BOLD
			$spreadsheet->getActiveSheet()->getStyle('A1:I11')->getFont()->setBold(true);

					//END OF BORDER
			}
				
			$writer = new Xlsx($spreadsheet);

			//header('Content-Type: Application/vnd.ms-excel');
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			//header('Content-Disposition: attachment; filename="hideMeTest5.xlsx"');
			header('Content-Disposition: attachment; filename= '.$programme_name.'_'.$session."_Result_Summary.xlsx");
			ob_end_clean();
			$writer->save('php://output');
			exit;

			}else if(isset($_POST['score_sheet'])){
			    
			}else if(isset($_POST['mbbs_summary'])){
		       
        	    $updated_alpha = array('A','B','C','D','E','F','G','H','I','J','K', 'L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
        		
        		$spreadsheet = new Spreadsheet();
        
        		$row_counter = 12;
        		//STYLING THE PAGE
        		$spreadsheet->getActiveSheet()->setShowGridlines(true);
        		$spreadsheet->getActiveSheet()->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd(13, 13);
        		$spreadsheet->getActiveSheet()->getStyle('A13:G13')->getFill()
        			->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
        			->getStartColor()->setARGB('B2BEB5');
        		$spreadsheet->getDefaultStyle()->getFont()->setSize(12);
        		$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        		$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        		$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        		//$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        		//$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        		//$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        		//$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
        
        		//$spreadsheet->getActiveSheet()->mergeCells('A18:E22');
        		$spreadsheet->getActiveSheet()->getCell('A1')->setValue('NORTHWEST UNIVERSITY, KANO');
        		$spreadsheet->getActiveSheet()->mergeCells('A1:'.$highest_letter.'1');
        
        		$spreadsheet->getActiveSheet()->getCell('A2')->setValue('FACULTY OF CLIICAL SCIENCES');
        		$spreadsheet->getActiveSheet()->mergeCells('A2:'.$highest_letter.'2');
        		$spreadsheet->getActiveSheet()->mergeCells('A3:'.$highest_letter.'3');
        
        		$spreadsheet->getActiveSheet()->getCell('A4')->setValue("MBBS PROGRAMME");
        		$spreadsheet->getActiveSheet()->mergeCells('A4:'.$highest_letter.'4');
        		$spreadsheet->getActiveSheet()->mergeCells('A5:'.$highest_letter.'5');
        
        		$spreadsheet->getActiveSheet()->getCell('A6')->setValue('Submission to the Senate through SBC (Raw Marks)');
        		$spreadsheet->getActiveSheet()->mergeCells('A6:'.$highest_letter.'6');
        		$spreadsheet->getActiveSheet()->getCell('A7')->setValue(' ');
        		$spreadsheet->getActiveSheet()->mergeCells('A7:'.$highest_letter.'7');
        
        		$spreadsheet->getActiveSheet()->getCell('B8')->setValue('Session: '.$session);
        		$spreadsheet->getActiveSheet()->getCell('E8')->setValue('Semester: '.$semester);
        		
        		$spreadsheet->getActiveSheet()->getCell('C8')->setValue('Programme: '.$programme_name);
        		$spreadsheet->getActiveSheet()->mergeCells('C8:D8');
        		$spreadsheet->getActiveSheet()->mergeCells('E8:G8');
        		$spreadsheet->getActiveSheet()->getStyle('E8')
        			->getAlignment()->setWrapText(true);
        		$spreadsheet->getActiveSheet()->getCell('H8')->setValue('Level: '.$level);
        		$spreadsheet->getActiveSheet()->mergeCells('H8:I8');
        		$spreadsheet->getActiveSheet()->getCell('G8')->setValue('            Date: '.date("d/m/Y")); // Date Downloaded
        		$spreadsheet->getActiveSheet()->mergeCells('G8:'.$highest_letter.'8');
        		
        		// END OF STYLES
        
        		$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooterDrawing();
        		$drawing->setName('PhpSpreadsheet logo');
        		$drawing->setPath('assets/img/nwu_logo.png');
        		$drawing->setHeight(100);
        		$drawing->setWidth(100);
        		//$spreadsheet->getActiveSheet()->getHeaderFooter()->addImage($drawing, \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooter::IMAGE_HEADER_LEFT);
        		$drawing->setCoordinates('A1');
        		$drawing->setWorksheet($spreadsheet->getActiveSheet());
        		//
        
        		$worksheet = $spreadsheet->getActiveSheet(); 
        		// set excel headers  
        
        		$worksheet->getCell('A11')->setValue('S/No.');
        		$worksheet->getCell('B11')->setValue('Registration No.');
        		$worksheet->getCell('C11')->setValue('Name');
        		
        		$cell_counter = 3;
        		
        		$mmbs_course = $this->levelcoordinator_model->get_mbbs_submitted_result_semester($username, $semester, $session);
        		
        		$mbbs_distint = count($mmbs_course) + 3;
        		$mbbs_lowest_letter = $alpha[$mbbs_distint];
        		$mbbs_highest_letter = $alpha[$mbbs_distint+3];
        		
        		//$remark_label = $alpha[count($mbbs_distint)];
        		
        		foreach($mmbs_course as $co){
        		    
        		    //$abv_res = $this->levelcoordinator_model->get_mbbs_submitted_result_semester($username, $semester, $session);
        		    if($co->dept_id == 0){
        		        $worksheet->getCell($alpha[$cell_counter].'11')->setValue("GSP");
        		    }else{
        		        $worksheet->getCell($alpha[$cell_counter].'11')->setValue($this->levelcoordinator_model->get_department_details($co->dept_id)['title']);
        		    }
        		    
        		    
        		    $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter].'')->setWidth('5');
        		    $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter].'')->setAutoSize(false);
        		    
        		    $spreadsheet->getActiveSheet()->getStyle($alpha[$cell_counter].'11')
        			->getAlignment()->setTextRotation(90);
        			
        			$cell_counter++;
        		}
        		
        		$worksheet->getCell($mbbs_lowest_letter.'11')->setValue('Remarks');
        		$spreadsheet->getActiveSheet()->mergeCells($mbbs_lowest_letter.'11:'.$mbbs_highest_letter.'11');
        		
        		$count = 1;
        		
        		foreach($student as $stud){
        		    
        		    $worksheet->getCell('A'.$row_counter)->setValue($count++);
        			$worksheet->getCell('B'.$row_counter)->setValue($stud->registration_no);
        			$worksheet->getCell('C'.$row_counter)->setValue($stud->middle_name." ".$stud->last_name." ".$stud->first_name);
        			
        			$cell_counter = 3;
        			
        			foreach($mmbs_course as $co){
        			    $result = 0;
        			    $c = 1;
        				$abv_res = $this->levelcoordinator_model->get_mbbs_submitted_result_semester_($co->dept_id, $username, $semester, $session);
        				
        				foreach($abv_res as $ab){
        				    $result += (int) $this->levelcoordinator_model->get_mbbs_marks($ab->id, $stud->registration_no)['total_marks'];
        				    $c = $c + 1;
        				}
        				
        				$worksheet->getCell($alpha[$cell_counter].$row_counter.'')->setValue(ceil($result/$c));
        				$spreadsheet->getActiveSheet()->mergeCells($mbbs_lowest_letter.$row_counter.':'.$mbbs_highest_letter.$row_counter);
        				
        				$cell_counter++;
        			}
        			
        			$row_counter++;
        		}
        		
        		$counter = $row_counter + 3;
        		$spreadsheet->getActiveSheet()->getCell('B'.$counter)->setValue('LEVEL COORDINATOR                        EXAMINATIONS OFFICER                   HEAD OF DEPARTMENT                                DEAN'); // Date Downloaded
        		$spreadsheet->getActiveSheet()->mergeCells('B'.$counter.':'.$highest_letter.$counter);
        		
        			//end of headers
        			
        			$row_counter = $row_counter - 1;
        
                $spreadsheet->getActiveSheet()->getStyle('B'.$row_counter.':'.$highest_letter.$row_counter)
                				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        		
        		$spreadsheet->getActiveSheet()->getStyle('A13:C'.$row_counter.'')
        			->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
        		$spreadsheet->getActiveSheet()->getStyle('D13:G'.$row_counter.'')
        			->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        			// SET HEADERS TO CENTER
        		$spreadsheet->getActiveSheet()->getStyle('A1:H6')
        			->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
        		$spreadsheet->getActiveSheet()->getStyle('A8:L8')
        			->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
        			
        			//wrap
        		//$spreadsheet->getActiveSheet()->getHighestRow()->getStyle('D8:G8') ->getAlignment()->setWrapText(true);
        		
        	    $spreadsheet->getActiveSheet()->getStyle('D8:G8')->getAlignment()->setWrapText(true); 
        //sa
        		/*$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'')    
        			->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
        		$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') 
        				->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);*/
        		//$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') ->getBorders()->getLeft()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
        		//$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') ->getBorders()->getRight()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
        		$spreadsheet->getActiveSheet()->getStyle('A11:'.$mbbs_highest_letter.$row_counter.'') 
        				->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
        		$spreadsheet->getActiveSheet()->getStyle('A11:'.$mbbs_highest_letter.$row_counter.'')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
        		
        		
        //end
        		$spreadsheet->getActiveSheet()->getStyle('A8:'.$mbbs_highest_letter.'8')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
        					// SET FONT BOLD
        		$spreadsheet->getActiveSheet()->getStyle('A1:'.$highest_letter.'11')->getFont()->setBold(true);
        
        				//END OF BORDER
        
        			
        		$writer = new Xlsx($spreadsheet);
        
        		//header('Content-Type: Application/vnd.ms-excel');
        		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        		//header('Content-Disposition: attachment; filename="hideMeTest5.xlsx"');
        		header('Content-Disposition: attachment; filename= '.$programme_name.'_'.$session."_Result_Summary.xlsx");
        		ob_end_clean();
        		$writer->save('php://output');
        		exit;
                //end of 
            }else if(isset($_POST['statistics'])){
                
    			$spreadsheet = new Spreadsheet();
    
    			$row_counter = 12;
    			//STYLING THE PAGE
    			$spreadsheet->getActiveSheet()->setShowGridlines(true);
    			$spreadsheet->getActiveSheet()->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd(11, 11);
    			$spreadsheet->getActiveSheet()->getStyle('A11:H11')->getFill()
    				->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    				->getStartColor()->setARGB('B2BEB5');
    			$spreadsheet->getDefaultStyle()->getFont()->setSize(12);
    			$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
    			$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
    			$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
    			//$spreadsheet->getActiveSheet()->getColumnDimension('G')->setWidth(30);
    			
    			$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
    			$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
    			$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
    			$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
    			$spreadsheet->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
    
    			//$spreadsheet->getActiveSheet()->mergeCells('A18:E22');
    			$spreadsheet->getActiveSheet()->getCell('A1')->setValue('NORTHWEST UNIVERSITY, KANO');
    			$spreadsheet->getActiveSheet()->mergeCells('A1:H1');
    
    			$spreadsheet->getActiveSheet()->getCell('A2')->setValue('FACULTY OF '.strtoupper($faculty));
    			$spreadsheet->getActiveSheet()->mergeCells('A2:H2');
    			$spreadsheet->getActiveSheet()->mergeCells('A3:H3');
                
    			$spreadsheet->getActiveSheet()->getCell('A4')->setValue("DEPARTMENT OF ".strtoupper($department));
    			$spreadsheet->getActiveSheet()->mergeCells('A4:H4');
    			$spreadsheet->getActiveSheet()->mergeCells('A5:H5');
    
    			$spreadsheet->getActiveSheet()->getCell('A6')->setValue('Submission to the Senate through SBC (Statistics)');
    			$spreadsheet->getActiveSheet()->mergeCells('A6:H6');
    			$spreadsheet->getActiveSheet()->getCell('A7')->setValue(' ');
    			$spreadsheet->getActiveSheet()->mergeCells('A7:H7');
                
    			$spreadsheet->getActiveSheet()->getCell('A8')->setValue('Session: '.$session.'    Semester: '.$semester.'       Programme:    ' .$programme_name.'    Level: '.$lvlCdetails['current_level'].'    Date:    '.date("d/m/Y"));
    			$spreadsheet->getActiveSheet()->mergeCells('A8:H8');
    		
    			// END OF STYLES
    
    			$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooterDrawing();
    			$drawing->setName('PhpSpreadsheet logo');
    			$drawing->setPath('assets/img/nwu_logo.png');
    			$drawing->setHeight(100);
    			$drawing->setWidth(100);
    			//$spreadsheet->getActiveSheet()->getHeaderFooter()->addImage($drawing, \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooter::IMAGE_HEADER_LEFT);
    			$drawing->setCoordinates('A1');
    			$drawing->setWorksheet($spreadsheet->getActiveSheet());
    			//
    
    			$worksheet = $spreadsheet->getActiveSheet(); 
    			// set excel headers  
    			
    			$total = $first + $second_upper + $second_lower + $third + $pass + $probation;
    
    			$worksheet->getCell('A11')->setValue('S/No.');
    			$worksheet->getCell('B11')->setValue('Category');
    			$worksheet->getCell('C11')->setValue('Number of Cases');
    			
    			$worksheet->getCell('E11')->setValue('Class Range');
    			$worksheet->getCell('F11')->setValue('Class of Degree');
    			$worksheet->getCell('G11')->setValue('Number');
    			$worksheet->getCell('H11')->setValue('%');
    			
    			$worksheet->getStyle('H')->getNumberFormat()->setFormatCode('0.00');
    			
    			$worksheet->getCell('A12')->setValue('1');
    			$worksheet->getCell('B12')->setValue('Passed All Courses');
    			$worksheet->getCell('C12')->setValue($pass_all);
    			
    			$worksheet->getCell('A13')->setValue('2');
    			$worksheet->getCell('B13')->setValue('Carry Over Cases(s)');
    			$worksheet->getCell('C13')->setValue($carry_over_case - $probation);
    			
    			$worksheet->getCell('A14')->setValue('3');
    			$worksheet->getCell('B14')->setValue('Probaton');
    			$worksheet->getCell('C14')->setValue($probation);
    			
    			$worksheet->getCell('A15')->setValue('4');
    			$worksheet->getCell('B15')->setValue('Withheld');
    			$worksheet->getCell('C15')->setValue('0');
    			
    			$worksheet->getCell('A16')->setValue('5');
    			$worksheet->getCell('B16')->setValue('Incomplete');
    			$worksheet->getCell('C16')->setValue('0');
    			
    			$worksheet->getCell('A17')->setValue('6');
    			$worksheet->getCell('B17')->setValue('Pending Cases');
    			$worksheet->getCell('C17')->setValue('0');
    			
    			$worksheet->getCell('A18')->setValue('7');
    			$worksheet->getCell('B18')->setValue('Rustication');
    			$worksheet->getCell('C18')->setValue('0');
    			
    			$worksheet->getCell('A19')->setValue('8');
    			$worksheet->getCell('B19')->setValue('Wihdrawal');
    			$worksheet->getCell('C19')->setValue('0');
    			
    			$worksheet->getCell('A20')->setValue('9');
    			$worksheet->getCell('B20')->setValue('Suspension');
    			$worksheet->getCell('C20')->setValue('0');
    			
    			$spreadsheet->getActiveSheet()->mergeCells('A21:B21');
    			$worksheet->getCell('A21')->setValue('Total No. of Case(s)');
    			$worksheet->getCell('C21')->setValue($total);
    			
    			
    			$worksheet->getCell('E12')->setValue('4.50 - 5.00');
    			$worksheet->getCell('F12')->setValue('Expected First Class');
    			$worksheet->getCell('G12')->setValue($first);
    			$worksheet->getCell('H12')->setValue(($first/$total)*100);
    			
    			$worksheet->getCell('E13')->setValue('3.50 - 4.49');
    			$worksheet->getCell('F13')->setValue('Expected Upper Second Class');
    			$worksheet->getCell('G13')->setValue($second_upper);
    			$worksheet->getCell('H13')->setValue(($second_upper/$total)*100);
    			
    			$worksheet->getCell('E14')->setValue('2.40 - 3.49');
    			$worksheet->getCell('F14')->setValue('Expected Lower Second Class');
    			$worksheet->getCell('G14')->setValue($second_lower);
    			$worksheet->getCell('H14')->setValue(($second_lower/$total)*100);
    			
    			$worksheet->getCell('E15')->setValue('1.50 - 2.39');
    			$worksheet->getCell('F15')->setValue('Expected Third Class');
    			$worksheet->getCell('G15')->setValue($third);
    			$worksheet->getCell('H15')->setValue(($third/$total)*100);
    			
    			$worksheet->getCell('E16')->setValue('1.00 - 1.49');
    			$worksheet->getCell('F16')->setValue('Expected Pass');
    			$worksheet->getCell('G16')->setValue($pass);
    			$worksheet->getCell('H16')->setValue(($pass/$total)*100);
    			
    			$worksheet->getCell('E17')->setValue('0.00 - 0.99');
    			$worksheet->getCell('F17')->setValue('Probation');
    			$worksheet->getCell('G17')->setValue($probation);
    			$worksheet->getCell('H17')->setValue(($probation/$total)*100);
    			
    			$spreadsheet->getActiveSheet()->mergeCells('E18:F18');
    			$worksheet->getCell('E18')->setValue('Total');
    			$worksheet->getCell('G18')->setValue($total);
    			$worksheet->getCell('H18')->setValue('100');
    			
    			// Merge cells A24 and B24
                $spreadsheet->getActiveSheet()->mergeCells('A24:B24');
                $spreadsheet->getActiveSheet()->mergeCells('A25:B25');
                $worksheet->getCell('A25')->setValue('Level Coordinator');
                
                $spreadsheet->getActiveSheet()->getStyle('A25')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $spreadsheet->getActiveSheet()->getStyle('A25')->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
                
                // Apply a border (e.g., bottom border) to the merged cells
                $spreadsheet->getActiveSheet()->getStyle('A24:B24')
                    ->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK);
                    
                
                $spreadsheet->getActiveSheet()->mergeCells('D24:E24');
                $spreadsheet->getActiveSheet()->mergeCells('D25:E25');
                $worksheet->getCell('D25')->setValue('Exams Officer');
                
                $spreadsheet->getActiveSheet()->getStyle('D25')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $spreadsheet->getActiveSheet()->getStyle('D25')->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
                
                // Apply a border (e.g., bottom border) to the merged cells
                $spreadsheet->getActiveSheet()->getStyle('D24:E24')
                    ->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK);

    			
    			$spreadsheet->getActiveSheet()->getStyle('A1:H6')
    				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    			$spreadsheet->getActiveSheet()->getStyle('A8:H8')
    				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
    				
    				//wrap
    			//$spreadsheet->getActiveSheet()->getHighestRow()->getStyle('D8:G8') ->getAlignment()->setWrapText(true);
    			
    		    
    //sa
    			$spreadsheet->getActiveSheet()->getStyle('A11:C11')    
    				->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
    			$spreadsheet->getActiveSheet()->getStyle('A11:C11')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FF808080'); // Grey color (hex code: 808080)
    			$spreadsheet->getActiveSheet()->getStyle('A11:C21') 
    					->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
    					
    			$spreadsheet->getActiveSheet()->getStyle('E11:H11')    
    				->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
    			$spreadsheet->getActiveSheet()->getStyle('E11:H11')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FF808080'); // Grey color (hex code: 808080)
    			$spreadsheet->getActiveSheet()->getStyle('E11:H18') 
    					->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
    			
    	//end
    			$spreadsheet->getActiveSheet()->getStyle('A8:H8')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
    						// SET FONT BOLD
    			$spreadsheet->getActiveSheet()->getStyle('A1:H11')->getFont()->setBold(true);
    
    					//END OF BORDER
    				
    			$writer = new Xlsx($spreadsheet);
    
    			//header('Content-Type: Application/vnd.ms-excel');
    			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    			//header('Content-Disposition: attachment; filename="hideMeTest5.xlsx"');
    			header('Content-Disposition: attachment; filename= '.$programme_name.'_'.$session."_Result_Statistics.xlsx");
    			ob_end_clean();
    			$writer->save('php://output');
    			exit;

			
                
            }
        		
	//}
		}

	}
		
}
