<?php

namespace App\Controllers;
use \CodeIgniter\Controller;
use App\Models\User_model;
use App\Libraries\fpdf;

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Levelcoordinator extends BaseController
{
	public $session;
	public $fpdf;

	public function __construct(){
		
		$this->fpdf = new FPDF();
		$this->session = \Config\Services::session();
		
	}

	public function login(){
		return view("levelcoordinator/login");
	}

	public function logout(){
		$this->session->remove('levelcoordinator_logged');
		$this->session->remove('name');
		$this->session->remove('department');
		$this->session->destroy();
		return redirect()->to(base_url()."/lev-login");
	}
	
		public function login_checker()
	{
		if($this->request->getMethod() == 'post'){
			$username = $this->request->getVar("email");
			$password = $this->request->getVar("password");

			$check_login = $this->levelcoordinator_model->verify_levelcoordinator($username);
			

			if($check_login){
				if($check_login['status'] == 'active'){
				    
					if(password_verify($password, $check_login['password'])){
						$username = $check_login['email'];
    				    $dept_id = $check_login['dept_id'];
    				    $dept_details = $this->levelcoordinator_model->get_department_details($dept_id);
    				    $faculty_id = $dept_details['faculty_id'];
    				    $faculty = $this->levelcoordinator_model->get_faculty_details($faculty_id)['title'];
					    $num = $this->levelcoordinator_model->get_number_of_programmes_allocated($username);
					    
					    if($num == 1){
					        
					        $this->session->set('levelcoordinator_logged', true);
    						$this->session->set('username', $check_login['username']);
    						$this->session->set('staff_id', $check_login['staff_id']);
    						$this->session->set('staff_no', $check_login['stfn']);
    						$this->session->set('email', $check_login['email']);
    						$this->session->set('id', $check_login['id']);
    						
    						$programme_name = $this->levelcoordinator_model->get_programme_name($check_login['programme_id']);
    						$sname = $this->levelcoordinator_model->get_staff_name($username);
    						$department = $this->lecturer_model->get_department_name($dept_id)['title'];
    						$this->session->set('faculty', $faculty);
    						$this->session->set('name', $sname['name']);
    						$this->session->set('department', $department);
    						$this->session->set('programme_id', $check_login['programme_id']);
    						$this->session->set('programme_name', $programme_name['title']);
    						$this->session->set('department', $department);
    						
    						$initial = substr($check_login['session_started'], 0, 4);
                			$current = substr($this->portal_config['reg_session'], 0, 4);
                			$f_level = 0;
                			if($current - $initial == 0){
                			    $f_level = 100;
                			}else if($current - $initial == 5){
                			    $f_level = "SO1";
                			}else if($current - $initial == 6){
                			    $f_level = "SO2";
                			}else if(($current - $initial > 0) && ($current - $initial <= 4)){
                			    $f_level = (($current - $initial) * 100) + 100;
                			}
	                    
    						//$level = ;
    						$year = (int) $sess;
    						
    						$this->session->set('level', $f_level);
    						$this->session->set('session_started', $check_login['session_started']);
    						$this->session->set('current_session', $this->portal_config['reg_session']);
    						
    						return redirect()->to(base_url().'/lev-index');
						
					    }else{
					        $programme_detail = $this->levelcoordinator_model->get_programmes_levels($username);
    						$program = [];
    						$level = [];
    						$programme_name = [];
    						foreach($programme_detail as $prog){
    						    
    						    $initial = substr($prog->current_level, 0, 4);
        						$current = substr($this->portal_config['reg_session'], 0, 4);
        						
        						$level_ = ($current - $initial) + 100;
    						    
    						    array_push($program, $prog->programme_id);
    						
    						    array_push($level, $level_);
    						    array_push($programme_name, $this->levelcoordinator_model->get_programme_name($prog->programme_id)['title']);
    						}
    						
    						$this->session->set('login_id', $username);
    						$this->session->set('programmes', $program);
    						$this->session->set('levels', $level);
    						$this->session->set('programme_name', $programme_name);
					        return redirect()->to('check_programme');
					    }
						
					}else{
						$this->session->setTempdata('loginError', 'Incorrect Password', 3);
						return redirect()->to(base_url().'/lev-login');
					}
				}else{
						$this->session->setTempdata('loginError', 'Your account is suspended/deleted. Contanct your HOD', 3);
						return redirect()->to(base_url().'/lev-login');
				}
				
			}else{
				$this->session->setTempdata('loginError', 'Invalid Email or Staff No.', 3);
				return redirect()->to(base_url().'/lev-login');
			}
	}

	} // end of login checker
	
		public function check_programme()
	{

		
		$data = [
			'page_title' => 'Programmes',
			'page_subtitle' => ''
		];
		$data['programmes'] = $this->session->get('programmes');
		$data['levels'] = $this->session->get('levels');
		$data['programme_names'] = $this->session->get('programme_name');
		
		return view("levelcoordinator/check_programme", $data);
		
	}
	
	public function programme_login(){
	    
		if($this->request->getMethod() == 'post'){
		    
			$programme = $this->request->getVar("programme");
			$email = $this->session->get('login_id');
			
			$verfication = $this->levelcoordinator_model->final_verify_levelcoordinator($email, $programme);
			
		    $this->session->set('levelcoordinator_logged', true);
			$this->session->set('username', $verfication['username']);
			$this->session->set('staff_id', $verfication['staff_id']);
			$this->session->set('staff_no', $verfication['stfn']);
			$this->session->set('email', $verfication['email']);
			$this->session->set('id', $verfication['id']);
			$dept_id = $verfication['dept_id'];
			$programme_name = $this->levelcoordinator_model->get_programme_name($verfication['programme_id']);
			$sname = $this->levelcoordinator_model->get_staff_name($email);
			$department = $this->lecturer_model->get_department_name($dept_id)['title'];
		    $dept_details = $this->levelcoordinator_model->get_department_details($dept_id);
		    $faculty_id = $dept_details['faculty_id'];
		    $faculty = $this->levelcoordinator_model->get_faculty_details($faculty_id)['title'];
			$this->session->set('name', $sname['name']);
			$this->session->set('department', $department);
			$this->session->set('faculty', $faculty);
			$this->session->set('programme_id', $verfication['programme_id']);
			$this->session->set('programme_name', $programme_name['title']);
			$this->session->set('department', $department);
			
			$initial = substr($verfication['session_started'], 0, 4);
			$current = substr($this->portal_config['reg_session'], 0, 4);
			$f_level = 0;
			
			if($current - $initial == 0){
			    $f_level = 100;
			}else if($current - $initial == 5){
			    $f_level = "SO1";
			}else if($current - $initial == 6){
			    $f_level = "SO2";
			}else if($current - $initial > 0 && $current - $initial <= 4){
			    $f_level = (($current - $initial) * 100) + 100;
			}
			
			
			$this->session->set('level', $f_level);
			$this->session->set('session_started', $verfication['session_started']);
			$this->session->set('current_session', $this->portal_config['reg_session']);
			
			return redirect()->to(base_url().'/lev-index');
						
        }  
    
	}
	
	public function dashboard()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'Dashboard',
			'page_subtitle' => '',
			'user' => $this->session->get('name'),
			'id' => $this->session->get('id')
		];

		$id = $this->session->get('id');
		$programme = $this->session->get('programme_id');
		$level = $this->session->get('level');
		$session = $this->session->get('current_session');
		$students = $this->levelcoordinator_model->count_all_students($programme, $level, $session);
		$data['active'] = 0;
		$data['graduated'] = 0;
		$data['suspended'] = 0;
		$data['expelled'] = 0;

		if($students){
			foreach($students as $cat){
				if($cat->status == 'Student'){
					$data['active'] += $cat->num;
				}
				if($cat->status == 'Graduated'){
					$data['graduated'] += $cat->num;
				}
				if($cat->status == 'Suspended'){
					$data['suspended'] += $cat->num;
				}
				if($cat->status == 'Expelled'){
					$data['expelled'] += $cat->num;
				}
			}
		}
		
		return view("levelcoordinator/dashboard", $data);
		
	}

	public function test(){
		echo json_encode($this->levelcoordinator_model->get_staff_name('abgarko@yahoo.com'));
	}

	public function view_courses()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'My Courses',
			'page_subtitle' => '',
			'user' => $this->session->get('name')
		];
		$data['result'] = $this->lecturer_model->get_course_allocation('P2013/0383', '2020/2021');
		//$data['user'] = $this->session->get('logged_hod');
		echo view('templates/lecturer_header', $data);
		echo view('lecturer/view_courses');
		echo view('templates/lecturer_footer');
		
	}

	public function view_previous_courses()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'My Previous Courses',
			'page_subtitle' => '',
			'user' => $this->session->get('name')
		];
		$data['result'] = $this->lecturer_model->get_previous_course_allocation('P2013/0383', '2020/2021');
		//$data['user'] = $this->session->get('logged_hod');
		echo view('templates/lecturer_header', $data);
		echo view('lecturer/view_previous_courses');
		echo view('templates/lecturer_footer');
		
	}

	public function view_students()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'My Students',
			'page_subtitle' => 'View My Students',
			'user' => $this->session->get('name')
		];

		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;

		return view("levelcoordinator/view_students", $data);
	}
	
	public function registration_configurations()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$data = [
			'page_title' => 'Settings',
			'page_subtitle' => 'Configurations',
			'user' => $this->session->get('name')
		];

		$programme = $this->session->get('programme_id');
		$username = $this->session->get('username');
		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}

		$available_courses = [];
		
		$selected_courses = $this->levelcoordinator_model->get_selected_courses($programme);

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
		$data['course'] = $this->levelcoordinator_model->get_available_courses($programme);
		$data['detail'] = $this->levelcoordinator_model->get_level_details($username);

		$data['courses_selected'] = $this->levelcoordinator_model->get_selected_courses($programme);

		return view("levelcoordinator/registration_configurations", $data);
	}
	
	

	public function course_registrations()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$data = [
			'page_title' => 'My Students',
			'page_subtitle' => 'Course Registrations',
			'user' => $this->session->get('name')
		];
		
		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
	
		return view("levelcoordinator/course_registrations", $data);
		
	}
	
	public function course_enrollments()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$data = [
			'page_title' => 'My Students',
			'page_subtitle' => 'Course Enrollments',
			'user' => $this->session->get('name')
		];
		
		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
	
		return view("levelcoordinator/course_enrollments", $data);
		
	}

	public function password(){

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		if($this->request->getMethod() == 'post'){
		    $pass = password_hash($this->request->getVar('pass1'), PASSWORD_BCRYPT);
            $error = '';
            $success = '';
			if($this->levelcoordinator_model->update_password($this->session->get('username'), $pass)){
				$success = "Password updated successfully";
			}else{
				$error = "Oops! Something went wrong. Try later.";
			}

            $output = array(
                'error'		=>	$error,
                'success'	=>	$success
            );
        	echo json_encode($output);
		}else{
    		$data = [
    			'page_title' => 'Settings',
    			'page_subtitle' => 'Change Password',
    			'user' => $this->session->get('name')
    		];
    		
    		return view('levelcoordinator/change_password', $data);
		}
		
	}

	public function student_course_registrations()
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		if($this->request->getMethod() == 'post'){
			
			$id = $this->session->get('programme_id');
			$level = $this->session->get('level')."";

			$student = $this->levelcoordinator_model->get_registered_students($id, $level);
			
			foreach($student as $stud){
				//echo $stud->student_id;
				if(isset($_POST[$stud->student_id])){
					$id = $_POST[$stud->student_id];
					
					$data = [
						'page_title' => 'Student Course Registration',
						'user' => $this->session->get('name')
					];
					
					$data['course'] =  $this->levelcoordinator_model->get_courses("Computer Science");
					$data['student'] = $this->levelcoordinator_model->get_student_courses($id);
					$data['detail'] = $this->levelcoordinator_model->get_student_details($id);
					//$data['user'] = $this->session->get('logged_hod');
					echo view('templates/levelcoordinator_header', $data);
					echo view('levelcoordinator/student_course_registrations');
					echo view('templates/levelcoordinator_footer');
				}
			}
		}
			

		
	}
	
	public function lecturers_submission()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'Exam Results',
			'page_subtitle' => 'Lecturers Submission',
			'user' => $this->session->get('name')
		];

		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}
		

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
		
		return view('levelcoordinator/lecturers_submission', $data);
		
	}

	public function course_submitted($id)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
			
			//$id = $this->session->get('programme_id');
			$level = $this->session->get('level')."";
            //$id = str_replace(",", "/", $id);

			//$submission = $this->levelcoordinator_model->get_programme_submitted_result('CSC20', '1st', '2020/2021');
			$data = [
				'page_title' => 'Course Submission',
				'page_subtitle' => '',
				'user' => $this->session->get('name')
			];
					
			$data['course'] =  $this->levelcoordinator_model->get_courses("Computer Science");
			$data['submission'] = $this->levelcoordinator_model->get_marks($id);
			$data['detail'] = $this->levelcoordinator_model->get_course_detail_($id);
			//$data['user'] = $this->session->get('logged_hod');

			echo view('templates/levelcoordinator_header', $data);
			echo view('levelcoordinator/course_submitted');
			echo view('templates/levelcoordinator_footer');
		
	}
	
	public function session_report()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'Exam Results',
			'page_subtitle' => 'Report',
			'user' => $this->session->get('name')
		];

		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}
		
		//$data['session'] =  $this->levelcoordinator_model->get_session(58);
		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
		
		return view('levelcoordinator/session_report', $data);

	}
	
	public function compute_result()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'Exam Results',
			'page_subtitle' => 'Results',
			'user' => $this->session->get('name')
		];

		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}
		
		//$data['session'] =  $this->levelcoordinator_model->get_session(58);
		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
		
		return view('levelcoordinator/compute_result', $data);

	}
	
	public function verify_result()
	{

		if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$data = [
			'page_title' => 'Exam Results',
			'page_subtitle' => 'Verification',
			'user' => $this->session->get('name')
		];

		$session = $this->session->get('current_session');
		$id = $this->session->get('programme_id');
		$level = $this->session->get('level');

		$data['student'] = $this->levelcoordinator_model->get_registered_students($id, $level, $session);
		
		return view('levelcoordinator/verify_result', $data);

	}

	public function configuration_action(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		if($this->request->getMethod() == 'post'){
		    
		    $session = $this->session->get("current_session");

			if($this->request->getPost('action') == 'credit_limit'){

			    $username = $this->session->get('username');
				$minimum = $this->request->getVar("minimum");
				$maximum = $this->request->getVar("maximum");
                
                if($minimum >= 15){
                    if($this->levelcoordinator_model->update_credit_limit($username, $minimum, $maximum)){
					//$this->session->setTempdata('saveSuccess','Credit Unit Added Successfully',3);
					return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveSuccess', 'Saved Successfully');
    				}else{
    					//$this->session->setTempdata('saveError','Oops! Something went wrong',3);
    					return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveError','Oops! Something went wrong');
    				}
                }else{
                    return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveError','Oops! Minimum credit units sholud not be less than 15');
                }
				

			}// End of Save Credit Limit

			if($this->request->getPost('action') == 'core_course'){

				$username = $this->session->get('username');
				$core_courses = $this->request->getVar("core_course");
	
				foreach($core_courses as $co){
					
					$selected_core = explode("-",$co);
					
					$code = $selected_core[0];
					$title = $selected_core[1];
					$unit = $selected_core[2];
					$semester = $selected_core[3];
	
					$data = [
						'code' => $code,
						'title' => $title,
						'unit' => (int) $unit,
						'semester' => $semester,
						'selected_programme' => $this->session->get('programme_id'),
						'status' => 'Core',
						'added_by' => $this->session->get('staff_id'),
						'session' => $session
					];
	
					$save_status = "";
					if($this->levelcoordinator_model->save_core_courses($data)){
						$save_status = true;
						//$this->session->setTempdata('saveSuccess','Credit Unit Added Successfully',3);
						//return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveSuccess', 'Saved Successfully');
					}else{
						$save_status = false;
						//$this->session->setTempdata('saveError','Oops! Something went wrong',3);
						//return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveError','Oops! Something went wrong');
					}
				}
	
				if($save_status){
					return redirect()->to(base_url('lev-configurations'))->with('saveSuccess', 'Saved Successfully');
				}else{
					return redirect()->to(base_url('lev-configurations'))->with('saveError','Oops! Something went wrong');
				}
	
			}//End Save Core Course

			if($this->request->getPost('action') == 'elective_course'){

				$username = $this->session->get('username');
				$core_courses = $this->request->getVar("elective_course");

				foreach($core_courses as $co){
					
					$selected_core = explode("-",$co);
					
					$code = $selected_core[0];
					$title = $selected_core[1];
					$unit = $selected_core[2];
					$semester = $selected_core[3];

					$data = [
						'code' => $code,
						'title' => $title,
						'unit' => (int) $unit,
						'semester' => $semester,
						'selected_programme' => $this->session->get('programme_id'),
						'status' => 'Elective',
						'added_by' => $this->session->get('staff_id'),
						'session' => $session
					];

					$save_status = "";
					if($this->levelcoordinator_model->save_elective_courses($data)){
						$save_status = true;
						//$this->session->setTempdata('saveSuccess','Credit Unit Added Successfully',3);
						//return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveSuccess', 'Saved Successfully');
					}else{
						$save_status = false;
						//$this->session->setTempdata('saveError','Oops! Something went wrong',3);
						//return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveError','Oops! Something went wrong');
					}
				}

				if($save_status){
				    //return redirect()->to(base_url('lev-verify'))->with('saveError','Oops! Something went wrong');
					return redirect()->to(base_url('lev-configurations'))->with('saveSuccess', 'Saved Successfully');
				}else{
					return redirect()->to(base_url('lev-configurations'))->with('saveError','Oops! Something went wrong');
				}

			}//End of Save Elective Coure

			if($this->request->getPost('action') == 'delete_course'){
	            $error = '';
	            $success = '';
				if($this->levelcoordinator_model->delete_selected_course($this->request->getPost('id'))){
					$success = "Course deleted successfully";
				}else{
					$error = "Oops! Something went wrong. Try later.";
				}
    
	            $output = array(
	                'error'		=>	$error,
	                'success'	=>	$success
	            );
            	echo json_encode($output);

			}//End of Delete Course
		}		

	}

	public function credit_limit_action()
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$username = $this->session->get('username');
		$minimum = $this->request->getVar("minimum");
		$maximum = $this->request->getVar("maximum");

		if($this->levelcoordinator_model->update_credit_limit($username, $minimum, $maximum)){
			//$this->session->setTempdata('saveSuccess','Credit Unit Added Successfully',3);
			return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveSuccess', 'Saved Successfully');
		}else{
			//$this->session->setTempdata('saveError','Oops! Something went wrong',3);
			return redirect()->to(base_url('levelcoordinator/registration_configurations'))->with('saveError','Oops! Something went wrong');
		}
	}

	public function add_drop()
	{
	
		if($this->request->getMethod() == 'post'){

			if(isset($_POST['add_course'])){
				echo "jhh";
			}else if(isset($_POST['drop_course'])){

			}

		}
	}
	
	

	// get semesters available
	function get_semester_submission($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$staff_no = $this->session->get('id');
		$username = $this->session->get('username');
		$programme = $this->levelcoordinator_model->get_semester($username, $session);
		
		$value = [];
		$output = "";
		if(!empty($programme)){
			$output .= '<div class="form-group">
			<label class="label"><b>Select Semester:</b></label><br/>
			<select class="form-control select2" name="semester" id="semester" onchange="spawn_submission()" required> 
			<option selected disabled value="">-Semester-</option>';
			foreach($programme as $prog){
				$output .= "<option value = ".$prog->semester.">".$prog->semester."</option>";                                            
			}
			$output .= "</select> <i></i><b class='tooltip tooltip-bottom-right'>Labels</b></section>";
		}else{
			$output .= '<br/><div class="alert alert-danger alert-dismissible"><i class="icon fas fa-exclamation-triangle"></i> No result submission for this session!</div>';
		}
					
		echo $output;
	}
	
	// get students verification available
	function get_student_verification($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$staff_no = $this->session->get('id');

		$id = $this->session->get('programme_id');
		$level = $this->session->get('level');
		
		$session_started = $this->session->get('session_started');
		
		$initial = substr($session_started, 0, 4);
		$current = substr($session, 0, 4);
		
		$f_level = 0;
		if($current - $initial == 0){
		    $f_level = 100;
		}else{
		    $f_level = (($current - $initial) * 100) + 100;
		}
		
		$student = $this->levelcoordinator_model->get_registered_students($id, $f_level, $session);
		
		$value = [];
		$output = "";
		if(!empty($student)){
			$output .= '<div class="form-group">
					<label class="label"><b>Select Student:</b></label>
					<select class="form-control select2" name="semester" id="student" onchange="spawn_verify_courses()" required> 
					<option selected disabled value="">-Student-</option>';
			foreach($student as $stud){
			    $stud_id = $stud->student_id;
			    $output .= "<option value = ".$stud->student_id.">".$stud->registration_no."</option>";                                                          
				                                          
			}
			$output .= "</select>";
		}else{
			//$output .= "<br/><br/><h4>There is no result available for this session</h4>";
			$output .= '<br/><div class="alert alert-danger alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                  <i class="icon fas fa-exclamation-triangle"></i> No student registered for this session yet!
                </div>';
		}
					
		echo $output;
	}

	// get semesters available
	function get_semester_available($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$staff_no = $this->session->get('id');

		$username = $this->session->get('username');
		$programme = $this->levelcoordinator_model->get_semester($username, $session);
		
		$value = [];
		$output = "";
		if(!empty($programme)){
			$output .= '<div class="form-group">
					<label class="label"><b>Select Semester:</b></label>
					<select class="form-control select2" name="semester" id="semester" onchange="spawn_result()" required> 
					<option selected disabled value="">-Semester-</option>';
			foreach($programme as $prog){
				$output .= "<option value = ".$prog->semester.">".$prog->semester."</option>";                                            
			}
			$output .= "</select>";
		}else{
			//$output .= "<br/><br/><h4>There is no result available for this session</h4>";
			$output .= '<br/><div class="alert alert-danger alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                  <i class="icon fas fa-exclamation-triangle"></i> No result available for this session yet!
                </div>';
		}
					
		echo $output;
	}
	
	function get_verification_course($session, $student)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$student = urldecode($student);
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		
		$courses = $this->levelcoordinator_model->get_student_courses($student, $session);
		
		
		$output = "";
		if(!empty($courses)){
			$output .= '<div class="form-group">
					<label class="label"><b>Select Course:</b></label>
					<select class="form-control select2" name="semester" id="course" onchange="spawn_verify_grades()" required> 
					<option selected disabled value="">-Course-</option>';
					foreach($courses as $co){
				        $output .= "<option value = ".$co->course_id.">".$co->title."</option>";                                            
			        }
			
			$output .= "</select>";
		}else{
			//$output .= "<br/><br/><h4>There is no result available for this session</h4>";
			$output .= '<br/><div class="alert alert-danger alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                  <i class="icon fas fa-exclamation-triangle"></i> The Student did not register for any course!
                </div>';
		}
					
		echo $output;
	}
	
	function get_verification_grades($session, $student, $course)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$student = urldecode($student);
		$course = urldecode($course);
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		
		$grades = $this->levelcoordinator_model->get_verify_grade($student, $course, $session);
		
		
		$output = "";
		if(!empty($grades)){
		    foreach($grades as $gr){
		        $reg_no = $gr->reg_no;
		        $ca = $gr->ca_marks;
		        $exam = $gr->exam_marks;
		        $total = $gr->total_marks;
		        $grade = $gr->grade;
		        $instance_id = $gr->result_instance_id;
		    }
		    
			$output .= '<div class="row">';
			$output .= '<input type = "text" name = "reg_no" value = '.$reg_no.' hidden>';
			$output .= '<input type = "text" name = "instance" value = '.$instance_id.' hidden>';
			$output .=    "<div class='col-md-3'><div class='form-group'><strong>CA:</strong> <input class='form-control' type = 'text' value = ".$ca." name = 'ca' id = 'ca' onchange = ca_validation()></div></div>";
			$output .=    "<div class='col-md-3'><div class='form-group'><strong>Exam:</strong> <input class='form-control' type = 'text' value = ".$exam." name = 'exam' id = 'exam' onchange = exam_validation()></div></div>";
			$output .=    "<div class='col-md-3'><div class='form-group'><strong>Total:</strong> <input class='form-control' type = 'text' value = ".$total." name = 'total' id = 'total' readonly></div></div>";
			$output .=    "<div class='col-md-3'><div class='form-group'><strong>Grade:</strong> <input class='form-control' type = 'text' value = ".$grade." name = 'grade' id = 'grade' readonly></div></div>";
			    
			$output .= '<div class="row">
			    <div class="col-md-12"><div class="form-group"><button class="btn btn-primary save" type = "submit">Save Changes</button></div></div>';	
			
			$output .= "</div>";
		}else{
		
			$output .= '<br/><div class="alert alert-danger alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                  <i class="icon fas fa-exclamation-triangle"></i> No Submission for such course!
                </div>';
		}
					
		echo $output;
	}
	
	public function save_verify_result(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		if($this->request->getMethod() == 'post'){

		    $reg_no = $this->request->getVar("reg_no");
			$instance = $this->request->getVar("instance");
			$ca = $this->request->getVar("ca");
			$exam = $this->request->getVar("exam");
			$total = $this->request->getVar("total");
			$grade = $this->request->getVar("grade");

			if($this->levelcoordinator_model->save_verify_result($reg_no, $instance, $ca, $exam, $total, $grade)){
				//$this->session->setTempdata('saveSuccess','Credit Unit Added Successfully',3);
				return redirect()->to(base_url('lev-verify'))->with('saveSuccess', 'Saved Successfully');
			}else{
				//$this->session->setTempdata('saveError','Oops! Something went wrong',3);
				return redirect()->to(base_url('lev-verify'))->with('saveError','Oops! Something went wrong');
			}
			
		}
		
	}

	//View students
	function get_students($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$session_value = urldecode($session);
		$session = str_replace("_","/",$session_value);
		$id = $this->session->get('programme_id');
		
		$session_started = $this->session->get('session_started');
		
		$initial = substr($session_started, 0, 4);
		$current = substr($session, 0, 4);
		
		$f_level = 0;
		if($current - $initial == 0){
		    $f_level = 100;
		}else{
		    $f_level = (($current - $initial) * 100) + 100;
		}

		$student = $this->levelcoordinator_model->get_registered_students($id, $f_level, $session);
		//$student = $this->levelcoordinator_model->get_registered_students($level, $session);
		$output = "";
		$course_registration_dialog = "";
		
		if($student){

			
			$output .= "<div class='row'  >
	
			<div class='col-md-12 table-responsive' > 
			<table id='example1' class='table table-bordered table-striped'>
					<thead>
				   <tr>
						<th>S/N</th> 
						<th>Full Name</th>
						<th>Registration Number</th>
						<th>Current Level</th>
						<th class='text-center'>Action</th>
						
					  </tr>
			   </thead>
			<tbody>";
			$i = 1;
			foreach($student as $stud){	

				$reg_no = $stud->registration_no;
				$id_value = "#".$stud->registration_no;
				$output .= "<tr><td>".$i."</td>";
				$output .= "<td>".$stud->first_name." ".$stud->middle_name." ".$stud->last_name."</td>";
				$output .= "<td>".$stud->registration_no."</td>";
				$output .= "<td>".$stud->level."</td>";
				$output .= '<td class="text-center"><button data-id = '.$stud->id.' class="btn btn-primary btn-xs view_student"> <i class="fas fa-user"> View Details</i></button></td>';
				$output .= "</tr>";
				$i++;
				
			}							
	
			$output .="</tbody>
			</table>
			</div>
			</div>";


		}else{
			$output .= '<div class="alert alert-danger"><i class="icon fas fa-exclamation-triangle"></i> No students for the selected session</div>';
		}
	
		echo $output;
		
	}
	
	

	function get_student_details(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		if ($this->request->getPost()) {
			$my_id = $this->request->getPost("my_id");
			$student = $this->levelcoordinator_model->get_student_details($my_id);
			$output = "";

			if($student){

				foreach($student as $stud){	
					$student_name = $stud->first_name." ".$stud->middle_name." ".$stud->last_name;
					$output .= '
		              	<div class="tab-content">
	  						<div class="active tab-pane" id="biodata">
	  							<div class="row text-center">
	  								<div class="col-md-12">
	  								<img class="profile-user-img img-fluid img-circle" src=" '.base_url('public/pictures/1539.jpg').'" style="width: 120px;" alt="Student profile picture">
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-12">
	  								<div class="form-group">
									<label>Full Name</label>
									<input class="form-control" value = "'.$student_name.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>UTME No.</label>
									<input class="form-control" value = "'.$stud->utme_no.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Registration No.</label>
									<input class="form-control" value = "'.$stud->registration_no.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>level</label>
									<input class="form-control" value = "'.$stud->level.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Gender</label>
									<input class="form-control" value = "'.$stud->gender.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Date of Birth</label>
									<input class="form-control" value = "'.$stud->birthdate.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Marital</label>
									<input class="form-control" value = "'.$stud->marital_status.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Religion</label>
									<input class="form-control" value = "'.$stud->religion.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>Tribe</label>
									<input class="form-control" value = "'.$stud->tribe.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-4">
	  								<div class="form-group">
									<label>State of Origin</label>
									<input class="form-control" value = "'.$stud->state_of_origin.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  						</div>
	  						<div class="tab-pane" id="contact">
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Email</label>
									<input class="form-control" value = "'.$stud->email.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Phone</label>
									<input class="form-control" value = "'.$stud->phone.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Contact Address</label>
									<textarea class="form-control" rows="3" disabled>'.$stud->contact_address.'</textarea>
	  								</div>
	  								</div>
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Permanent Address</label>
									<textarea class="form-control" rows="3" disabled>'.$stud->contact_address.'</textarea>
	  								</div>
	  								</div>
	  							</div>
	  						</div>
	  						<div class="tab-pane" id="nok">
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Name</label>
									<input class="form-control" value = "'.$stud->next_of_kin_name.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Phone</label>
									<input class="form-control" value = "'.$stud->next_of_kin_phone.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Address</label>
									<textarea class="form-control" rows="3" disabled>'.$stud->next_of_kin_address.'</textarea>
	  								</div>
	  								</div>
	  							</div>
	  						</div>
	  						<div class="tab-pane" id="sponsor">
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Sponsorship Type</label>
									<input class="form-control" value = "'.$stud->sponsorship_type.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Sponsor Name</label>
									<input class="form-control" value = "'.$stud->sponsor_name.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Sponsor Phone</label>
									<input class="form-control" value = "'.$stud->sponsor_phone.'" disabled/>
	  								</div>
	  								</div>
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Sponsor Email</label>
									<input class="form-control" value = "'.$stud->sponsor_email.'" disabled/>
	  								</div>
	  								</div>
	  							</div>
	  							<div class="row">
	  								<div class="col-md-6">
	  								<div class="form-group">
									<label>Sponsor Address</label>
									<textarea class="form-control" rows="3" disabled>'.$stud->sponsor_address.'</textarea>
	  								</div>
	  								</div>
	  							</div>
	  						</div>
		              	</div>';
				}
	    	}else{
	    		$output .="No record found";
	    	}
	        echo json_encode($output);
		}
	}
	
	
		
//
	//View list course registrations
	function get_course_registrations($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$session_value = urldecode($session);
		$session = str_replace("_","/",$session_value);
		$id = $this->session->get('programme_id');
		$session_started = $this->session->get('session_started');
		
		$initial = substr($session_started, 0, 4);
		$current = substr($session, 0, 4);
		
		$f_level = 0;
		if($current - $initial == 0){
		    $f_level = 100;
		}else{
		    $f_level = (($current - $initial) * 100) + 100;
		}

		$student = $this->levelcoordinator_model->get_registered_students($id, $f_level, $session);
		$output = "";
		$course_registration_dialog = "";
		$add_course_dialog = "";
		
		if($student){

			foreach($student as $stud){
				if($this->levelcoordinator_model->get_registration_status($stud->student_id, $session)){				
					$stud->status = "Registered";
				}else{
					$stud->status = "Not Registered";
				}
			}
			
			$output .= "<div class='row'  >
	
			<div class='col-md-12 table-responsive' > 
			<table id='example1' class='table table-bordered table-striped'>
					<thead>
				   <tr>
						<th>S/N</th> 
						<th>Full Name</th>
						<th>Registration Number</th>
						<th>Status</th>
						<th>Action</th>
						
					  </tr>
			   </thead>
			<tbody>";
			$i = 1;
			foreach($student as $stud){		
				$reg_no = $stud->registration_no;
				$id_value = "#".$stud->registration_no;
				$output .= "<tr><td>".$i."</td>";
				$output .= "<td>".$stud->first_name." ".$stud->middle_name." ".$stud->last_name."</td>";
				$output .= "<td>".$stud->registration_no."</td>";
				if($stud->status == "Not Registered"){ 
				    $output .= "<td><span class='badge badge-danger'>".$stud->status."</span></td>";
					$output .= "<td><button type = 'submit' disabled class='btn btn-primary btn-xs'><i class='fa fa-eye' disabled></i> View CRF</button></td>";
				}else{ 
					//echo $stud->status;
				    $output .= "<td><span class='badge badge-success'>".$stud->status."</span></td>";
					$output .= '<td><a href = '.$id_value.'  data-toggle="modal"><button  class="btn btn-primary btn-xs"><i class="fa fa-eye"></i> View CRF</button></a></td>';
				} 
				$output .= "</tr>";
				$i++;

				$add_dialog_id = "#".$reg_no."_";
				$course_registration_dialog .= '<div class="modal hide fade in" data-backdrop="static" id='.$reg_no.' >
							<div class="modal-dialog modal-xl">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"><span class="badge badge-secondary">Full Name: </span>'.$stud->first_name.' '.$stud->middle_name.' '.$stud->last_name.'<br/><span class="badge badge-secondary">Reg. No.: </span>'.$reg_no.'<br/><span class="badge badge-secondary">Session: </span>'.$session.'<br/></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body">
								<table id="example11" class="table table-bordered table-striped" width="100%">
								<thead>
								<tr>
									<th>S/N</th> 
									<th>Course Code</th>
									<th>Course Title</th>
									<th>Credits Unit</th>
									<th>Semester</th>
								</tr>
						</thead>
						<tbody>';
								
						$courses = $this->levelcoordinator_model->get_student_courses($stud->student_id, $session);

						$index = 1;
						if($courses){
						   foreach($courses as $co){
							$course_registration_dialog .= "<tr><td>".$index++."</td>";
							$course_registration_dialog .= "<td>".$co->course_id."</td>";
							$course_registration_dialog .= "<td>".$co->title."</td>";
							$course_registration_dialog .= "<td>".$co->credit_units."</td>";
							$course_registration_dialog .= "<td>".$co->semester."</td>";
							$course_registration_dialog .= "</tr>";
						  } 
						}else{
						    
						}
						
								$course_registration_dialog .="
								</tbody>
								</table>
								<div class='modal-footer justify-content-between'>
								<button type='button' class='btn btn-default' data-dismiss='modal'>Close</button>
								
								</div>
								</div>
								</div>
								</div>
								</div>";

								

			}							
	
			$output .="</tbody>
			</table>
			</div>
			</div>";


		}else{
			$output .= '<div class="alert alert-danger"><i class="icon fas fa-exclamation-triangle"></i> No students for the selected session</div>';
		}
	
		echo $output;
		echo $course_registration_dialog;
		echo $add_course_dialog;
	}
	
	//View list of registered course
	function get_course_enrollments($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$session_value = urldecode($session);
		$session = str_replace("_","/",$session_value);
		$programme_id = $this->session->get('programme_id');
		$username = $this->session->get('username');
		$year_admitted =  substr($username, 3, 2);
		$year_admitted = (int) "20".$year_admitted;
		$current_session = substr($session, 0, 4);
		$level = ((int) substr($session, 0, 4) - $year_admitted) * 100;
		if($level == 0){
		    $level = 100;
		}
		//$level = (int) $level;

		$courses = $this->levelcoordinator_model->get_student_registered_courses($programme_id, $session, $level);
		$output = "";
		$course_registration_dialog = "";
		
		
		if($courses){

			
			
			$output .= "<div class='row'  >
	
			<div class='col-md-12 table-responsive' > 
			<table id='example1' class='table table-bordered table-striped'>
					<thead>
				   <tr>
						<th>S/N</th> 
						<th>Code</th>
						<th>Title</th>
						<th>Number of Students</th>
						<th>Semester</th>
						<th>Action</th>
						
					  </tr>
			   </thead>
			<tbody>";
			$i = 1;
			foreach($courses as $co){		
				$code = $co->course_id;
				$id_value = "#".$co->course_id;
				$students_enrollemnt = $this->levelcoordinator_model->get_enrolled_students($programme_id, $code, $level, $session);
				
				$output .= "<tr><td>".$i."</td>";
				$output .= "<td>".$code."</td>";
				$output .= "<td>".$co->title."</td>";
				$output .= "<td>".count($students_enrollemnt)."</td>";
				$output .= "<td>".$co->semester."</td>";
			    $output .= '<td><a href = '.$id_value.'  data-toggle="modal"><button  class="btn btn-primary btn-xs"><i class="fa fa-eye"></i> View CRF</button></a></td>';
			
				$output .= "</tr>";
				$i++;
				
				
				
				$course_registration_dialog .= '<div class="modal hide fade in" data-backdrop="static" id='.$code.' >
							<div class="modal-dialog modal-xl">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"><span class="badge badge-secondary">Full Name: </span>'.$code.'<br/><span class="badge badge-secondary">Reg. No.: </span>'.$co->title.'<br/><span class="badge badge-secondary">Session: </span>'.$session.'<br/></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body">
								<table id="example11" class="table table1 table-bordered table-striped" width="100%">
								<thead>
								<tr>
									<th>S/N</th> 
									<th>Registration Number</th>
									<th>Full Name</th>
									<th>Contact Number</th>
									
								</tr>
						</thead>
						<tbody>';
								
						        	$index = 1;
						if($students_enrollemnt){
						   foreach($students_enrollemnt as $stud){
							$course_registration_dialog .= "<tr><td>".$index++."</td>";
							$course_registration_dialog .= "<td>".$stud->registration_no."</td>";
							$course_registration_dialog .= "<td>".$stud->first_name.' '.$stud->middle_name.' '.$stud->last_name."</td>";
							$course_registration_dialog .= "<td>".$stud->phone."</td>";
							$course_registration_dialog .= "</tr>";
						  } 
						}else{
						    
						}
						
								$course_registration_dialog .="
								</tbody>
								</table>
								<div class='modal-footer justify-content-between'>
								<button type='button' class='btn btn-default' data-dismiss='modal'>Close</button>
								
								</div>
								</div>
								</div>
								</div>
								</div>";

								

			}							
	
			$output .="</tbody>
			</table>
			</div>
			</div>";


		}else{
			$output .= '<div class="alert alert-danger"><i class="icon fas fa-exclamation-triangle"></i> No courses enrollments for this session</div>';
		}
	
		echo $output;
		echo $course_registration_dialog;
	}

	//View list of submitted result
	function get_result_submitted($semester, $session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$semester = urldecode($semester);
		$programme_id = $this->session->get("programme_id");
		$username = $this->session->get('username');
		$year_admitted = substr($username, 3, 2);
		$year_admitted = (int) "20".$year_admitted;
		$level = $this->session->get('level');;
		
		$program_details = $this->levelcoordinator_model->get_program_detail($programme_id);
		$output = "";
		$view_dialog = "";
		if(!empty($semester)){
			$submission = $this->levelcoordinator_model->get_submission_instance_result($username, $session, $semester);

			if($submission){
				foreach($submission as $sub){
					if(strpos($sub->course_id, "GSP") !== false || strpos($sub->course_id, "GST") !== false){
						$sub->lecturer = "GSP Coordinator";
					}else{
						$details = $this->hod_model->get_staff_details($sub->lecturer_id);
						$sub->lecturer = $details['name']; 
					}
	
					$cdetails = $this->examofficer_model->get_course_details($sub->course_id);
					$sub->course_title = $cdetails['title']; 
				}
				
				$output .= "<div class='row'>
		
				<div class='col-md-12 table-responsive' > 
				<table id='example1' class='table table-bordered table-striped'>
						<thead>
					   <tr>
							<th>S/N</th> 
							<th>Course Code</th>
							<th>Course Title</th>
							<th>Lecturer</th>
							<th>Action</th>
							
						  </tr>
				   </thead>
				<tbody>";
				$i = 1;
				foreach($submission as $sub){	
					
					$output .= "<tr><td>".$i++."</td>";
					$output .= "<td>".$sub->course_id."</td>";
					$output .= "<td>".$sub->course_title."</td>";
					$output .= "<td>".$sub->lecturer."</td>";
						$id_value = "#".$sub->id;
						$id_real = $sub->id;
						$output .= '<td><button title="View" class="btn btn-info btn-xs" data-target = '.$id_value.' data-toggle="modal" ><i class="fas fa-eye"></i> View</button> 
						</td>';
						
						$view_dialog .= '<div class="modal fade" id='.$sub->id.' >
								<div class="modal-dialog modal-lg">
								  <div class="modal-content">
									<div class="modal-header">
    								  <h5 class="modal-title"><span class="badge badge-secondary">Course: </span>'.$sub->course_id.': '.$sub->course_title.'<br/>
    								  <span class="badge badge-secondary">Session: </span>'.$session.'</h5>
									  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
										<span aria-hidden="true">&times;</span>
									  </button>
									</div>
									<div class="modal-body">
									
									<table id="example11" class="table table1 table-bordered table-striped">
									<thead>
									<tr>
										<th>S/N</th> 
										<th style="width:15%" >Registration Number</th>
										<th style="width:45%" >Full Name</th>
										<th>CA</th>
										<th>Exam</th>
										<th>Total</th>
										<th>Grade</th>
									</tr>
									</thead>
									<tbody>';
				
									$result = $this->lecturer_model->get_marks($sub->id);
									$index = 1;
									$color = '';
									if(!empty($result)){
									foreach($result as $res){
										if($res->grade == 'F'){
											$color = 'text-danger';
										}

										$view_dialog .= '<tr class="'.$color.'">';
										$view_dialog .= '<td>'.$index++.'</td>';
										$view_dialog .= '<td>'.$res->reg_no.'</td>';
										$view_dialog .= '<td>'.$res->first_name.' '.$res->middle_name.' '.$res->last_name.'</td>';
										$view_dialog .= '<td>'.$res->ca_marks.'</td>';
										$view_dialog .= '<td>'.$res->exam_marks.'</td>';
										$view_dialog .= '<td>'.$res->total_marks.'</td>';
										$view_dialog .= '<td>'.$res->grade.'</td>';
										$view_dialog .= '</tr>';
										$color = '';
									}
									}
									
									$view_dialog .="</tbody>
									</table>
									</div>
									</div>
									</div>
									</div>";
	
					
					$output .= "</tr>";
					
					
				}							
		
				$output .="</tbody>
				</table>
				</div>
				</div>";
			}else{
				$output .= "No record found";
			}
			
			
		}else{
			$output .= "List of Submmission";
		}
		
	
		echo $output;
		echo $view_dialog;
	}

	function gtest(){
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		$id = $this->session->get('programme_id');
		$semester = '2nd';
		$session = '2020/2021';
		$programme_id = $this->session->get('programme_id');
		$username = $this->session->get('username');
		$year_admitted = substr($username, 3, 2);
		$year_admitted = (int) "20".$year_admitted;
		$level = (int) substr($session, 0, 4) - $year_admitted + 100;

		echo 'LEVEL = '.$level;
		echo '<br/>ID = '.$id;
		echo '<br/>PROG ID = '.$programme_id;
		echo '<br/>USERNAME = '.$username;
		echo '<br/>YR AD = '.$year_admitted;
		echo '<br/>';

		$submission = $this->levelcoordinator_model->get_submission_instance_result_($programme_id, $session, $semester, $level);
		echo json_encode($submission);

		echo '<br/>';

		$submission_status = "";
		$result_label = "";
		foreach($submission as $sub){
			$result_status = $this->levelcoordinator_model->get_submission_status($sub->course_id, $username, $session);
			if($result_status){	
				if($result_status['hod_status'] == 'Accepted'){
					echo $sub->course_id.'<br/>';
					echo $username.'<br/>';
					echo $session.'<br/>';
					echo 'All is well<br/>';
				}else{
					echo $sub->course_id.'<br/>';
					echo $username.'<br/>';
					echo $session.'<br/>';
					echo "One of the result is yet to be approved<br/>";
				}			
			}else{
					echo $sub->course_id.'<br/>';
					echo $username.'<br/>';
					echo $session.'<br/>';
				echo "Lecturers did not make full submission<br/>";
				break;
			}
		}
	}
	
	// get semesters available
	function get_download_report($session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}
		
		$id = $this->session->get('programme_id');
		
		
		       $output .= '<div class="row">
		       <div class="col-12">
		        <button type="submit" name = "raw_marks" value = "raw_marks" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Session Report</button>
				</div>
			        
				</div>';
		echo $output;
		
	}
	
	public function download_report(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		if($this->request->getMethod() == 'post'){
		    
		    $this->fpdf->AliasNbPages();
    		$this->fpdf->SetAutoPageBreak(1,13);
    		$this->fpdf->AddPage('P','A4');
    		
    		$logo = "assets/img/yumsuk_logo.jpg";
    		
    		// Logo
    		$this->fpdf->Image($logo, 6, 8, 30);
    		// Arial bold 15
    		// Move to the right
    		$this->fpdf->Cell(80);
    		// Title
    		$this->fpdf->setFont('Arial','B',14);
    		$this->fpdf->SetTextColor(0, 0, 0);
    		$this->fpdf->Cell(45,10,'YUSUF MAITAMA SULE UNIVERSITY, KANO',0,0,'C');
    		
    		// Line break
    		$this->fpdf->Ln(5);
    		$this->fpdf->setFont('times','',11);
    		$this->fpdf->Cell(190,10,'KANO STATE, NIGERIA',0,0,'C');
    		// Line break
    		$this->fpdf->Ln(7);
    		
    		// Line break
    		$this->fpdf->setFont('times','B',14);
    		$this->fpdf->Cell(190,10,'STUDENT\'S END OF SESSION REPORT FORM',0,0,'C');
    		// Line break
    		$this->fpdf->Ln(2);
    		$this->fpdf->Ln(2);
    		
    		$this->fpdf->SetMargins(5, 0, 0, 0);
    
    		$this->fpdf->Ln(2);
    		$this->fpdf->SetFont('times','B',12);
    
    		$this->fpdf->Ln(8);
    		$this->fpdf->setFillColor(169,169,169);
    		$this->fpdf->Cell(190, 7, 'PERSONAL INFORMATION', 0,0, 'C', 1);
    		
    		$this->fpdf->SetFont('times','B',11);
			$this->fpdf->Ln(6);
			$this->fpdf->Cell(45, 10, 'FULL NAME: ',0,0,'R');
			$this->fpdf->SetFont('times','',11);
    		$this->fpdf->Cell(50, 10, "ABDULAZIZ AMINU");
			
			$this->fpdf->Cell(90, 10, 'REG. NUMBER: ', 0,0,'R');
			//$this->fpdf->Cell("SESSION", 150, 53, 28, 28);
		
    		//$pdf->Cell(30, 80, $pdf->Image($image, $pdf->GetX, $pdf->GetY, 30), 0, 0, 'L');
    		
    		$this->fpdf->SetFont('times','',11);
    		$this->fpdf->Cell(105, 10, "");
    		
    		$this->fpdf->Ln(6);
    		$this->fpdf->SetFont('times','B',11);
    		$this->fpdf->Cell(45, 10, 'FACULTY: ',0,0,'R');
    		
    		$this->fpdf->Cell(105, 10, 'SESSION: ', 0,0,'R');
    		
    		$this->fpdf->SetFont('times','',11);
    		$this->fpdf->Cell(105, 10, "");
    		
    		$this->fpdf->Ln(6);
    		$this->fpdf->SetFont('times','B',11);
    		$this->fpdf->Cell(45, 10, 'DEPARTMENT: ',0,0,'R');
    		
    		$this->fpdf->Cell(105, 10, 'LEVEL: ', 0,0,'R');
    		
    		$this->fpdf->SetFont('times','',11);
    		$this->fpdf->Cell(105, 10, "");
    		
    		$this->fpdf->Ln(6);
    		$this->fpdf->SetFont('times','B',11);
    		$this->fpdf->Cell(45, 10, 'PROGRAMME: ',0,0,'R');
    		
    		$this->fpdf->Cell(105, 10, 'PREVIOUS CGPA: ', 0,0,'R');
    		
    		$this->fpdf->SetFont('times','',11);
    		$this->fpdf->Cell(105, 10, "");
    		
    		
    		$this->fpdf->Ln(8);
    		$this->fpdf->SetFont('times','B',12);
    		$this->fpdf->setFillColor(169,169,169);
    		$this->fpdf->Cell(190, 7, 'REGISTERED COURSES', 0,0, 'C', 1);
    		
    		$this->fpdf->Ln(2);
    		$this->fpdf->SetFont('times','B',12);
    		$this->fpdf->Cell(90, 20, 'First Semester Registered Courses', 0, 0, 'C');
    		$this->fpdf->Cell(100, 20, 'Second Semester Registered Courses', 0, 0, 'C');
    		
    		$this->fpdf->Ln(12);
    		$this->fpdf->SetFont('times','B',10);
    		$this->fpdf->setFillColor(169,169,169);
    		$this->fpdf->Cell(12, 7, "Code", 1, 0, 'L', 1);
    		$this->fpdf->Cell(65, 7, "Title", 1, 0, 'L', 1);
    		$this->fpdf->Cell(10, 7, "Unit", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "Grade", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "GP", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "PE", 1, 0, 'L', 1);
    		
    		$this->fpdf->Cell(3, 7, "", 0, 0, 'L');
    		
    		$this->fpdf->Cell(12, 7, "Code", 1, 0, 'L', 1);
    		$this->fpdf->Cell(65, 7, "Title", 1, 0, 'L', 1);
    		$this->fpdf->Cell(10, 7, "Unit", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "Grade", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "GP", 1, 0, 'L', 1);
    		$this->fpdf->Cell(8, 7, "PE", 1, 0, 'L', 1);
    
    		$this->fpdf->Ln();
    		$this->fpdf->SetFont('times','',10);
    		
    		$this->response->setHeader('Content-Type','application/pdf');
		    $this->fpdf->Output();
		    
		}
	}

	// get semesters available
	function get_result($semester, $session)
	{
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		$id = $this->session->get('programme_id');
		$semester = urldecode($semester);
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$programme_id = $this->session->get('programme_id');
		$username = $this->session->get('username');
		$year_admitted = substr($username, 3, 2);
		$year_admitted = (int) "20".$year_admitted;
		$level = (int) substr($session, 0, 4) - $year_admitted + 100;
		
		$programme = $this->levelcoordinator_model->get_semester($programme_id, $session);
		
		
		//$submission = $this->levelcoordinator_model->get_student_registered_courses($programme_id, $semester, $session, 100);
		$submission = $this->levelcoordinator_model->get_submission_instance_result_($programme_id, $session, $semester, $level);
		
		$course = $this->levelcoordinator_model->get_submitted_result_semester($username, $semester, $session);
		$student = $this->levelcoordinator_model->get_registered_students($id, $level,$session);

		$submission_status = "false";
		$result_label = "<strong>The result cannot be compiled due to the following reasons:</strong> <br>";
		$yet_to_be = "";
		foreach($submission as $sub){
			$result_status = $this->levelcoordinator_model->get_submission_status($sub->course_id, $username, $session);
			if($result_status){	
				if($result_status['hod_status'] == 'Accepted'){
					$submission_status = true;
				}else{
				    $yet_to_be .= $sub->course_id.": Not Approved by the Department";
					
					$submission_status = false;
					$result_label .= $yet_to_be; 
				}			
			}else{
			    $yet_to_be .= $sub->course_id.'<br>';
				$submission_status = false;
				
				$result_label .= $yet_to_be.': Not Uploaded<br>';                
				break;
			}
		}

		foreach($student as $stud){
			foreach($course as $co){
				$mark = $this->levelcoordinator_model->get_student_marks($stud->profile_id, $co->id);
				$name = $co->course_id;
				if($mark){					
					$stud->$name = $mark['total_marks'];
				}else{
					$stud->$name = "";
				}
			}
		}
				
		$value = [];
		$output = "";
		$average_dialog = "";
		$raw_marks_dialog = "";
		$summary_dialog = "";
		
		
		//if($submission_status){
		    
		    if($semester == '1st'){

			foreach($student as $stud){
				$tcr = 0;
				$tce = 0;
				$tp = 0;
				$inc = 0; // to sum credit units of incomplete courses
				$carry_over = "";
				$remark = "";
				$abs = 'ABS in: ';
				$incomplte = 'INC in: ';
				//$tcr = $this->levelcoordinator_model->get_total_credits($stud->student_id)['total_credits'];
				
				foreach($course as $co){ 
					$mark = $this->levelcoordinator_model->get_student_marks($stud->registration_no, $co->id);
					$name = $co->course_id;

					$course_detail = $this->levelcoordinator_model->get_course_detail($name);
					
					if($mark){		
						//$tcr += $course_detail['credit_unit'];					
						if($mark['total_marks'] == 'ABS'){
							$tcr += $course_detail['credit_unit'];
							$tp += 0 * $course_detail['credit_unit'];
							$carry_over .= $name.", ";
							$remark .= $abs.$name.', ';
						}else if($mark['total_marks'] == "I"){
							$tcr += $course_detail['credit_unit'];
							$inc += $course_detail['credit_unit'];
							$remark .= "INC in: ".$name;
						}else if($mark['total_marks'] >= 40){
							$tcr += $course_detail['credit_unit'];
							$tce += $course_detail['credit_unit'];
							if($mark['grade'] == 'A'){
								$tp += 5 * $course_detail['credit_unit'];	
							}else if($mark['grade'] == 'B'){
								$tp += 4 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'C'){
								$tp += 3 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'D'){
								$tp += 2 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'E'){
								$tp += 1 * $course_detail['credit_unit'];
							}													
						}else if($mark['total_marks'] < 40){
							$tcr += $course_detail['credit_unit'];
							$tp += 0 * $course_detail['credit_unit'];
							$carry_over .= $name.", ";
						}
					}
					
				}
				$stud->tce = $tce;
				$stud->tcr = $tcr;
				// if student apply for imcomplete grading in all semester 
				if($tcr == $inc){
					$gpa = (double) $tp/1;
				}else{	
					$gpa = (double) $tp/($tcr - $inc); // subtract incomplete grading ( 0 if no incomplete grade)
				}
				$gpa = round($gpa, 2);
				$stud->gpa = strlen(strval($gpa)) == 1 ? $gpa.".00" : $gpa;
				//if($gpa < 1.00)
					//$remark .= "<br/>On Probarion";
				$stud->carry_over = $carry_over;
				$stud->remark = $remark;
			}

		}else if($semester == '2nd'){


			$overall_courses = $this->levelcoordinator_model->get_overall_courses($id, $this->session->get('username'));
		
			foreach($student as $stud){
				$tcr = 0;
				$tce = 0;
				$tp = 0;
				$inc = 0; // to sum credit units of incomplete courses
				$overall_inc = 0; // to sum credit units of incomplete courses

				$overall_tcr = 0;
				$overall_tce = 0;
				$overall_tp = 0;

				$carry_over = "";
				$remark = "";
				//$tcr = $this->levelcoordinator_model->get_total_credits($stud->student_id)['total_credits'];
				
				// Calculate Semester GPA
				$abs = 'ABS in: ';
				$incomplete = 'INC in: ';
				foreach($course as $co){ 
					$mark = $this->levelcoordinator_model->get_student_marks($stud->registration_no, $co->id);
					$name = $co->course_id;
					$course_detail = $this->levelcoordinator_model->get_course_detail($name);
					
					
					if($mark){		
						//$tcr += $course_detail['credit_unit'];				
						
						if($mark['total_marks'] == 'ABS'){
							$tcr += $course_detail['credit_unit'];
							$tp += 0 * $course_detail['credit_unit'];
							$carry_over .= $name.", ";
							$abs .= $abs.$name.',';
						}else if($mark['total_marks'] == "I"){
							$tcr += $course_detail['credit_unit'];
							$inc += $course_detail['credit_unit'];
						    $inc .= $incomplete.$name.',';
						}else if($mark['total_marks'] >= 40){
							$tcr += $course_detail['credit_unit'];
							$tce += $course_detail['credit_unit'];
							if($mark['grade'] == 'A'){
								$tp += 5 * $course_detail['credit_unit'];	
							}else if($mark['grade'] == 'B'){
								$tp += 4 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'C'){
								$tp += 3 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'D'){
								$tp += 2 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'E'){
								$tp += 1 * $course_detail['credit_unit'];
							}													
						}else if($mark['total_marks'] < 40){
							$tcr += $course_detail['credit_unit'];
							$tp += 0 * $course_detail['credit_unit'];
							$carry_over .= $name.", ";
						}
					}
					
				}
				// Calculate CGPA
				foreach($overall_courses as $co){ 
					$mark = $this->levelcoordinator_model->get_student_marks($stud->profile_id, $co->id);
					$name = $co->course_id;
					$course_detail = $this->levelcoordinator_model->get_course_detail($name);
					
					
					if($mark){		
						//$tcr += $course_detail['credit_unit'];					
						if($mark['total_marks'] == 'ABS'){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tp += 0 * $course_detail['credit_unit'];
							$carry_over .= $name.", ";
							$remark .= "ABS in: ".$name;
						}else if($mark['total_marks'] == "I"){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_inc += $course_detail['credit_unit'];
							$remark .= "INC in: ".$name;
						}else if($mark['total_marks'] >= 40){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tce += $course_detail['credit_unit'];
							if($mark['grade'] == 'A'){
								$overall_tp += 5 * $course_detail['credit_unit'];	
							}else if($mark['grade'] == 'B'){
								$overall_tp += 4 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'C'){
								$overall_tp += 3 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'D'){
								$overall_tp += 2 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'E'){
								$overall_tp += 1 * $course_detail['credit_unit'];
							}													
						}else if($mark['total_marks'] < 40){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tp += 0 * $course_detail['credit_unit'];
							//$carry_over .= $name.", ";
						}
					}
					
				}

				$stud->tce = $tce;
				$stud->tcr = $tcr;
				//gpa
				if($tcr == $inc){
					$gpa = (double) $tp/1;
				}else{	
					$gpa = (double) $tp/($tcr - $inc); // subtract incomplete grading ( 0 if no incomplete grade)
				}
				//cgpa
				if($tcr == $overall_inc){
					$cgpa = (double) $overall_tp/1;
				}else{	
					 // subtract incomplete grading ( 0 if no incomplete grade)
					$cgpa = (double) $overall_tp/($overall_tcr - $overall_inc);
				}
				$gpa = round($gpa, 2);
				$stud->gpa = strlen(strval($gpa)) == 1 ? $gpa.".00" : $gpa;
				//$stud->gpa = number_format($gpa, 2);
				$stud->cgpa = number_format($cgpa, 2);
				if($cgpa < 1.00){
					$remark .= "On Probation";
				}
					
				$stud->carry_over = $carry_over;
				$stud->remark = $remark;
			}
		}
		//<button type="submit" name = "mbbs_summary" value = "mbbs_summary" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> View Summary</button>
					
			if($programme_id == 72){
			    $output .= '<div class="row">
			    
			        <div class="col-4">
			        <button type="submit" name = "raw_marks" value = "raw_marks" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Raw Marks</button>
					</div>
			        <div class="col-4">
			        <button type="submit" name = "mbbs_summary" value = "mbbs_summary" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Summary</button>
					</div>
					<div class="col-4">
					
					<button type="submit" name = "summary" value = "summary" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Summary</button>
					</div>
				
				</div>';
			}else{
			    $output .= '<div class="row">
					<div class="col-4">
					<button  type="submit" name = "raw_marks" value = "raw_marks" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Raw Marks</button>
					</div>
					<div class="col-4">
					
					<button type="submit" name = "summary" value = "summary" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Summary</button>
					</div>
					<div class="col-4">
					
					<button type="submit" name = "score_sheet" value = "score_sheet" class="btn btn-primary btn-lg btn-block" ><span class="glyphicon glyphicon-cloud-download"></span> Download Score Sheet</button>
					</div>
					
				</div>';
			}
			

				$raw_marks_dialog .= '<div class="modal fade" id="raw_marks" >
							<div class="modal-dialog modal-xl">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"><span class="badge badge-info">&nbsp;</span> '.$this->session->get("programme_name").'<br/><span class="badge badge-info">&nbsp;</span> RAW MARKS</h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body table-responsive">
								<table id="example11" class="table table-bordered table-striped" width="100%">
								<thead>
								<tr>
									<th>S/N</th> 
									<th >Registration Number</th>
									<th >Full Name</th>
									';
									foreach($course as $co): 
										$raw_marks_dialog .= '<th><h6 class="word"><b>'.$co->course_id.'</b></h6></th>';
									endforeach;
									
									$raw_marks_dialog .= '</tr>
						</thead>
						<tbody>
								';
								$i = 1;
								foreach($student as $res){
									$raw_marks_dialog .= '<td>'.$i++.'</td>';
									$raw_marks_dialog .= '<td>'.$res->registration_no.'</td>';
									$raw_marks_dialog .= '<td>'.$res->first_name.' '.$res->middle_name.' '.$res->last_name.'</td>';
									foreach($course as $co){
										$course_id = $co->course_id;
										$raw_marks_dialog .= '<td>'.$res->$course_id.'</td>';
									}
									$raw_marks_dialog .= '</tr>';
								}
								
								$raw_marks_dialog .="
								</tbody>
								</table>
								<div class='modal-footer justify-content-between'>
								<button type='button' class='btn btn-default' data-dismiss='modal'>Close</button>
								</div>
								</div>
								</div>
								</div>
								</div>";

								$summary_dialog .= '<div class="modal fade" id="summary" >
							<div class="modal-dialog modal-xl">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"><span class="badge badge-info">&nbsp;</span> '.$this->session->get("programme_name").'<br/><span class="badge badge-info">&nbsp;</span> RESULT SUMMARY</h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body table-responsive">
								<table id="example12" class="table table-bordered table-striped" width="100%">
								<thead>
								<tr>
									<th>S/N</th> 
									<th >Registration Number</th>
									<th >Full Name</th>
									<th >TCR</th>
									<th >TCE</th>
									<th >GPA</th>';
									if($semester == '2nd'):
										$summary_dialog .= '<th >CGPA</th>';
									endif; 
									$summary_dialog .= '
									<th>Course(s) to carry over</th>
                                    <th>Remarks</th>
									</tr> 
									</thead>
									<tbody>';
								
									$i = 0;
									foreach($student as $res):
										$summary_dialog .= '<tr>';
										$summary_dialog .= '<td>'.++$i.'</td>';
										$summary_dialog .= '<td>'.$res->registration_no.'</td>';
										$summary_dialog .= '<td>'.$res->first_name.' '.$res->middle_name.' '.$res->last_name.'</td>';
										$summary_dialog .= '<td>'.$res->tcr.'</td>';
										$summary_dialog .= '<td>'.$res->tce.'</td>';
										$summary_dialog .= '<td>'.$res->gpa.'</td>';
										if($semester == '2nd'){
											$summary_dialog .= '<td>'.$res->cgpa.'</td>';
										}
										$summary_dialog .= '<td>'.$res->carry_over.'</td>';
										$summary_dialog .= '<td>'.$res->remark.'</td>';
									endforeach;
								$summary_dialog .="
								</tbody>
								</table>
								<div class='modal-footer justify-content-between'>
								<button type='button' class='btn btn-default' data-dismiss='modal'>Close</button>
								</div>
								</div>
								</div>
								</div>
								</div>";

								

		/*}else{
			$output .= '<div class="alert alert-warning alert-dismissible">
                  <h5><i class="icon fas fa-exclamation-triangle"></i> Alert!</h5>
                  '.$result_label.'
                </div>';
		}*/
					
		echo $output;
		echo $raw_marks_dialog;
		echo $summary_dialog;
	}
	
	public function download_result(){
	    
	    if(!session()->has('levelcoordinator_logged')){
			return redirect()->to(base_url()."/lev-login");	
		}

		if($this->request->getMethod() == 'post'){
		    
		    $id = $this->session->get('programme_id');
	        $session = $this->request->getVar("session");
	        $session = str_replace("_","/",$session);
		    $semester = $this->request->getVar("semester");
		    
		    $programme_id = $this->session->get('programme_id');
    		$username = $this->session->get('username');
    		$year_admitted = substr($username, 3, 2);
    		$year_admitted = (int) "20".$year_admitted;
    		$level = (int) substr($session, 0, 4) - $year_admitted + 100;
    		
    		$faculty = $this->session->get('faculty');
			$department = $this->session->get('department');
		    $programme_name = $this->levelcoordinator_model->get_programme_name($programme_id)['title'];
		    
		    $programme = $this->levelcoordinator_model->get_semester($programme_id, $session);
        		
        		$submission = $this->levelcoordinator_model->get_submission_instance_result_($programme_id, $session, $semester, $level);
        		
        		$course = $this->levelcoordinator_model->get_submitted_result_semester($username, $semester, $session);
        		$student = $this->levelcoordinator_model->get_registered_students($id, $level,$session);
        		
        		$num_courses = count($course) + 3;
		        $alpha = array('A','B','C','D','E','F','G','H','I','J','K', 'L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
		        
		        $highest_letter = $alpha[$num_courses-1];
		        //echo $highest_letter;
		        //exit();
        
        		$submission_status = "false";
        		$result_label = "";
        		foreach($submission as $sub){
        			$result_status = $this->levelcoordinator_model->get_submission_status($sub->course_id, $username, $session);
        			if($result_status){	
        				if($result_status['hod_status'] == 'Accepted'){
        					$submission_status = true;
        				}else{
        					$result_label = "One of the result is yet to be approved";
        					$submission_status = false;
        				}			
        			}else{
        				$submission_status = false;
        				$result_label = "Lecturers did not make full submission";
        				break;
        			}
        		}
        
        		foreach($student as $stud){
        			foreach($course as $co){
        				$mark = $this->levelcoordinator_model->get_student_marks($stud->registration_no, $co->id);
        				$name = $co->course_id;
        				if($mark){					
        					$stud->$name = $mark['total_marks'];
        				}else{
        					$stud->$name = "";
        				}
        			}
        		}
        		
        		//if($submission_status){
        		    
        		    
		    
		    if($semester == '1st'){
		        
		        
    			foreach($student as $stud){
    			    
    			    $absent_through = true;
    			    $abs_flag = false; //indicates absent for a course
    			    $absent_flag = false; //indicates absent throughouth the semester
                    $abs = 'ABS in: ';
                    $imcomplete = 'INC in: ';
    			    
    				$tcr = 0;
    				$tce = 0;
    				$tp = 0;
    				$inc = 0; // to sum credit units of incomplete courses
    				$carry_over = "";
    				$remark = "";
    				//$tcr = $this->levelcoordinator_model->get_total_credits($stud->student_id)['total_credits'];
    				
    				$num_course = 0;
    				foreach($course as $co){ 
    					$mark = $this->levelcoordinator_model->get_student_marks($stud->registration_no, $co->id);
    					$name = $co->course_id;
    
    					$course_detail = $this->levelcoordinator_model->get_course_detail($name);
    					
    					if($mark){		
    						//$tcr += $course_detail['credit_unit'];					
    						if($mark['total_marks'] == 'ABS'){
    						    $abs_flag = true;
    						    $absent_flag = true;
    						    
    							$tcr += $course_detail['credit_unit'];
    							$tp += 0 * $course_detail['credit_unit'];
    							$carry_over .= $name.", ";
    							$abs .= $name.', ';
    						}else if($mark['total_marks'] == "I"){
    							$tcr += $course_detail['credit_unit'];
    							$inc += $course_detail['credit_unit'];
    							$remark .= $incomplete.$name.', ';
    							$absent_flag = false;
    							$absent_through = false;
    						}else if($mark['total_marks'] >= 40){
    						    $absent_flag = false;
    						    $absent_through = false;
    							$tcr += $course_detail['credit_unit'];
    							$tce += $course_detail['credit_unit'];
    							if($mark['grade'] == 'A'){
    								$tp += 5 * $course_detail['credit_unit'];	
    							}else if($mark['grade'] == 'B'){
    								$tp += 4 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'C'){
    								$tp += 3 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'D'){
    								$tp += 2 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'E'){
    								$tp += 1 * $course_detail['credit_unit'];
    							}													
    						}else if($mark['total_marks'] < 40){
    						    $absent_through = false;
    						    $absent_flag = false;
    							$tcr += $course_detail['credit_unit'];
    							$tp += 0 * $course_detail['credit_unit'];
    							$carry_over .= $name.", ";
    						}
    					}
    					$num_course++;
    				}
    				if($abs_flag){
    				    	$remark = $abs;
    				}else{
    				    
    				}
    				$stud->tce = $tce;
    				$stud->tcr = $tcr;
    				// if student apply for imcomplete grading in all semester 
    				if($tcr == $inc){
    					$gpa = (double) $tp/1;
    				}else{	
    					$gpa = (double) $tp/($tcr - $inc); // subtract incomplete grading ( 0 if no incomplete grade)
    				}
        			$gpa = round($gpa, 2);
    				$stud->gpa = strlen(strval($gpa)) == 1 ? $gpa.".00" : $gpa;
    				//if($gpa < 1.00)
    					//$remark .= "<br/>On Probarion";
    				$stud->carry_over = $carry_over;
    				$stud->remark = $remark;
    				if($absent_through){
    				    $stud->absent = true;
    				}else{
    				   $stud->absent = false; 
    				}
    				
    			}

		}else if($semester == '2nd'){


			$overall_courses = $this->levelcoordinator_model->get_overall_courses($id, $this->session->get('username'));
		
			foreach($student as $stud){
			    
			    $absent_through = true;
			    $abs_flag = false; //indicates absent for a course
			    $absent_flag = false; //indicates absent throughouth the semester
                $abs = 'ABS in: ';
                $imcomplete = 'INC in: ';
                
				$tcr = 0;
				$tce = 0;
				$tp = 0;
				$inc = 0; // to sum credit units of incomplete courses
				$overall_inc = 0; // to sum credit units of incomplete courses

				$overall_tcr = 0;
				$overall_tce = 0;
				$overall_tp = 0;

				$carry_over = "";
				$remark = "";
				//$tcr = $this->levelcoordinator_model->get_total_credits($stud->student_id)['total_credits'];
				
				// Calculate Semester GPA
				foreach($course as $co){ 
					$mark = $this->levelcoordinator_model->get_student_marks($stud->registration_no, $co->id);
					$name = $co->course_id;
					$course_detail = $this->levelcoordinator_model->get_course_detail($name);
					
					
					if($mark){		
						//$tcr += $course_detail['credit_unit'];					
						if($mark['total_marks'] == 'ABS'){
    						    $abs_flag = true;
    						    $absent_flag = true;
    						    
    							$tcr += $course_detail['credit_unit'];
    							$tp += 0 * $course_detail['credit_unit'];
    							$carry_over .= $name.", ";
    							$abs .= $name.', ';
    						}else if($mark['total_marks'] == "I"){
    							$tcr += $course_detail['credit_unit'];
    							$inc += $course_detail['credit_unit'];
    							$remark .= $incomplete.$name.', ';
    							$absent_flag = false;
    							$absent_through = false;
    						}else if($mark['total_marks'] >= 40){
    						    $absent_flag = false;
    						    $absent_through = false;
    							$tcr += $course_detail['credit_unit'];
    							$tce += $course_detail['credit_unit'];
    							if($mark['grade'] == 'A'){
    								$tp += 5 * $course_detail['credit_unit'];	
    							}else if($mark['grade'] == 'B'){
    								$tp += 4 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'C'){
    								$tp += 3 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'D'){
    								$tp += 2 * $course_detail['credit_unit'];
    							}else if($mark['grade'] == 'E'){
    								$tp += 1 * $course_detail['credit_unit'];
    							}													
    						}else if($mark['total_marks'] < 40){
    						    $absent_through = false;
    						    $absent_flag = false;
    							$tcr += $course_detail['credit_unit'];
    							$tp += 0 * $course_detail['credit_unit'];
    							$carry_over .= $name.", ";
    						}
					}
					
				}
				// Calculate CGPA
				foreach($overall_courses as $co){ 
					$mark = $this->levelcoordinator_model->get_student_marks($stud->registration_no, $co->id);
					$name = $co->course_id;
					$course_detail = $this->levelcoordinator_model->get_course_detail($name);
					
					
					if($mark){		
						//$tcr += $course_detail['credit_unit'];					
						if($mark['total_marks'] == 'ABS'){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tp += 0 * $course_detail['credit_unit'];
							//$carry_over .= $name.", ";
							//$remark .= "ABS in: ".$name;
						}else if($mark['total_marks'] == "I"){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_inc += $course_detail['credit_unit'];
							//$remark .= "INC in: ".$name;
						}else if($mark['total_marks'] >= 40){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tce += $course_detail['credit_unit'];
							if($mark['grade'] == 'A'){
								$overall_tp += 5 * $course_detail['credit_unit'];	
							}else if($mark['grade'] == 'B'){
								$overall_tp += 4 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'C'){
								$overall_tp += 3 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'D'){
								$overall_tp += 2 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'E'){
								$overall_tp += 1 * $course_detail['credit_unit'];
							}													
						}else if($mark['total_marks'] < 40){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tp += 0 * $course_detail['credit_unit'];
							//$carry_over .= $name.", ";
						}
					}
					
				}
                
                if($abs_flag){
                    $remark .= $abs;
                }
				$stud->tce = $tce;
				$stud->tcr = $tcr;
				//gpa
				if($tcr == $inc){
					$gpa = (double) $tp/1;
				}else{	
					$gpa = (double) $tp/($tcr - $inc); // subtract incomplete grading ( 0 if no incomplete grade)
				}
				//cgpa
				if($tcr == $overall_inc){
					$cgpa = (double) $overall_tp/1;
				}else{	
					 // subtract incomplete grading ( 0 if no incomplete grade)
					$cgpa = (double) $overall_tp/($overall_tcr - $overall_inc);
				}
				$gpa = round($gpa, 2);
				$stud->gpa = strlen(strval($gpa)) == 1 ? $gpa.".00" : $gpa;
				$stud->cgpa = number_format($cgpa, 2);
				if($cgpa < 1.00){
					$remark .= "On Probation";
				}
					
				$stud->carry_over = $carry_over;
				$stud->remark = $remark;
				if($absent_through){
    				    $stud->absent = true;
    			}else{
    				   $stud->absent = false; 
    			}
			}
		}
		    
		if(isset($_POST['raw_marks'])){
		        
			
			$spreadsheet = new Spreadsheet();

			$row_counter = 12;
			//STYLING THE PAGE
			$spreadsheet->getActiveSheet()->setShowGridlines(true);
			$spreadsheet->getActiveSheet()->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd(13, 13);
			$spreadsheet->getActiveSheet()->getStyle('A13:G13')->getFill()
				->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
				->getStartColor()->setARGB('B2BEB5');
			$spreadsheet->getDefaultStyle()->getFont()->setSize(12);
			$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

			//$spreadsheet->getActiveSheet()->mergeCells('A18:E22');
			$spreadsheet->getActiveSheet()->getCell('A1')->setValue('YUSUF MAITAMA SULE UNIVERSITY, KANO');
			$spreadsheet->getActiveSheet()->mergeCells('A1:'.$highest_letter.'1');

			$spreadsheet->getActiveSheet()->getCell('A2')->setValue('FACULTY OF '.strtoupper($faculty));
			$spreadsheet->getActiveSheet()->mergeCells('A2:'.$highest_letter.'2');
			$spreadsheet->getActiveSheet()->mergeCells('A3:'.$highest_letter.'3');

			$spreadsheet->getActiveSheet()->getCell('A4')->setValue("DEPARTMENT OF ".strtoupper($department));
			$spreadsheet->getActiveSheet()->mergeCells('A4:'.$highest_letter.'4');
			$spreadsheet->getActiveSheet()->mergeCells('A5:'.$highest_letter.'5');

			$spreadsheet->getActiveSheet()->getCell('A6')->setValue('Submission to the Senate through SBC (Raw Marks)');
			$spreadsheet->getActiveSheet()->mergeCells('A6:'.$highest_letter.'6');
			$spreadsheet->getActiveSheet()->getCell('A7')->setValue(' ');
			$spreadsheet->getActiveSheet()->mergeCells('A7:'.$highest_letter.'7');

			$spreadsheet->getActiveSheet()->getCell('B8')->setValue('Session: '.$session);
			$spreadsheet->getActiveSheet()->getCell('E8')->setValue('Semester: '.$semester);
			
			$spreadsheet->getActiveSheet()->getCell('C8')->setValue('Programme: '.$programme_name);
			$spreadsheet->getActiveSheet()->mergeCells('C8:D8');
			$spreadsheet->getActiveSheet()->mergeCells('E8:G8');
			$spreadsheet->getActiveSheet()->getStyle('E8')
				->getAlignment()->setWrapText(true);
			$spreadsheet->getActiveSheet()->getCell('H8')->setValue('Level: '.$level);
			$spreadsheet->getActiveSheet()->mergeCells('H8:I8');
			$spreadsheet->getActiveSheet()->getCell('J8')->setValue('            Date: '.date("d/m/Y")); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('J8:'.$highest_letter.'8');
			
			// END OF STYLES

			$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooterDrawing();
			$drawing->setName('PhpSpreadsheet logo');
			$drawing->setPath('assets/img/yumsuk_logo.jpg');
			$drawing->setHeight(100);
			$drawing->setWidth(100);
			//$spreadsheet->getActiveSheet()->getHeaderFooter()->addImage($drawing, \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooter::IMAGE_HEADER_LEFT);
			$drawing->setCoordinates('A1');
			$drawing->setWorksheet($spreadsheet->getActiveSheet());
			//

			$worksheet = $spreadsheet->getActiveSheet(); 
			// set excel headers  

			$worksheet->getCell('A11')->setValue('S/No.');
			$worksheet->getCell('B11')->setValue('Registration No.');
			$worksheet->getCell('C11')->setValue('Name');
			
			$cell_counter = 3;
			foreach($course as $co){
			    $worksheet->getCell($alpha[$cell_counter].'11')->setValue($co->course_id);
			    
			    $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter].'')->setWidth('5');
			    $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter].'')->setAutoSize(false);
			    
			    $spreadsheet->getActiveSheet()->getStyle($alpha[$cell_counter].'11')
				->getAlignment()->setTextRotation(90);
				
				$cell_counter++;
			}
			
			$count = 1;
			
			foreach($student as $stud){
			    
			    $worksheet->getCell('A'.$row_counter)->setValue($count++);
				$worksheet->getCell('B'.$row_counter)->setValue($stud->registration_no);
				$worksheet->getCell('C'.$row_counter)->setValue($stud->middle_name." ".$stud->last_name." ".$stud->first_name);
				
				$cell_counter = 3;
				foreach($course as $co){
				    
					$course_id = $co->course_id;
					$mark = (($stud->$course_id < 10) && is_numeric($stud->$course_id)) ? "0".$stud->$course_id : $stud->$course_id;
					$worksheet->getCell($alpha[$cell_counter].$row_counter.'')->setValue($mark);
					
					$cell_counter++;
				}
				
				$row_counter++;
			}
			
			$counter = $row_counter + 3;
			$spreadsheet->getActiveSheet()->getCell('B'.$counter)->setValue('LEVEL COORDINATOR                        EXAMINATIONS OFFICER                   HEAD OF DEPARTMENT                                DEAN'); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('B'.$counter.':'.$highest_letter.$counter);
			
				//end of headers
				
				$row_counter = $row_counter - 1;

            $spreadsheet->getActiveSheet()->getStyle('B'.$row_counter.':'.$highest_letter.$row_counter)
            				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			
			$spreadsheet->getActiveSheet()->getStyle('A13:C'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
			$spreadsheet->getActiveSheet()->getStyle('D13:G'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
				// SET HEADERS TO CENTER
			$spreadsheet->getActiveSheet()->getStyle('A1:H6')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			$spreadsheet->getActiveSheet()->getStyle('A8:L8')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				
				//wrap
			//$spreadsheet->getActiveSheet()->getHighestRow()->getStyle('D8:G8') ->getAlignment()->setWrapText(true);
			
		    $spreadsheet->getActiveSheet()->getStyle('D8:G8')->getAlignment()->setWrapText(true); 
//sa
			/*$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'')    
				->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') 
					->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);*/
			//$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') ->getBorders()->getLeft()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			//$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') ->getBorders()->getRight()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'') 
					->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
			$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			
			
	//end
			$spreadsheet->getActiveSheet()->getStyle('A8:'.$highest_letter.'8')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
						// SET FONT BOLD
			$spreadsheet->getActiveSheet()->getStyle('A1:'.$highest_letter.'11')->getFont()->setBold(true);

					//END OF BORDER

				
			$writer = new Xlsx($spreadsheet);

			//header('Content-Type: Application/vnd.ms-excel');
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			//header('Content-Disposition: attachment; filename="hideMeTest5.xlsx"');
			header('Content-Disposition: attachment; filename= '.$programme_name.'_'.$session."_Result_Raw_Marks.xlsx");
			ob_end_clean();
			$writer->save('php://output');
			exit;

		}else if(isset($_POST['summary'])){
	    
			$spreadsheet = new Spreadsheet();

			$row_counter = 12;
			//STYLING THE PAGE
			$spreadsheet->getActiveSheet()->setShowGridlines(true);
			$spreadsheet->getActiveSheet()->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd(11, 11);
			$spreadsheet->getActiveSheet()->getStyle('A11:H11')->getFill()
				->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
				->getStartColor()->setARGB('B2BEB5');
			$spreadsheet->getDefaultStyle()->getFont()->setSize(12);
			$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('G')->setWidth(30);
			
			//$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

			//$spreadsheet->getActiveSheet()->mergeCells('A18:E22');
			$spreadsheet->getActiveSheet()->getCell('A1')->setValue('YUSUF MAITAMA SULE UNIVERSITY, KANO');
			$spreadsheet->getActiveSheet()->mergeCells('A1:H1');

			$spreadsheet->getActiveSheet()->getCell('A2')->setValue('FACULTY OF '.strtoupper($faculty));
			$spreadsheet->getActiveSheet()->mergeCells('A2:H2');
			$spreadsheet->getActiveSheet()->mergeCells('A3:H3');
            
			$spreadsheet->getActiveSheet()->getCell('A4')->setValue("DEPARTMENT OF ".strtoupper($department));
			$spreadsheet->getActiveSheet()->mergeCells('A4:H4');
			$spreadsheet->getActiveSheet()->mergeCells('A5:H5');

			$spreadsheet->getActiveSheet()->getCell('A6')->setValue('Submission to the Senate through SBC (Summary)');
			$spreadsheet->getActiveSheet()->mergeCells('A6:H6');
			$spreadsheet->getActiveSheet()->getCell('A7')->setValue(' ');
			$spreadsheet->getActiveSheet()->mergeCells('A7:H7');
            
			$spreadsheet->getActiveSheet()->getCell('A8')->setValue('Session: '.$session.'    Semester: '.$semester.'       Programme:    ' .$programme_name.'    Level: '.$level.'    Date:    '.date("d/m/Y"));
			$spreadsheet->getActiveSheet()->mergeCells('A8:H8');
			/*
			$spreadsheet->getActiveSheet()->getCell('E8')->setValue('Semester: '.$semester);
			
			$spreadsheet->getActiveSheet()->getCell('C8')->setValue('Programme: '.$programme_name);
			$spreadsheet->getActiveSheet()->mergeCells('C8:D8');
			$spreadsheet->getActiveSheet()->mergeCells('E8:G8');
			$spreadsheet->getActiveSheet()->getStyle('E8')
				->getAlignment()->setWrapText(true);
			$spreadsheet->getActiveSheet()->getCell('H8')->setValue('Level: '.$level);
			$spreadsheet->getActiveSheet()->mergeCells('H8:I8');
			$spreadsheet->getActiveSheet()->getCell('J8')->setValue('            Date: '.date("d/m/Y")); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('J8:'.$highest_letter.'8'); 
			*/
			// END OF STYLES

			$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooterDrawing();
			$drawing->setName('PhpSpreadsheet logo');
			$drawing->setPath('assets/img/yumsuk_logo.jpg');
			$drawing->setHeight(100);
			$drawing->setWidth(100);
			//$spreadsheet->getActiveSheet()->getHeaderFooter()->addImage($drawing, \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooter::IMAGE_HEADER_LEFT);
			$drawing->setCoordinates('A1');
			$drawing->setWorksheet($spreadsheet->getActiveSheet());
			//

			$worksheet = $spreadsheet->getActiveSheet(); 
			// set excel headers  

			$worksheet->getCell('A11')->setValue('S/No.');
			$worksheet->getCell('B11')->setValue('Registration No.');
			$worksheet->getCell('C11')->setValue('Name');
			$worksheet->getCell('D11')->setValue('TCR');
			$worksheet->getCell('E11')->setValue('TCE');
			$worksheet->getCell('F11')->setValue('GPA');
			if($semester == '2nd'){
			    $worksheet->getCell('G11')->setValue('CGPA');
			    $worksheet->getCell('H11')->setValue('Course(s) to Carry Over');
			    $worksheet->getCell('I11')->setValue('REMARK        ');
			    
			   
			}else{
			    $worksheet->getCell('G11')->setValue('Course(s) to Carry Over');
			    $worksheet->getCell('H11')->setValue('REMARK        ');
			    
			}
			
			$count = 1;
			
			foreach($student as $stud){
			    
			    $worksheet->getCell('A'.$row_counter)->setValue($count++);
				$worksheet->getCell('B'.$row_counter)->setValue($stud->registration_no);
				$worksheet->getCell('C'.$row_counter)->setValue($stud->middle_name." ".$stud->last_name." ".$stud->first_name);
				if($stud->tcr == 0){
				    $worksheet->getCell('D'.$row_counter)->setValue('DID NOT REGISTER FOR THE SESSION, RECOMMENDED FOR WITHDRAWAL');
				    $spreadsheet->getActiveSheet()->mergeCells('D'.$row_counter.':'.'H'.$row_counter);
				    
				}else{
				    $worksheet->getCell('D'.$row_counter)->setValue($stud->tcr);
				}
				;
				$worksheet->getCell('E'.$row_counter)->setValue($stud->tce);
				$worksheet->getCell('F'.$row_counter)->setValue(strlen(strval($stud->gpa)) == 1 ? $stud->gpa.".00" : $stud->gpa);
				
				if($semester == '1st'){
				   
				    $worksheet->getCell('G'.$row_counter)->setValue($stud->carry_over);
				    $spreadsheet->getActiveSheet()->getStyle('G'.$row_counter)->getAlignment()->setWrapText(true);
				   if($stud->absent){
				       $worksheet->getCell('H'.$row_counter)->setValue('ABSENT THROUGHOUT THE SEMESTER, RECOMMENDED FOR WITHDRAWAL');
				       $spreadsheet->getActiveSheet()->getStyle('H'.$row_counter)->getAlignment()->setWrapText(true);
				    }else{
				       $worksheet->getCell('H'.$row_counter)->setValue($stud->remark);
				       $spreadsheet->getActiveSheet()->getStyle('H'.$row_counter)->getAlignment()->setWrapText(true);
				    }
				}else{
				    $worksheet->getCell('G'.$row_counter)->setValue($stud->cgpa);
				    $worksheet->getCell('H'.$row_counter)->setValue($stud->carry_over);
				    if($stud->absent){
				       $worksheet->getCell('I'.$row_counter)->setValue('ABSENT THROUGHOUT THE SEMESTER, RECOMMENDED FOR WITHDRAWAL');
				       $spreadsheet->getActiveSheet()->getStyle('H'.$row_counter)->getAlignment()->setWrapText(true);
				    }else{
				       $worksheet->getCell('I'.$row_counter)->setValue($stud->remark);
				       $spreadsheet->getActiveSheet()->getStyle('H'.$row_counter)->getAlignment()->setWrapText(true);
				    }
				    $spreadsheet->getActiveSheet()->getStyle('I'.$row_counter)->getAlignment()->setWrapText(true);
				}
				
				$row_counter++;
			}
			
			
			
					
			if($semester == '1st'){
			    $counter = $row_counter + 3;
			$spreadsheet->getActiveSheet()->getCell('A'.$counter)->setValue('LEVEL COORDINATOR                        EXAMINATIONS OFFICER                   HEAD OF DEPARTMENT                                DEAN'); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('A'.$counter.':H'.$counter);
			
				//end of headers
				
				$row_counter = $row_counter - 1;

            $spreadsheet->getActiveSheet()->getStyle('B'.$row_counter.':H'.$row_counter)
            				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			
			$spreadsheet->getActiveSheet()->getStyle('A12:C'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
			$spreadsheet->getActiveSheet()->getStyle('D12:H'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				// SET HEADERS TO CENTER
			$spreadsheet->getActiveSheet()->getStyle('A1:H6')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			$spreadsheet->getActiveSheet()->getStyle('A8:L8')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				
				//wrap
			//$spreadsheet->getActiveSheet()->getHighestRow()->getStyle('D8:G8') ->getAlignment()->setWrapText(true);
			
		    
//sa
			$spreadsheet->getActiveSheet()->getStyle('A11:H11')    
				->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:H'.$row_counter) 
					->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:H'.$row_counter) ->getBorders()->getLeft()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:H'.$row_counter) ->getBorders()->getRight()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:H'.$row_counter) 
					->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
			$spreadsheet->getActiveSheet()->getStyle('A11:H'.$row_counter)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			
	//end
			$spreadsheet->getActiveSheet()->getStyle('A8:H8')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
						// SET FONT BOLD
			$spreadsheet->getActiveSheet()->getStyle('A1:H11')->getFont()->setBold(true);

					//END OF BORDER
			}else{
			    $counter = $row_counter + 3;
			$spreadsheet->getActiveSheet()->getCell('A'.$counter)->setValue('LEVEL COORDINATOR                        EXAMINATIONS OFFICER                   HEAD OF DEPARTMENT                                DEAN'); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('A'.$counter.':H'.$counter);
			
				//end of headers
				
				$row_counter = $row_counter - 1;

            $spreadsheet->getActiveSheet()->getStyle('B'.$row_counter.':H'.$row_counter)
            				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			
			$spreadsheet->getActiveSheet()->getStyle('A12:C'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
			$spreadsheet->getActiveSheet()->getStyle('D12:I'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				// SET HEADERS TO CENTER
			$spreadsheet->getActiveSheet()->getStyle('A1:I6')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			$spreadsheet->getActiveSheet()->getStyle('A8:K8')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				
				//wrap
			//$spreadsheet->getActiveSheet()->getHighestRow()->getStyle('D8:G8') ->getAlignment()->setWrapText(true);
			
		    
//sa
			$spreadsheet->getActiveSheet()->getStyle('A11:I11')    
				->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:I'.$row_counter) 
					->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:I'.$row_counter) ->getBorders()->getLeft()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:I'.$row_counter) ->getBorders()->getRight()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:I'.$row_counter) 
					->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
			$spreadsheet->getActiveSheet()->getStyle('A11:I'.$row_counter)->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			
	//end
			$spreadsheet->getActiveSheet()->getStyle('A8:I8')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
						// SET FONT BOLD
			$spreadsheet->getActiveSheet()->getStyle('A1:I11')->getFont()->setBold(true);

					//END OF BORDER
			}
				
			$writer = new Xlsx($spreadsheet);

			//header('Content-Type: Application/vnd.ms-excel');
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			//header('Content-Disposition: attachment; filename="hideMeTest5.xlsx"');
			header('Content-Disposition: attachment; filename= '.$programme_name.'_'.$session."_Result_Summary.xlsx");
			ob_end_clean();
			$writer->save('php://output');
			exit;

			}if(isset($_POST['mbbs_summary'])){
		       
		    $updated_alpha = array('A','B','C','D','E','F','G','H','I','J','K', 'L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
			
			$spreadsheet = new Spreadsheet();

			$row_counter = 12;
			//STYLING THE PAGE
			$spreadsheet->getActiveSheet()->setShowGridlines(true);
			$spreadsheet->getActiveSheet()->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd(13, 13);
			$spreadsheet->getActiveSheet()->getStyle('A13:G13')->getFill()
				->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
				->getStartColor()->setARGB('B2BEB5');
			$spreadsheet->getDefaultStyle()->getFont()->setSize(12);
			$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

			//$spreadsheet->getActiveSheet()->mergeCells('A18:E22');
			$spreadsheet->getActiveSheet()->getCell('A1')->setValue('YUSUF MAITAMA SULE UNIVERSITY, KANO');
			$spreadsheet->getActiveSheet()->mergeCells('A1:'.$highest_letter.'1');

			$spreadsheet->getActiveSheet()->getCell('A2')->setValue('FACULTY OF CLIICAL SCIENCES');
			$spreadsheet->getActiveSheet()->mergeCells('A2:'.$highest_letter.'2');
			$spreadsheet->getActiveSheet()->mergeCells('A3:'.$highest_letter.'3');

			$spreadsheet->getActiveSheet()->getCell('A4')->setValue("MBBS PROGRAMME");
			$spreadsheet->getActiveSheet()->mergeCells('A4:'.$highest_letter.'4');
			$spreadsheet->getActiveSheet()->mergeCells('A5:'.$highest_letter.'5');

			$spreadsheet->getActiveSheet()->getCell('A6')->setValue('Submission to the Senate through SBC (Raw Marks)');
			$spreadsheet->getActiveSheet()->mergeCells('A6:'.$highest_letter.'6');
			$spreadsheet->getActiveSheet()->getCell('A7')->setValue(' ');
			$spreadsheet->getActiveSheet()->mergeCells('A7:'.$highest_letter.'7');

			$spreadsheet->getActiveSheet()->getCell('B8')->setValue('Session: '.$session);
			$spreadsheet->getActiveSheet()->getCell('E8')->setValue('Semester: '.$semester);
			
			$spreadsheet->getActiveSheet()->getCell('C8')->setValue('Programme: '.$programme_name);
			$spreadsheet->getActiveSheet()->mergeCells('C8:D8');
			$spreadsheet->getActiveSheet()->mergeCells('E8:G8');
			$spreadsheet->getActiveSheet()->getStyle('E8')
				->getAlignment()->setWrapText(true);
			$spreadsheet->getActiveSheet()->getCell('H8')->setValue('Level: '.$level);
			$spreadsheet->getActiveSheet()->mergeCells('H8:I8');
			$spreadsheet->getActiveSheet()->getCell('J8')->setValue('            Date: '.date("d/m/Y")); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('J8:'.$highest_letter.'8');
			
			// END OF STYLES

			$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooterDrawing();
			$drawing->setName('PhpSpreadsheet logo');
			$drawing->setPath('assets/img/yumsuk_logo.jpg');
			$drawing->setHeight(100);
			$drawing->setWidth(100);
			//$spreadsheet->getActiveSheet()->getHeaderFooter()->addImage($drawing, \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooter::IMAGE_HEADER_LEFT);
			$drawing->setCoordinates('A1');
			$drawing->setWorksheet($spreadsheet->getActiveSheet());
			//

			$worksheet = $spreadsheet->getActiveSheet(); 
			// set excel headers  

			$worksheet->getCell('A11')->setValue('S/No.');
			$worksheet->getCell('B11')->setValue('Registration No.');
			$worksheet->getCell('C11')->setValue('Name');
			
			$cell_counter = 3;
			
			$mmbs_course = $this->levelcoordinator_model->get_mbbs_submitted_result_semester($username, $semester, $session);
			
			$mbbs_distint = count($mmbs_course) + 3;
			$mbbs_lowest_letter = $alpha[$mbbs_distint];
			$mbbs_highest_letter = $alpha[$mbbs_distint+3];
			
			//$remark_label = $alpha[count($mbbs_distint)];
			
			foreach($mmbs_course as $co){
			    
			    //$abv_res = $this->levelcoordinator_model->get_mbbs_submitted_result_semester($username, $semester, $session);
			    if($co->dept_id == 0){
			        $worksheet->getCell($alpha[$cell_counter].'11')->setValue("GSP");
			    }else{
			        $worksheet->getCell($alpha[$cell_counter].'11')->setValue($this->levelcoordinator_model->get_department_details($co->dept_id)['title']);
			    }
			    
			    
			    $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter].'')->setWidth('5');
			    $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter].'')->setAutoSize(false);
			    
			    $spreadsheet->getActiveSheet()->getStyle($alpha[$cell_counter].'11')
				->getAlignment()->setTextRotation(90);
				
				$cell_counter++;
			}
			
			$worksheet->getCell($mbbs_lowest_letter.'11')->setValue('Remarks');
			$spreadsheet->getActiveSheet()->mergeCells($mbbs_lowest_letter.'11:'.$mbbs_highest_letter.'11');
			
			$count = 1;
			
			foreach($student as $stud){
			    
			    $worksheet->getCell('A'.$row_counter)->setValue($count++);
				$worksheet->getCell('B'.$row_counter)->setValue($stud->registration_no);
				$worksheet->getCell('C'.$row_counter)->setValue($stud->middle_name." ".$stud->last_name." ".$stud->first_name);
				
				$cell_counter = 3;
				
				foreach($mmbs_course as $co){
				    $result = 0;
				    $c = 1;
					$abv_res = $this->levelcoordinator_model->get_mbbs_submitted_result_semester_($co->dept_id, $username, $semester, $session);
					
					foreach($abv_res as $ab){
					    $result += (int) $this->levelcoordinator_model->get_mbbs_marks($ab->id, $stud->registration_no)['total_marks'];
					    $c = $c + 1;
					}
					
					$worksheet->getCell($alpha[$cell_counter].$row_counter.'')->setValue(ceil($result/$c));
					$spreadsheet->getActiveSheet()->mergeCells($mbbs_lowest_letter.$row_counter.':'.$mbbs_highest_letter.$row_counter);
					
					$cell_counter++;
				}
				
				$row_counter++;
			}
			
			$counter = $row_counter + 3;
			$spreadsheet->getActiveSheet()->getCell('B'.$counter)->setValue('LEVEL COORDINATOR                        EXAMINATIONS OFFICER                   HEAD OF DEPARTMENT                                DEAN'); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('B'.$counter.':'.$highest_letter.$counter);
			
				//end of headers
				
				$row_counter = $row_counter - 1;

            $spreadsheet->getActiveSheet()->getStyle('B'.$row_counter.':'.$highest_letter.$row_counter)
            				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			
			$spreadsheet->getActiveSheet()->getStyle('A13:C'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
			$spreadsheet->getActiveSheet()->getStyle('D13:G'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
				// SET HEADERS TO CENTER
			$spreadsheet->getActiveSheet()->getStyle('A1:H6')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			$spreadsheet->getActiveSheet()->getStyle('A8:L8')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				
				//wrap
			//$spreadsheet->getActiveSheet()->getHighestRow()->getStyle('D8:G8') ->getAlignment()->setWrapText(true);
			
		    $spreadsheet->getActiveSheet()->getStyle('D8:G8')->getAlignment()->setWrapText(true); 
//sa
			/*$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'')    
				->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') 
					->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);*/
			//$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') ->getBorders()->getLeft()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			//$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') ->getBorders()->getRight()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:'.$mbbs_highest_letter.$row_counter.'') 
					->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
			$spreadsheet->getActiveSheet()->getStyle('A11:'.$mbbs_highest_letter.$row_counter.'')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			
			
	//end
			$spreadsheet->getActiveSheet()->getStyle('A8:'.$mbbs_highest_letter.'8')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
						// SET FONT BOLD
			$spreadsheet->getActiveSheet()->getStyle('A1:'.$highest_letter.'11')->getFont()->setBold(true);

					//END OF BORDER

				
			$writer = new Xlsx($spreadsheet);

			//header('Content-Type: Application/vnd.ms-excel');
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			//header('Content-Disposition: attachment; filename="hideMeTest5.xlsx"');
			header('Content-Disposition: attachment; filename= '.$programme_name.'_'.$session."_Result_Summary.xlsx");
			ob_end_clean();
			$writer->save('php://output');
			exit;
//end of 
		}else if(isset($_POST['score_sheet'])){
		        
			
			$spreadsheet = new Spreadsheet();

			$row_counter = 12;
			//STYLING THE PAGE
			$spreadsheet->getActiveSheet()->setShowGridlines(true);
			$spreadsheet->getActiveSheet()->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd(13, 13);
			$spreadsheet->getActiveSheet()->getStyle('A13:G13')->getFill()
				->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
				->getStartColor()->setARGB('B2BEB5');
			$spreadsheet->getDefaultStyle()->getFont()->setSize(12);
			$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
			$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
			//$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

			//$spreadsheet->getActiveSheet()->mergeCells('A18:E22');
			$spreadsheet->getActiveSheet()->getCell('A1')->setValue('YUSUF MAITAMA SULE UNIVERSITY, KANO');
			$spreadsheet->getActiveSheet()->mergeCells('A1:'.$highest_letter.'1');

			$spreadsheet->getActiveSheet()->getCell('A2')->setValue('FACULTY OF '.strtoupper($faculty));
			$spreadsheet->getActiveSheet()->mergeCells('A2:'.$highest_letter.'2');
			$spreadsheet->getActiveSheet()->mergeCells('A3:'.$highest_letter.'3');

			$spreadsheet->getActiveSheet()->getCell('A4')->setValue("DEPARTMENT OF ".strtoupper($department));
			$spreadsheet->getActiveSheet()->mergeCells('A4:'.$highest_letter.'4');
			$spreadsheet->getActiveSheet()->mergeCells('A5:'.$highest_letter.'5');

			$spreadsheet->getActiveSheet()->getCell('A6')->setValue('EXAMINATION SCORE SHEET');
			$spreadsheet->getActiveSheet()->mergeCells('A6:'.$highest_letter.'6');
			$spreadsheet->getActiveSheet()->getCell('A7')->setValue(' ');
			$spreadsheet->getActiveSheet()->mergeCells('A7:'.$highest_letter.'7');

			$spreadsheet->getActiveSheet()->getCell('B8')->setValue('Session: '.$session);
			$spreadsheet->getActiveSheet()->getCell('E8')->setValue('Semester: '.$semester);
			
			$spreadsheet->getActiveSheet()->getCell('C8')->setValue('Programme: '.$programme_name);
			$spreadsheet->getActiveSheet()->mergeCells('C8:D8');
			$spreadsheet->getActiveSheet()->mergeCells('E8:G8');
			$spreadsheet->getActiveSheet()->getStyle('E8')
				->getAlignment()->setWrapText(true);
			$spreadsheet->getActiveSheet()->getCell('H8')->setValue('Level: '.$level);
			$spreadsheet->getActiveSheet()->mergeCells('H8:I8');
			$spreadsheet->getActiveSheet()->getCell('J8')->setValue('            Date: '.date("d/m/Y")); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('J8:'.$highest_letter.'8');
			
			// END OF STYLES

			$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooterDrawing();
			$drawing->setName('PhpSpreadsheet logo');
			$drawing->setPath('assets/img/yumsuk_logo.jpg');
			$drawing->setHeight(100);
			$drawing->setWidth(100);
			//$spreadsheet->getActiveSheet()->getHeaderFooter()->addImage($drawing, \PhpOffice\PhpSpreadsheet\Worksheet\HeaderFooter::IMAGE_HEADER_LEFT);
			$drawing->setCoordinates('A1');
			$drawing->setWorksheet($spreadsheet->getActiveSheet());
			//

			$worksheet = $spreadsheet->getActiveSheet(); 
			// set excel headers  

			$worksheet->getCell('A11')->setValue('S/No.');
			$worksheet->getCell('B11')->setValue('Registration No.');
			$worksheet->getCell('C11')->setValue('Name');
			
			$cell_counter = 3;
			foreach($course as $co){
			    $worksheet->getCell($alpha[$cell_counter].'11')->setValue($co->course_id);
			    
			    $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter].'')->setWidth('5');
			    $spreadsheet->getActiveSheet()->getColumnDimension($alpha[$cell_counter].'')->setAutoSize(false);
			    
			    $spreadsheet->getActiveSheet()->getStyle($alpha[$cell_counter].'11')
				->getAlignment()->setTextRotation(90);
				
				$cell_counter++;
			}
			
			$count = 1;
			
			foreach($student as $stud){
			    
			    $worksheet->getCell('A'.$row_counter)->setValue($count++);
				$worksheet->getCell('B'.$row_counter)->setValue($stud->registration_no);
				$worksheet->getCell('C'.$row_counter)->setValue($stud->middle_name." ".$stud->last_name." ".$stud->first_name);
				
				$cell_counter = 3;
				foreach($course as $co){
				    
					$course_id = $co->course_id;
					$mark = (($stud->$course_id < 10) && is_numeric($stud->$course_id)) ? "0".$stud->$course_id : $stud->$course_id;
					$worksheet->getCell($alpha[$cell_counter].$row_counter.'')->setValue($mark);
					
					$cell_counter++;
				}
				
				$row_counter++;
			}
			
			$counter = $row_counter + 3;
			$spreadsheet->getActiveSheet()->getCell('B'.$counter)->setValue('LEVEL COORDINATOR                        EXAMINATIONS OFFICER                   HEAD OF DEPARTMENT                                DEAN'); // Date Downloaded
			$spreadsheet->getActiveSheet()->mergeCells('B'.$counter.':'.$highest_letter.$counter);
			
				//end of headers
				
				$row_counter = $row_counter - 1;

            $spreadsheet->getActiveSheet()->getStyle('B'.$row_counter.':'.$highest_letter.$row_counter)
            				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			
			$spreadsheet->getActiveSheet()->getStyle('A13:C'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
			$spreadsheet->getActiveSheet()->getStyle('D13:G'.$row_counter.'')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
				// SET HEADERS TO CENTER
			$spreadsheet->getActiveSheet()->getStyle('A1:H6')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
			$spreadsheet->getActiveSheet()->getStyle('A8:L8')
				->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT);
				
				//wrap
			//$spreadsheet->getActiveSheet()->getHighestRow()->getStyle('D8:G8') ->getAlignment()->setWrapText(true);
			
		    $spreadsheet->getActiveSheet()->getStyle('D8:G8')->getAlignment()->setWrapText(true); 
//sa
			/*$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'')    
				->getBorders()->getTop()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') 
					->getBorders()->getBottom()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);*/
			//$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') ->getBorders()->getLeft()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			//$spreadsheet->getActiveSheet()->getStyle('A11:G'.$highest_letter.$row_counter.'') ->getBorders()->getRight()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'') 
					->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID);
			$spreadsheet->getActiveSheet()->getStyle('A11:'.$highest_letter.$row_counter.'')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
			
			
	//end
			$spreadsheet->getActiveSheet()->getStyle('A8:'.$highest_letter.'8')->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);
						// SET FONT BOLD
			$spreadsheet->getActiveSheet()->getStyle('A1:'.$highest_letter.'11')->getFont()->setBold(true);

					//END OF BORDER

				
			$writer = new Xlsx($spreadsheet);

			//header('Content-Type: Application/vnd.ms-excel');
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			//header('Content-Disposition: attachment; filename="hideMeTest5.xlsx"');
			header('Content-Disposition: attachment; filename= '.$programme_name.'_'.$session."_Result_Raw_Marks.xlsx");
			ob_end_clean();
			$writer->save('php://output');
			exit;

		}
        		
	//}
		}

	}
		
}
