<!DOCTYPE html>
<html lang="en">
<head>
<?php $page_session = \Config\Services::session(); ?>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?= base_url("/../assets/img/nwu_logo.jpeg");?>" type="image/x-icon">
  <title>Exam Officer | <?= $page_title ?> | <?= $page_subtitle ?></title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/fontawesome-free/css/all.min.css"); ?>">
  <!-- daterange picker -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/daterangepicker/daterangepicker.css");?>">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?= base_url("/.../assets_/plugins/icheck-bootstrap/icheck-bootstrap.min.css")?>">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css")?>">
  <!-- Toastr -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/toastr/toastr.min.css")?>">
  <!-- Sweet Alert -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/sweetalert2/sweetalert2.min.css")?>">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css")?>">
  <!-- Select2 -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/select2/css/select2.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css")?>">
  <!-- Bootstrap4 Duallistbox -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css")?>">
  <!-- BS Stepper -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bs-stepper/css/bs-stepper.min.css")?>">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/dropzone/min/dropzone.min.css")?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/dist/css/adminlte.min.css")?>">

  <!-- DataTables -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-responsive/css/responsive.bootstrap4.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-buttons/css/buttons.bootstrap4.min.css")?>">

  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/icheck-bootstrap/icheck-bootstrap.min.css")?>">
  <style type="text/css">
		.loader-div {
			display: none;
			position: fixed;
			margin: 0px;
			padding: 0px;
			right: 0px;
			top: 0px;
			width: 100%;
			height: 100%;
			background-color: #fff;
			z-index: 30001;
			opacity: 0.8;
		}
		.loader-img {
			position: absolute;
			top: 0;
			bottom: 0;
			left: 0;
			right: 0;
			margin: auto;
		}
	</style>
</head>
<body class="hold-transition sidebar-mini text-sm" >
    <div class="loader-div">
    <img class="loader-img" src="<?= base_url("/../assets/img/ajax-loader.gif")?>" style="height: 120px;width: auto;" />
</div>
<div class="wrapper">
  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?= base_url(); ?>/exam-index" class="nav-link">Home</a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?= base_url(); ?>/exam-logout" class="nav-link">Logout</a>
      </li>
     
    </ul>

    <!-- Right navbar links -->
   <ul class="navbar-nav ml-auto">

      <li class="nav-item dropdown user-menu">
        <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
          <img src="<?= base_url("/../assets/img/avatar.png")?>" class="user-image img-circle elevation-2" alt="User Image">
          <span class="d-none d-md-inline"><?= $page_session->get('name'); ?></span>
        </a>
        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
          <!-- User image -->
          <li class="user-header bg-primary">
            <img src="<?= base_url("/../assets/img/avatar.png")?>" class="img-circle elevation-2" alt="User Image">
            <p>
              <?= $page_session->get('name'); ?>
              <small>Examinations Officer</small>
              <small><?= $page_session->get('id'); ?></small>
            </p>
          </li>
          <!-- Menu Footer-->
          <li class="user-footer">
            <a href="#" class="btn btn-default btn-flat">Profile</a>
            <a href="<?= base_url()?>/exam-logout" class="btn btn-default btn-flat float-right">logout</a>
          </li>
        </ul>
      </li>
    </ul>
  </nav>
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?= base_url()?>/examofficer/dashboard" class="brand-link">
      <img src="<?= base_url()?>/assets_/img/nwu_logo.jpg" alt="RPS Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
      <span class="brand-text font-weight-light">NWU RPS</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
      <!-- Sidebar user (optional) -->
      <div class="user-panel mt-3 pb-3 mb-3 d-flex text-center">
        
        <div class="info">
          <a href="#" class="d-block">Examinations Officer</a>
        </div>
      </div>
      <div class="user-panel mb-3 d-flex" style="background-color: #000000;">
        <div class="info">
          <a href="javascript:void(0);"><?php echo "Current Session: ".$page_session->get('current_session'); ?></a>
          <br/>
        </div>
      </div>


      <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
         
		  <li class="nav-item">
            <a href="<?= base_url(); ?>/exam-index" class="nav-link <?php echo ($page_title=='Dashboard')?'active':'' ?>">
              <i class="nav-icon fas fa-tachometer-alt"></i>
              <p>
                Dashboard
                </p>
            </a>
          </li>
          
          <li class="nav-item <?php echo ($page_title=='Exam Results')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='Exam Results')?'active':'' ?>">
              <i class="nav-icon fas fa-chart-bar"></i>
              <p>
              Exam Results
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url(); ?>/exam-submissions" class="nav-link <?php echo ($page_subtitle=='Lecturers Submission')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>View Submissions</p>
                </a>
              </li>
              <!-- <li class="nav-item">
                <a href="#" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Results</p>
                </a>
              </li> -->
              
              
            </ul>
          </li>
 
          <li class="nav-item <?php echo ($page_title=='Settings')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='Settings')?'active':'' ?>">
              <i class="nav-icon fas fa-cog"></i>
              <p>
                Settings
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url(); ?>/exam-password" class="nav-link <?php echo ($page_subtitle=='Change Password')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Change Password</p>
                </a>
              </li>
              
            </ul>
          </li>

          <li class="nav-item">
            <a href="<?= base_url(); ?>/exam-logout" class="nav-link">
              <i class="nav-icon fas fa-sign-out-alt"></i>
              <p>
                Logout
                </p>
            </a>
          </li>
          
        </ul>
      </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside>

  <?= $this->renderSection("content"); ?>
              
            <!-- /.card -->
          </div>
        </div>
        <!-- /.row -->
        
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="float-right d-none d-sm-block">
        Powered by the Directorate of ICT and Department of Computer Science.
        &nbsp; &nbsp; &nbsp; &nbsp; 
        <b>Version</b> 1.0
    </div>
    Copyright &copy; <?= "2022-".date("Y") ?> <a href="http://www.yumsuk.edu.ng">Northwest University Kano</a>. All rights
    reserved.
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="<?= base_url("/../assets_/plugins/jquery/jquery.min.js");?>"></script>
<!-- Bootstrap 4 -->
<script src="<?= base_url("/../assets_/plugins/bootstrap/js/bootstrap.bundle.min.js");?>"></script>
<!-- Select2 -->
<script src="<?= base_url("/../assets_/plugins/select2/js/select2.full.min.js");?>"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="<?= base_url("/../assets_/plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js");?>"></script>
<!-- Toastr -->
<script src="<?= base_url("/../assets_/plugins/toastr/toastr.min.js")?>"></script>
<!-- Sweet Alert -->
<script src="<?= base_url("/../assets_/plugins/sweetalert2/sweetalert2.min.js")?>"></script>
<!-- InputMask -->
<script src="<?= base_url("/../assets_/plugins/moment/moment.min.js")?>"></script>
<script src="<?= base_url("/../assets_/plugins/inputmask/jquery.inputmask.min.js");?>"></script>
<!-- date-range-picker -->
<script src="<?= base_url("../assets_/plugins/daterangepicker/daterangepicker.js");?>"></script>
<!-- bootstrap color picker -->
<script src="<?= base_url("/../assets_/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js");?>"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="<?= base_url("/../assets_/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js");?>"></script>
<!-- Bootstrap Switch -->
<script src="<?= base_url("/../assets_/plugins/bootstrap-switch/js/bootstrap-switch.min.js");?>"></script>
<!-- BS-Stepper -->
<script src="<?= base_url("/../assets_/plugins/bs-stepper/js/bs-stepper.min.js");?>"></script>
<!-- dropzonejs -->
<script src="<?= base_url("/../assets_/plugins/dropzone/min/dropzone.min.js");?>"></script>
<!-- AdminLTE App -->
<script src="<?= base_url("/../assets_/dist/js/adminlte.min.js");?>"></script>
<!-- AdminLTE for demo purposes -->
<script src="<?= base_url("/../assets_/dist/js/demo.js");?>"></script>
<!-- jquery-validation -->
<script src="<?= base_url("/../assets_/plugins/jquery-validation/jquery.validate.min.js");?>"></script>
<script src="<?= base_url("/../assets_/plugins/jquery-validation/additional-methods.min.js");?>"></script>
<!-- Page specific script -->

<!-- DataTables  & Plugins -->
<script src="<?= base_url("/../assets_/plugins/datatables/jquery.dataTables.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-responsive/js/dataTables.responsive.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/dataTables.buttons.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/jszip/jszip.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/pdfmake/pdfmake.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/pdfmake/vfs_fonts.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.html5.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.print.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.colVis.min.js"); ?>"></script>

  <!-- Custom scripts for all pages-->
<script src="<?= base_url("/../assets/js/sb-admin-2.min.js"); ?>"></script>


<script type="text/javascript">
   jQuery(document).ready(function() {
        <?php if($page_subtitle=='Compute Result'){?> 
            spawn_semester(); 
        <?php } 
         if($page_subtitle=='Lecturers Submission'){?> 
            spawn_semester_submission(); 
        <?php }
         if($page_subtitle=='Course Registrations'){?> 
            spawn_course_registrations(); 
        <?php }
         if($page_subtitle=='Download Template'){?> 
            spawn_allocated_courses(); 
        <?php }
         if($page_subtitle=='Upload Result'){?> 
            spawn_allocated_courses_upload(); 
        <?php } 
        if ($page_subtitle=='Course Enrollments'){?> 
            spawn_programmes_allocated(); 
        <?php } ?>
        
       
       //spawn_allocated_courses_enrollment();
       //alert('hh');
   });
</script>

<script>
  $(function () {
    //Initialize Select2 Elements
    $('.select2').select2();

    var example1_tbl = $("#example1").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $('#modal-table').DataTable({
                             dom: 'Bfrtip',
                             buttons: ['copy','csv','excel','pdf','print']
    });
    $('#mycourse_tbl1').DataTable({
                             dom: 'Bfrtip',
                             buttons: ['copy','csv','excel','pdf','print']
    });
  });

  $(document).on('click', '.view_students', function(){
    var my_id = $(this).data('id');
    var data =  {my_id : my_id,};
            /*$('#std').text(my_id);
            $('#studentsModal').modal('show');*/

    $.ajax({
        type: "POST",
        url: "<?php echo base_url('levelcoordinator/get_students_biodata') ?>",
        data: data,
        dataType: "json",
        success: function(obj) {
            $('#data').html(obj);
            $('#modal_title').text('List of students reistered for the course');
            $('#studentsModal').modal('show');
        },
    });
  });
</script>

<script>
    function spawn_programmes_allocated(){
        $(".loader-div").show(); // show loader
        var session = document.getElementById('sessionField').value;
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('programmeField').innerHTML = this.responseText
          $(".loader-div").hide(); // show loader
          //document.getElementById('allocatedProgrammeField').innerHTML = "";
          document.getElementById('txtHintDeptStudents').innerHTML = "";
        }
      
        xhttp.open("GET","<?= base_url('examofficer/get_programme_available/') ?>/"+session+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_course_enrollments(){
        //var programme = $('#progammes').val();
        //$(".loader-div").show(); // show loader
        var session = document.getElementById('sessionField').value;
        var programme = document.getElementById('programmeField').value; 
        //alert(session);
           	
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                            document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                            $(".loader-div").hide(); // hide loader     
                         //stuff for data table     
                         $("#example1").DataTable({
                          "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                          "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                        $('#example2').DataTable({
                          "paging": true,
                          "lengthChange": false,
                          "searching": false,
                          "ordering": true,
                          "info": true,
                          "autoWidth": false,
                          "responsive": true,
                        }); 
                         $(".table1").DataTable({
                          dom: 'Bfrtip',
                          "responsive": false, "lengthChange": false, "autoWidth": true, "searching": false,
                          "buttons": ["csv", "excel", "pdf", "print"]
                        }); 
         
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('examofficer/get_course_enrollments') ?>/"+session+"/"+programme+"/"+"\"",true);
                     xmlhttp.send();
      }

    </script>


<script>
    function spawn_lecturers_submission(){
        $(".loader-div").show(); // show loader
        var session = $('#session').val();
        var programme = $('#programme').val();
        var semester = document.getElementById('semester').value; 
        //alert(session + "...." + programme + "...." + semester);    
        if(session!=null && programme!=null && semester!=null){
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                            $(".loader-div").hide(); // show loader     
                         //stuff for data table     
                        $("#example1").DataTable({
                            "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                            $('#example2').DataTable({
                              "paging": true,
                              "lengthChange": false,
                              "searching": false,
                              "ordering": true,
                              "info": true,
                              "autoWidth": false,
                              "responsive": true,
                            }); 
                        $(".table1").DataTable({
                          dom: 'Bfrtip',
                          "responsive": false, "lengthChange": false, "autoWidth": true, "searching": false,
                          "buttons": ["csv", "excel", "pdf", "print"]
                        });  
         
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('examofficer/get_lecturers_submission/') ?>/"+session+"/"+programme+"/"+semester+"/"+"\"",true);
                     xmlhttp.send();
        }else{
          toastr.error('Please select all fields');
        }
      } 

    $(document).on('click', '.accept_button', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, accept it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('examofficer/submission_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'accept'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Accepted!', data.success, 'success');
                location.reload();
              }
            }
          })
        }
        return false;
      })
    });

    $(document).on('click', '.reject_button', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, reject it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('examofficer/submission_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'reject'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Rejected!', data.success, 'success');
                location.reload();
              }
            }
          })
        }
        return false;
      })
    });
      
    $('#pwd_form').on('submit', function(event){
      event.preventDefault();
      var pass1 = $('#pass1').val();
      var pass2 = $('#pass2').val();
      
      if($('#pass1').val() != $('#pass2').val()){
        toastr.error("Password does not match");
      }else{
          $.ajax({
            url: "<?php echo base_url('examofficer/password') ?>",
            method: "POST",
            data: $(this).serialize(),
            dataType: 'json',
            beforeSend:function(){
              $('#submit_button').attr('disabled', 'disabled');
              $('#submit_button').val('Please wait...');
            },
            success:function(data){
              $('#submit_button').attr('disabled', false);
              if(data.error != ''){
                toastr.error(data.error);
                $('#submit_button').val('Submit');
              }else{
                toastr.success(data.success);
                $('#pass1').val('');
                $('#pass2').val('');
                $('#submit_button').val('Submit');
              }
            }
          })
      }
    });
    </script>
