<?php
require(APPPATH .'plugins/fpdf.php');

class PDF extends FPDF
{
	function Header()
	{
		// Logoi
		$this->Image(base_url('assets/img/border51.png'),  0, 0, 211, 295);

		$this->SetAlpha(0.1);

		if($_SESSION['current_school_applied'] == "School of Basic Midwifery, Kano" || $_SESSION['current_school_applied'] == "School of Basic Midwifery, Dambatta" || $_SESSION['current_school_applied'] == "School of Basic Midwifery, Gwarzo" || $_SESSION['current_school_applied'] == "School of Nursing, Kano" || $_SESSION['current_school_applied'] == "School of Nursing, Madobi" || $_SESSION['current_school_applied'] == "School of Post Basic Nursing Anaesthesia" || $_SESSION['current_school_applied'] == "School of Post Basic Midwifery, Gezawa"){
			$this->Image(base_url('assets/img/nursing.jpg'), 30, 50, 150, 150);
		}

		if($_SESSION['current_school_applied'] == "School of Health Technology Kano"){
			$this->Image(base_url('assets/img/sht_kano_logo.jpg'), 30, 70, 150, 150);
		}

		if($_SESSION['current_school_applied'] == "School of Health Technology Bebeji, Kano"){
			$this->Image(base_url('assets/img/bbj_logo.jpg'), 30, 50, 150, 150);
		}

		$this->SetAlpha(1);
	}

	function Footer()
	{
	    // Go to 1.5 cm from bottom
	    $this->SetY(-15);
	    // Select Arial italic 8
	    $this->SetFont('Arial','I',8);
	   	$this->setTextColor(0, 0, 0);
	    // Print centered page number

	}

	protected $extgstates = array();

	 // alpha: real value from 0 (transparent) to 1 (opaque)
	 // bm:    blend mode, one of the following:
	 //          Normal, Multiply, Screen, Overlay, Darken, Lighten, ColorDodge, ColorBurn,
	 //          HardLight, SoftLight, Difference, Exclusion, Hue, Saturation, Color, Luminosity
	 function SetAlpha($alpha, $bm='Normal')
	 {
			 // set alpha for stroking (CA) and non-stroking (ca) operations
			 $gs = $this->AddExtGState(array('ca'=>$alpha, 'CA'=>$alpha, 'BM'=>'/'.$bm));
			 $this->SetExtGState($gs);
	 }

	 function AddExtGState($parms)
	 {
			 $n = count($this->extgstates)+1;
			 $this->extgstates[$n]['parms'] = $parms;
			 return $n;
	 }

	 function SetExtGState($gs)
	 {
			 $this->_out(sprintf('/GS%d gs', $gs));
	 }

	 function _enddoc()
	 {
			 if(!empty($this->extgstates) && $this->PDFVersion<'1.4')
					 $this->PDFVersion='1.4';
			 parent::_enddoc();
	 }

	 function _putextgstates()
	 {
			 for ($i = 1; $i <= count($this->extgstates); $i++)
			 {
					 $this->_newobj();
					 $this->extgstates[$i]['n'] = $this->n;
					 $this->_put('<</Type /ExtGState');
					 $parms = $this->extgstates[$i]['parms'];
					 $this->_put(sprintf('/ca %.3F', $parms['ca']));
					 $this->_put(sprintf('/CA %.3F', $parms['CA']));
					 $this->_put('/BM '.$parms['BM']);
					 $this->_put('>>');
					 $this->_put('endobj');
			 }
	 }

	 function _putresourcedict()
	 {
			 parent::_putresourcedict();
			 $this->_put('/ExtGState <<');
			 foreach($this->extgstates as $k=>$extgstate)
					 $this->_put('/GS'.$k.' '.$extgstate['n'].' 0 R');
			 $this->_put('>>');
	 }

	 function _putresources()
	 {
			 $this->_putextgstates();
			 parent::_putresources();
	 }

   function ClippingText($x, $y, $txt, $outline=false)
    {
        $op=$outline ? 5 : 7;
        $this->_out(sprintf('q BT %.2F %.2F Td %d Tr (%s) Tj ET',
            $x*$this->k,
            ($this->h-$y)*$this->k,
            $op,
            $this->_escape($txt)));
    }

    function ClippingRect($x, $y, $w, $h, $outline=false)
    {
        $op=$outline ? 'S' : 'n';
        $this->_out(sprintf('q %.2F %.2F %.2F %.2F re W %s',
            $x*$this->k,
            ($this->h-$y)*$this->k,
            $w*$this->k,-$h*$this->k,
            $op));
    }

    function _Arc($x1, $y1, $x2, $y2, $x3, $y3)
    {
        $h = $this->h;
        $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c ', $x1*$this->k, ($h-$y1)*$this->k,
            $x2*$this->k, ($h-$y2)*$this->k, $x3*$this->k, ($h-$y3)*$this->k));
    }

    function ClippingRoundedRect($x, $y, $w, $h, $r, $outline=false)
    {
        $k = $this->k;
        $hp = $this->h;
        $op=$outline ? 'S' : 'n';
        $MyArc = 4/3 * (sqrt(2) - 1);

        $this->_out(sprintf('q %.2F %.2F m',($x+$r)*$k,($hp-$y)*$k ));
        $xc = $x+$w-$r ;
        $yc = $y+$r;
        $this->_out(sprintf('%.2F %.2F l', $xc*$k,($hp-$y)*$k ));

        $this->_Arc($xc + $r*$MyArc, $yc - $r, $xc + $r, $yc - $r*$MyArc, $xc + $r, $yc);
        $xc = $x+$w-$r ;
        $yc = $y+$h-$r;
        $this->_out(sprintf('%.2F %.2F l',($x+$w)*$k,($hp-$yc)*$k));
        $this->_Arc($xc + $r, $yc + $r*$MyArc, $xc + $r*$MyArc, $yc + $r, $xc, $yc + $r);
        $xc = $x+$r ;
        $yc = $y+$h-$r;
        $this->_out(sprintf('%.2F %.2F l',$xc*$k,($hp-($y+$h))*$k));
        $this->_Arc($xc - $r*$MyArc, $yc + $r, $xc - $r, $yc + $r*$MyArc, $xc - $r, $yc);
        $xc = $x+$r ;
        $yc = $y+$r;
        $this->_out(sprintf('%.2F %.2F l',($x)*$k,($hp-$yc)*$k ));
        $this->_Arc($xc - $r, $yc - $r*$MyArc, $xc - $r*$MyArc, $yc - $r, $xc, $yc - $r);
        $this->_out(' W '.$op);
    }

    function ClippingEllipse($x, $y, $rx, $ry, $outline=false)
    {
        $op=$outline ? 'S' : 'n';
        $lx=4/3*(M_SQRT2-1)*$rx;
        $ly=4/3*(M_SQRT2-1)*$ry;
        $k=$this->k;
        $h=$this->h;
        $this->_out(sprintf('q %.2F %.2F m %.2F %.2F %.2F %.2F %.2F %.2F c',
            ($x+$rx)*$k,($h-$y)*$k,
            ($x+$rx)*$k,($h-($y-$ly))*$k,
            ($x+$lx)*$k,($h-($y-$ry))*$k,
            $x*$k,($h-($y-$ry))*$k));
        $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c',
            ($x-$lx)*$k,($h-($y-$ry))*$k,
            ($x-$rx)*$k,($h-($y-$ly))*$k,
            ($x-$rx)*$k,($h-$y)*$k));
        $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c',
            ($x-$rx)*$k,($h-($y+$ly))*$k,
            ($x-$lx)*$k,($h-($y+$ry))*$k,
            $x*$k,($h-($y+$ry))*$k));
        $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c W %s',
            ($x+$lx)*$k,($h-($y+$ry))*$k,
            ($x+$rx)*$k,($h-($y+$ly))*$k,
            ($x+$rx)*$k,($h-$y)*$k,
            $op));
    }

    function ClippingCircle($x, $y, $r, $outline=false)
    {
        $this->ClippingEllipse($x, $y, $r, $r, $outline);
    }

    function ClippingPolygon($points, $outline=false)
    {
        $op=$outline ? 'S' : 'n';
        $h = $this->h;
        $k = $this->k;
        $points_string = '';
        for($i=0; $i<count($points); $i+=2){
            $points_string .= sprintf('%.2F %.2F', $points[$i]*$k, ($h-$points[$i+1])*$k);
            if($i==0)
                $points_string .= ' m ';
            else
                $points_string .= ' l ';
        }
        $this->_out('q '.$points_string . 'h W '.$op);
    }

    function UnsetClipping()
    {
        $this->_out('Q');
    }

    function ClippedCell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
    {
        if($border || $fill || $this->y+$h>$this->PageBreakTrigger)
        {
            $this->Cell($w,$h,'',$border,0,'',$fill);
            $this->x-=$w;
        }
        $this->ClippingRect($this->x,$this->y,$w,$h);
        $this->Cell($w,$h,$txt,'',$ln,$align,false,$link);
        $this->UnsetClipping();
    }

}

?>
