<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use App\Models;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */

class BaseController extends Controller
{
	/**
	 * Instance of the main Request object.
	 *
	 * @var IncomingRequest|CLIRequest
	 */
	protected $request;

	/**
	 * An array of helpers to be loaded automatically upon
	 * class instantiation. These helpers will be available
	 * to all other controllers that extend BaseController.
	 *
	 * @var array
	 */
	protected $helpers = ['url', 'form'];
	protected $hod_model;
	protected $examofficer_model;
	protected $lecturer_model;
	protected $gsp_model;
	protected $levelcoordinator_model;
	protected $dean_model;
	protected $sbc_model;
	protected $senate_model;
	protected $session;
	protected $db;
	protected $portal_config;

	/**
	 * Constructor.
	 *
	 * @param RequestInterface  $request
	 * @param ResponseInterface $response
	 * @param LoggerInterface   $logger
	 */
	public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
	{
		// Do Not Edit This Line
		parent::initController($request, $response, $logger);

		//--------------------------------------------------------------------
		// Preload any models, libraries, etc, here.
		//--------------------------------------------------------------------
		// E.g.: $this->session = \Config\Services::session();
		
		$this->db = db_connect();
		$this->session = session();
		$this->dean_model = new Models\DeanModel();
		$this->hod_model = new Models\HodModel();
		$this->examofficer_model = new Models\ExamOfficerModel();
		$this->lecturer_model = new Models\LecturerModel();
		$this->gsp_model = new Models\GspModel();
		$this->levelcoordinator_model = new Models\LevelCoordinatorModel();
		$this->dean_model = new Models\DeanModel();
		$this->sbc_model = new Models\SbcModel();
		$this->senate_model = new Models\SenateModel();
		$this->portal_config = $this->gsp_model->get_portal_config();
		
	}
}
