<?php

namespace App\Controllers;
use \CodeIgniter\Controller;
use App\Models\Admin_model;
use App\Libraries\Myfpdf;
use App\Libraries\FPDF;
use App\Libraries\Lib;

class Admin extends Controller
{
	public $session;
	public $admin_model;
	public $fpdf;
	public $t1;
	public function __construct(){
		$this->fpdf = new FPDF();
		//$this->fpdf = new Myfpdf();
		$this->session = \Config\Services::session();
		$this->admin_model = new Admin_model();
    }
    
    public function index()
	{
		return view('Admin/login');
	}

	public function login(){
		return view("Admin/login");
    }

    public function dashboard()
	{
		return view('Admin/dashboard');
	}

	public function manage_ibr()
	{
		if(!session()->has('logged_admin')){
			return redirect()->to(base_url()."/Admin/login");	
		}
		$data = [
			'page_title' => 'Track your Application (IBR)',
			'user' => $this->session->get('name')
		];
		$data['result'] = $this->admin_model->manage_ibr();
		return view("Admin/manage_ibr",$data);
	}

	public function decision()
	{
		$data = [
			'page_title' => 'Track your Application (IBR)',
			'user' => $this->session->get('name')
		];
		//$data['result'] = $this->admin_model->approve_ibr();
		if($this->request->getMethod() == 'post'){
			//$id = $this->session->get('logged_user');
			$id = $this->request->getVar('id');
			$decision = $this->request->getVar('decision');
			$message = $this->request->getVar('message');
			$data['result'] = $this->admin_model->manage_ibr();
			
			if($this->admin_model->approve_ibr($id, $decision, $message)){
				$this->session->setTempdata('approveSuccess','Success',3);
				return redirect()->to('admin/manage_ibr');
			}else{
				$this->session->setTempdata('approveError','Error',3);
				return redirect()->to('admin/manage_ibr');
			}
		}
		
		
		
	}

	public function reject($id)
	{
		$data = [
			'page_title' => 'Track your Application (IBR)',
			'user' => $this->session->get('name')
		];
		$data['result'] = $this->admin_model->manage_ibr();
		
		if($this->admin_model->reject_ibr($id)){
			$this->session->setTempdata('rejectSuccess','Success',3);
			return redirect()->to('admin/manage_ibr');
		}else{
			$this->session->setTempdata('rejectError','Error',3);
			return redirect()->to('admin/manage_ibr');
		}
		
	}

	public function view($id){
		
		$this->fpdf->AliasNbPages();
		$this->fpdf->SetAutoPageBreak(1,13);
		$this->fpdf->AddPage('P','A4');
		//$this->response->setHeader('Content-Type','application/pdf');
		$this->fpdf->Output();
	}


    public function check_login(){
		
		if($this->request->getMethod() == 'post'){
			$username = $this->request->getVar('username');
			$password = $this->request->getVar('password');

			$adminStatus = $this->admin_model->verify_admin($username);

			if($adminStatus){
				if($adminStatus['password'] == '123'){
					
						$this->session->set('logged_admin', $adminStatus['username']);
						$this->session->set('name', $adminStatus['name']);
						return redirect()->to('admin/dashboard');
					
				}else{
					$this->session->setTempdata('loginError','Incorrect Password',3);
			        return redirect()->to('admin/login');
				}				
			}else{
				$this->session->setTempdata('loginError','Username does not exist',3);
			    return redirect()->to('admin/login');
			}
		}
    }
    

    
}