<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Northwest University Kano | Exam Officer Login</title>

	<!-- Google Font: Source Sans Pro -->
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link rel="shortcut icon" href="<?= base_url("/../assets/img/nwu_logo.jpeg");?>" type="image/x-icon">
	<!-- Font Awesome -->
	<link rel="stylesheet" href="<?= base_url('/../assets_/plugins/fontawesome-free/css/all.min.css') ?>">
	<!-- Uncheck bootstrap -->
	<link rel="stylesheet" href="<?= base_url('/../assets_/plugins/icheck-bootstrap/icheck-bootstrap.min.css') ?>">
	<!-- Theme style -->
	<link rel="stylesheet" href="<?= base_url('/../assets_/dist/css/adminlte.min.css') ?>">
</head>
<body class="hold-transition login-page">
<div class="login-box">
	<div class="login-logo">
		<img src="<?= base_url('../assets/img/nwu_logo.png') ?>" style="width: 120px;" alt="Kano_Logo"><br/>
        <h6>Northwest University Kano</h6>
        <h5><b class="badge badge-primary">NWU Result Processing System</b></h5><hr/>
        <h4><b>Exam Officer Login</b></h4>
	</div>
	<!-- /.login-logo -->
	<div class="card">
		<div class="card-body login-card-body">
			<p class="login-box-msg">Sign in to start your session</p>

			<?php $page_session = \Config\Services::session(); ?>
                  <?php

                  if($page_session->getTempdata('loginError')):       
                  ?>
                  <div class = "alert alert-danger">
                       <?= $page_session->getTempdata('loginError'); ?>
                  </div>
                  <?php 
                  endif;
                  ?>

			<?php $page_session = \Config\Services::session(); ?>
				  <?php
				  if($page_session->getTempdata('passwordChanged')):       
                  ?>
                  <div class = "alert alert-success">
                       <?= $page_session->getTempdata('passwordChanged'); ?>
                  </div>
                  <?php 
                  endif;
                  ?>
			
			<form action="<?= base_url('examofficer/login_checker') ?>" method="post">
				<div class="input-group mb-3">
					<input type="text" name="email" class="form-control" placeholder="Email" value="<?=set_value('email')?>" required>
					<div class="input-group-append">
						<div class="input-group-text">
							<span class="fas fa-envelope"></span>
						</div>
					</div>
				</div>
				<div class="input-group mb-3">
					<input type="password" name="password" class="form-control" placeholder="Password" required>
					<div class="input-group-append">
						<div class="input-group-text">
							<span class="fas fa-lock"></span>
						</div>
					</div>
				</div>
				<div class="row">

					<!-- /.col -->
					<div class="col-12">
						<button type="submit" class="btn btn-primary btn-block">Sign In</button>
					</div>
					<!-- /.col -->
				</div>
			</form>
			<hr/>
              <p class="mb-0 pull-right" align="right">
                <a href="<?= base_url('/') ?>" class="btn btn-outline-primary btn-block"><i class="fas fa-exchange-alt"></i> &nbsp; Switch Account</a>
              </p>
		</div>
		<!-- /.login-card-body -->
	</div>
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="<?= base_url('assets/plugins/jquery/jquery.min.js') ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?= base_url('assets/plugins/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>
<!-- AdminLTE App -->
<script src="<?= base_url('assets/dist/js/adminlte.min.js') ?>"></script>
</body>
</html>
