<?= $this->extend("templates/gsp_base"); ?>

<?= $this->section("content"); ?>
<?php $page_session = \Config\Services::session(); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?= base_url()?>/lecturer/dashboard">Home</a></li>
              <li class="breadcrumb-item active">Dashboard</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">  
        <div class="row">
          <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box">
              <span class="info-box-icon bg-info"><i class="fas fa-book"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">GSP Courses</span>
                <span class="info-box-number"><?=$c_num?></span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
        </div>
        
        <div class="row">
          <!-- Left col -->
          <div class="col-12">
            <!-- MAP & BOX PANE -->
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">List of GSP Courses</h3>
                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-widget="collapse">
                    <i class="fa fa-minus"></i>
                  </button>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="table-responsive">
                  <table id="lecturer" class="table table-bordered table-striped" cellspacing="0" width="100%">
                    <thead>
                      <tr>
                        <th>#</th>
                        <th>Course Code</th>
                        <th>Title</th>
                        <th>Semester</th>
                        <th>Credits Unit</th>
                        <th>Level</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php 
                        $i = 0; 
                        if(!empty($courses)): 
                          foreach($courses as $res): ?>
                            <tr>
                              <td><?= $i = $i + 1; ?></td>                     
                              <td><?= $res->id?></td>
                              <td><?= $res->title?></td>
                              <td><?= $res->semester ?></td>
                              <td><?= $res->credit_unit ?></td>
                              <td><?= $res->level?></td>
                            </tr>
                      <?php endforeach;
                        endif; ?>
                    </tbody>
                  </table>
                </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
      </div>
    </section>
  </div>

<?= $this->endSection(); ?>