<?= $this->extend("templates/gsp_base"); ?>

<?= $this->section("content"); ?>
<?php $page_session = \Config\Services::session(); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Upload Result Sheet</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item">Exam Results</li>
              <li class="breadcrumb-item active">Upload Result Sheet</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- SELECT2 EXAMPLE -->
        <div class="card card-default">
          <div class="card-header">
            <h3 class="card-title"><strong>Upload Result Sheet</strong></h3>
            <?php $page_session = \Config\Services::session(); ?>
            
          </div>
          <!-- /.card-header -->
          <div class="card-body">
                
              <?php

                if($page_session->getTempdata('uploadError')):       
                ?>
                <div class = "alert alert-danger">
                    <?= $page_session->getTempdata('uploadError'); ?>
                </div>
                <?php 
                endif;
                ?>
                <?php

                if($page_session->getTempdata('uploadSuccess')):       
                ?>
                <div class = "alert alert-success">
                    <?= $page_session->getTempdata('uploadSuccess'); ?>
                </div>
                <?php 
                endif;

                if($upload_status == 1 && $upload_deadline > date("d F, Y")){
                ?>
			  
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                  <label>Select Session:<font style="color:#F00">*</font></label>
                  <select class="form-control select2" style="width: 100%;" name="session" id="sessionField"  required>
                <?php for($count = 2022; $count <= substr($current_ss,0,4); $count++) { $count2=$count+1; $ss=$count.'/'.$count2; ?>
        				  <option <?php if($page_session->get('current_session')==$ss) echo 'selected'; ?> value = "<?=str_replace('/', '_', $ss)?>"><?=$ss?></option>
                  <?php } ?>

                  </select>
                </div>

              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label>Select Course:<font style="color:#F00">*</font></label>
                  <select class="form-control select2" name="course" id="courseField" onchange="spawn_allocated_programmes_upload()" required>
                    <option selected disabled>- Select Course -</option>
                    <?php
                      foreach($courses as $co){
                     //   if($co->level == 100){
                    ?>
                    <option value = "<?=$co->id?>"><?=$co->id.": ".$co->title?></option>
                    <?php } //} ?>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
				        <div id = "allocatedProgrammeField"></div>
              </div>         

        </div>
        <hr/>

        <div class="row">
            <div class="col-md-12">
                <div id="excel_result_info2"> 
                    <div class="alert alert-info">
                      <h5><i class="icon fas fa-info"></i> Note</h5>
                      Upload button will appear below once Course & Programme are selected.<br/> You are only allowed to upload exam results for level 100 courses.
                    </div>
                </div>
				
				<form action = "<?= base_url('gsp/upload_direct') ?>" id="" class="sky-form" enctype = "multipart/form-data" method="post">
					<div id = "direct_btn"></div>
				</form>
				
				<form action = "<?= base_url('gsp/upload_sheet') ?>" id="" class="sky-form" enctype = "multipart/form-data" method="post">
					<div id = "sheet_btn"></div>
				</form>
				
            </div>
        </div>
        <?php
          }else{
        ?>
                
        <div class="row">
            <div class="col-md-12">
              <div class="alert alert-danger">
                <h5><i class="icon fas fa-ban"></i> Upload Disabled</h5>
                Result upload has been disabled <?=$upload_deadline?>. Please contact your Head of Department/ICT Directorate for further details.
              </div>
            </div>
        </div>
          <?php } ?>
        </div>
        <!-- /.card -->


      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <!-- /.modal -->
  
  
	  </form>
      <!-- /.modal -->

<?= $this->endSection(); ?>