<?= $this->extend("templates/gsp_base"); ?>

<?= $this->section("content"); ?>
<?php $page_session = \Config\Services::session(); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>GSP Courses</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">GSP Courses</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- SELECT2 EXAMPLE -->
        <div class="card card-default">
          <div class="card-header">
            <h3 class="card-title"><strong>List of GSP Course</strong></h3>
          </div>
          <!-- /.card-header -->
          <div class="card-body">
            <?php echo form_open('gsp/view_courses', ['method' => 'GET', 'autocomplete' => 'off']); ?> 
            <div class="row">
                <div class="col-4">
                    <div class="form-group">
                        <label>Semester:</label>
                        <select name="semester" id="semester" class="form-control select2" onchange="$(this).parents('form').submit();" required>
                            <option value="" disabled selected>- Select Semester -</option>
                            <option <?=$semester=='1st'? 'selected' : ''?> value='1st'>1st</option>
                            <option <?=$semester=='2nd'? 'selected' : ''?> value='2nd'>2nd</option>
                        </select>
                  </div>
                </div>
                <div class="col-4">
                    <div class="form-group">
                        <label>Level:</label>
                        <select name="level" id="level" class="form-control select2" onchange="$(this).parents('form').submit();" required>
                            <option value="" disabled selected>- Select Level -</option>
                            <option <?=$level=='100'? 'selected' : ''?> value='100'>100</option>
                            <option <?=$level=='200'? 'selected' : ''?> value='200'>200</option>
                            <option <?=$level=='300'? 'selected' : ''?> value='300'>300</option>
                            <option <?=$level=='400'? 'selected' : ''?> value='400'>400</option>
                        </select>
                  </div>
                </div>
                <div class="col-4">
                  <div class="form-group" style="margin-top: 25px;">
                    <a href="<?php echo base_url('gsp/view_courses') ?>" class="btn btn-danger"><?php echo lang('reset') ?></a>
                  </div>
                </div>
            </div>
            <?php echo form_close(); ?>
              <hr/>
		  
            <div class="row">
                <div class="col-md-12">
                <div class="table-responsive">
                  <table id="lecturer" class="table table-bordered table-striped" cellspacing="0" width="100%">
                    <thead>
                      <tr>
                        <th>#</th>
                        <th>Course Code</th>
                        <th>Title</th>
                        <th>Semester</th>
                        <th>Credits Unit</th>
                        <th>Level</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php 
                        $i = 0; 
                        if(!empty($courses)): 
                          foreach($courses as $res): ?>
                            <tr>
                              <td><?= $i = $i + 1; ?></td>                     
                              <td><?= $res->id?></td>
                              <td><?= $res->title?></td>
                              <td><?= $res->semester ?></td>
                              <td><?= $res->credit_unit ?></td>
                              <td><?= $res->level?></td>
                            </tr>
                      <?php endforeach;
                        endif; ?>
                    </tbody>
                  </table>
                </div>
                </div>
            </div>
             
          
        </div>
        <!-- /.card -->


      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  <script>
    function spawn_allocations(){
    $('.select2').select2();
        //var programme = $('#progammes').val();
        var session = document.getElementById('sessionField').value; 
        //alert(session);
           	
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                            document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                                 
                         //stuff for data table     
                             $('#dept_students_tbl1').dataTable({
                             dom: 'Bfrtip',
                             buttons: ['copy','csv','excel','pdf','print', 'colvis']
                                                     }); 
         
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('lecturer/get_course_allocations') ?>/"+session+"/"+"\"",true);
                     xmlhttp.send();
      }



    </script>

<?= $this->endSection(); ?>