<?= $this->extend("templates/levelcoordinator_base"); ?>

<?= $this->section("content"); ?>
<?php $page_session = \Config\Services::session(); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Settings</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Settings</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
	  <?php if($page_session->getTempdata('saveSuccess')):       
                                ?>
                                <div class = "alert alert-success alert-dismissible">
                                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                     <?= $page_session->getTempdata('saveSuccess'); ?>
                                </div>
                                <?php 
                                endif;
                                ?>
              
                              <?php
              
                              if($page_session->getTempdata('saveError')):       
                              ?>
                              <div class = "alert alert-danger alert-dismissible">
                                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                  <?= $page_session->getTempdata('saveError'); ?>
                              </div>
                              <?php 
                              endif;
                              ?>
        <!-- SELECT2 EXAMPLE -->
        <div class="card card-default">
          <div class="card-header">
            <h3 class="card-title"><strong>Registration Configurations</strong></h3>

            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse">
                <i class="fas fa-minus"></i>
              </button>
              <button type="button" class="btn btn-tool" data-card-widget="remove">
                <i class="fas fa-times"></i>
              </button>
            </div>
          </div>
          <!-- /.card-header -->
          <div class="card-body">
		  
		  <div class="row">
              <div class="col-md-12">
			  
			  <div class="card">
              <div class="card-header">
                <h3 class="card-title"><strong>Credit Units</strong></h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
		  
		  		<div class="col-md-12">
					<div id = "semesterField">
					    
					    <div id="accordion">
                      <button class="btn btn-primary btn-sm pull-right" id="credit_limit" name="credit_limit" data-toggle="collapse" href="#set_credit_limit"><i class="fa fa-plus"></i> Set Credit Unit Limits</button>
                      <div id="set_credit_limit" class="collapse" data-parent="#accordion">
                        <hr/>
                        <form method="POST" action="<?= base_url('levelcoordinator/credit_limit_action') ?>" id="eo_form">
                          <input type="hidden" name="action" value="add"/>
                          <div class="row">
						  						
                            
							<div class="col-md-6">
                              <!-- <div id = "checkBoxesArea"></div> -->
                              <div class="form-group">
                                <label>Enter Minimum Credit Units</label>
                                <div class="select2-primary">
                                <input type = "number" min = "0" max = "50" step = "1" value = "<?= $detail['minimum_credits'] ?>" class="form-control" name="minimum"  required>
                                </div>
                              </div>
                            </div>
							
							<div class="col-md-6">
                              <!-- <div id = "checkBoxesArea"></div> -->
                              <div class="form-group">
                                <label>Enter Maximum Credit Units</label>
                                <div class="select2-primary">
                                <input type = "number" min = "0" max = "50" step = "1" value = "<?= $detail['maximum_credits'] ?>" class="form-control" name="maximum"  required>
                                </div>
                              </div>
                            </div>
							
                            
                          </div>
                          <div class="row" align="right">
                            <div class="col-12">
                              <input type="submit" name="submit" id="submit_button" value="Submit" class="btn btn-primary pull-right">
                            </div>
                          </div>
                        </form>
                      </div>
                    </div>          

          </div>          
				</div>
				</div>          
				</div>
				</div>
				</div>
          
			<div class="row">
              <div class="col-md-12">
                
              <div class="card">
              <div class="card-header">
                <h3 class="card-title"><strong>Core & Electives</strong></h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
              <div class="row">
              
              <div class="col-md-6">
					<div id = "semesterField">
              
              <div id="accordion">
                      <button class="btn btn-primary btn-sm pull-right" id="add_core" name="add_eo" data-toggle="collapse" href="#addCore"><i class="fa fa-plus"></i>  Add Core Course</button>
                      <div id="addCore" class="collapse" data-parent="#accordion">
                        <hr/>
                        <form method="POST" action="<?= base_url('levelcoordinator/configuration_action') ?>" id="eo_form">
                          <input type="hidden" name="action" value="core_course"/>
                          <div class="row">
                            
                            
                            <div class="col-md-12">
                              <!-- <div id = "checkBoxesArea"></div> -->
                              <div class="form-group">
                                <label>Course</label>
                                <div class="select2-primary">
                                <select name="core_course[]" id="core_course" multiple="multiple" data-placeholder="Select Course" class="form-control select2 select2-multiple" required>
                                <?php foreach($course as $co): 
                                  $value = $co->id."-".$co->title."-".$co->credit_unit."-".$co->semester;
                                ?>
                              
                  <option value = '<?= $value ?>'><?= $co->id ?> - <?= $co->title ?></option>
                  <?php endforeach; ?>
                                </select>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="row" align="right">
                            <div class="col-12">
                              <input type="submit" name="submit" id="submit_button" value="Submit" class="btn btn-primary pull-right">
                            </div>
                          </div>
                        </form>
                      </div>
                    </div>          

          </div>          
        </div>
              

        <div class="col-md-6">
          <div id = "semesterField">
              
              <div id="accordion">
                      <button class="btn btn-primary btn-sm pull-right" id="add_elective" name="add_elective" data-toggle="collapse" href="#addElective"><i class="fa fa-plus"></i>  Add Elective Courses</button>
                      <div id="addElective" class="collapse" data-parent="#accordion">
                        <hr/>
                        <form method="POST" action="<?= base_url('levelcoordinator/configuration_action') ?>" id="eo_form">
                          <input type="hidden" name="action" value="elective_course"/>
                          <div class="row">
                            
              <div class="col-md-12">
                              <!-- <div id = "checkBoxesArea"></div> -->
                              <div class="form-group">
                                <label>Course</label>
                                <div class="select2-primary">
                                <select name="elective_course[]" id="elective_course" multiple="multiple" data-placeholder="Select Course" class="form-control select2 select2-multiple" required>
                                <?php foreach($course as $co): 
                     $value = $co->id."-".$co->title."-".$co->credit_unit."-".$co->semester;
                ?>
                  <option value = '<?= $value ?>'><?= $co->id ?> - <?= $co->title ?></option>
                  <?php endforeach; ?>
                                </select>
                                </div>
                              </div>
                            </div>
                            
                          </div>
                          <div class="row" align="right">
                            <div class="col-12">
                              <input type="submit" name="submit" id="submit_button" value="Submit" class="btn btn-primary pull-right">
                            </div>
                          </div>
                        </form>
                      </div>
                    </div>          

          </div>          
        </div>
        
            
              
              <!-- /.card-body -->
                  
          <!-- /.card-body -->
              

        </div>
              <!-- /.card-body -->
            </div>
                
                
              </div>
              
              <!-- /.col -->
            </div>
            <!-- /.row -->

            
            <!-- /.row -->
          </div>
      
      
      <div class="card-body">
      
      <div class="row">
              <div class="col-md-12">
                
                            <!-- /.card-header -->
              
                <div class="col-md-12 table-responsive">
                  <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                          <th>#</th>
                          <th>Course Code</th>
                          <th>Course Title</th>
              <th>Credit Unit</th>
                          <th>Semester</th>
                          <th>Status</th>
                          <th>Session</th>
                          <th class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                      <?php $i = 1; ?>
                      <?php if(!empty($courses_selected)): ?>
                      <?php foreach($courses_selected as $cs): ?>
                        <tr>
                          <td><?= $i++; ?></td>
                          <td><?= $cs->code ?></td>
                          <td><?= $cs->title ?></td>
                          <td><?= $cs->unit ?></td>
                          <td><?= $cs->semester ?></td>
                          <td><?= $cs->status ?></td>
                          <td><?= $cs->session ?></td>
                          <td class="text-center"><button class="btn btn-warning btn-xs delete_btn" title="Edit" data-id="<?= $cs->code ?>"><i class="fas fa-edit"></i></button></td>
                        </tr>
                      <?php endforeach; ?>
                      <?php endif; ?>
                    </tbody>
                  </table>
                </div>
              
              <!-- /.col -->
            </div>
            <!-- /.row -->
      
      </div>
      </div>

          
              <!-- /.card-header -->
              <!--<div class="card-body" id = "txtHintDeptStudents">
                    <b>List of Students Here...</b>
              </div>-->
             
          
        </div>
        <!-- /.card -->


      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
<?= $this->endSection(); ?>