<?php

namespace App\Controllers;
use \CodeIgniter\Controller;
use App\Models\User_model;
use App\Libraries\fpdf;

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Examofficer extends BaseController
{
	public $session;
	public $fpdf;

	public function __construct(){
		
		$this->fpdf = new FPDF();
		$this->session = \Config\Services::session();
	}

	public function login(){
		return view("examofficer/login");
	}

	public function logout(){
		$this->session->remove('examofficer_logged');
		$this->session->remove('name');
		$this->session->remove('department');
		$this->session->destroy();
		return redirect()->to(base_url().'/exam-login');	
	}
	
	public function login_checker()
	{
		if($this->request->getMethod() == 'post'){
			$email = $this->request->getVar("email");
			$password = $this->request->getVar("password");

			$check_login = $this->examofficer_model->verify_examofficer($email);

			if($check_login){
				if(password_verify($password, $check_login[0]['password'])){
					//$portal_config = $this->lecturer_model->get_portal_config();
					$this->session->set('examofficer_logged', true);
					$this->session->set('email', $check_login[0]['email']);
					$this->session->set('id', $check_login[0]['stfn']);
					$this->session->set('staff_id', $check_login[0]['staff_id']);
					$this->session->set('uid', $check_login[0]['id']);
					$this->session->set('name', $check_login[0]['name']);
					$dept_id = $check_login[0]['dept_id'];
					$programme_name = $this->examofficer_model->get_programme_name($check_login[0]['programme_id']);
					$department = $this->lecturer_model->get_department_name($dept_id)['title'];
					$faculty = $this->lecturer_model->get_faculty_name(17);
					$this->session->set('dept_id', $dept_id);
					$this->session->set('department', $department);
					$this->session->set('programme_id', $check_login[0]['programme_id']);
					$this->session->set('programme_name', $programme_name['title']);
					$this->session->set('department', $department);
					$this->session->set('current_session', $this->portal_config['reg_session']);
				
					return redirect()->to(base_url().'/exam-index');
				}else{
					$this->session->setTempdata('loginError', 'Incorrect Password', 3);
					return redirect()->to(base_url().'/exam-login');
				}
				
			}else{
				$this->session->setTempdata('loginError', 'User Number does not Exist', 3);
				return redirect()->to(base_url().'/exam-login');
			}
	}

	} // end of login checker
	
	public function dashboard()
	{

		if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		$data = [
			'page_title' => 'Dashboard',
			'page_subtitle' => '',
			'user' => $this->session->get('name'),
			'id' => $this->session->get('id'),
			'model' => $this->examofficer_model
		];
		
		return view("examofficer/dashboard", $data);
		
	}
	
	public function password(){

		if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/examofficer/login");	
		}
		if($this->request->getMethod() == 'post'){
		    $pass = password_hash($this->request->getVar('pass1'), PASSWORD_BCRYPT);
            $error = '';
            $success = '';
			if($this->examofficer_model->update_password($this->session->get('uid'), $pass)){
				$success = "Password updated successfully";
			}else{
				$error = "Oops! Something went wrong. Try later.";
			}

            $output = array(
                'error'		=>	$error,
                'success'	=>	$success
            );
        	echo json_encode($output);
		}else{
    		$data = [
    			'page_title' => 'Settings',
    			'page_subtitle' => 'Change Password',
    			'user' => $this->session->get('name')
    		];
    		
    		return view('examofficer/change_password', $data);
		}
		
	}

	public function view_courses()
	{

		if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		$data = [
			'page_title' => 'My Courses',
			'page_subtitle' => '',
			'user' => $this->session->get('name')
		];
		$data['result'] = $this->lecturer_model->get_course_allocation('P2013/0383', '2020/2021');
		//$data['user'] = $this->session->get('logged_hod');
		echo view('templates/lecturer_header', $data);
		echo view('lecturer/view_courses');
		echo view('templates/lecturer_footer');
		
	}

	public function view_previous_courses()
	{

		if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		$data = [
			'page_title' => 'My Previous Courses',
			'page_subtitle' => '',
			'user' => $this->session->get('name')
		];
		$data['result'] = $this->lecturer_model->get_previous_course_allocation('P2013/0383', '2020/2021');
		//$data['user'] = $this->session->get('logged_hod');
		echo view('templates/lecturer_header', $data);
		echo view('lecturer/view_previous_courses');
		echo view('templates/lecturer_footer');
		
	}

	public function view_students()
	{

		if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		$data = [
			'page_title' => 'My Students',
			'page_subtitle' => '',
			'user' => $this->session->get('name')
		];

		$id = $this->session->get('programme_id');
		$title = $this->session->get('programme_name');
		$level = $this->session->get('level');
		
		
		$data['student'] = $this->examofficer_model->get_students($id, $level);
	
		return view("examofficer/view_students", $data);
	}

	public function student_bio_data($id)
	{

		if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		$data = [
			'page_title' => 'My Students',
			'user' => $this->session->get('name')
		];

		$id = $this->session->get('programme_id');
		$title = $this->session->get('programme_name');
		$level = $this->session->get('level');
		
		
		$data['student'] = $this->examofficer_model->get_students($id, $level);
	
		return view("examofficer/student_bio_data", $data);
	}

	public function course_registrations()
	{

		if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		$data = [
			'page_title' => 'My Students',
			'page_subtitle' => 'Course Registrations',
			'user' => $this->session->get('name')
		];
		
		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}

		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
	
		return view("examofficer/course_registrations", $data);
		
	}

	public function student_course_registrations()
	{
	    if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
	
		if($this->request->getMethod() == 'post'){
			
			$id = $this->session->get('programme_id');
			$level = $this->session->get('level')."";

			$student = $this->examofficer_model->get_registered_students($id, $level);
			
			foreach($student as $stud){
				//echo $stud->student_id;
				if(isset($_POST[$stud->student_id])){
					$id = $_POST[$stud->student_id];
					
					$data = [
						'page_title' => 'Student Course Registration',
						'user' => $this->session->get('name')
					];
					
					$data['course'] =  $this->examofficer_model->get_courses("Computer Science");
					$data['student'] = $this->examofficer_model->get_student_courses($id);
					$data['detail'] = $this->examofficer_model->get_student_details($id);
					//$data['user'] = $this->session->get('logged_hod');
					echo view('templates/examofficer_header', $data);
					echo view('examofficer/student_course_registrations');
					echo view('templates/examofficer_footer');
				}
			}
		}
			

		
	}
	
	public function course_enrollments()
	{

		if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		$data = [
			'page_title' => 'Course Enrollments',
			'page_subtitle' => 'Course Enrollments',
			'user' => $this->session->get('name')
		];

		$data['model'] = $this->examofficer_model;

		
		return view('examofficer/view_enrollments', $data);
		
	}
	
	public function lecturers_submission()
	{

		if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		$data = [
			'page_title' => 'Exam Results',
			'page_subtitle' => 'Lecturers Submission',
			'user' => $this->session->get('name')
		];

		$data['model'] = $this->examofficer_model;

		
		return view('examofficer/lecturers_submission', $data);
		
	}
	
	// get programme available
	function get_programme_available($session)
	{
	    if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}

		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		
        $program = explode(',',$this->session->get('programme_id'));
        //foreach($program as $prog){
          
                      
		//$programme = $this->levelcoordinator_model->get_semester($username, $session);
		
		$value = [];
		$output = "";
		if(!empty($program)){
			$output .= '<div class="form-group">
			<label class="label"><b>Select Programme:</b></label><br/>
			<select class="form-control select2" name="programme" id="programmeField" onchange="spawn_course_enrollments()" required> 
			<option selected disabled value="">-Programme-</option>';
			foreach($program as $prog){
			    //$pdetail[0]->title;
			    $pdetail = $this->examofficer_model->get_program_details($prog);
				$output .= "<option value = ".$pdetail[0]->title.">".$pdetail[0]->title."</option>";                                            
			}
			$output .= "</select> <i></i><b class='tooltip tooltip-bottom-right'>Labels</b></section>";
		}else{
			$output .= '<br/><div class="alert alert-danger alert-dismissible"><i class="icon fas fa-exclamation-triangle"></i> No enrollments for this session!</div>';
		}
					
		echo $output;
	//}
	
	}
	
		//View list of Lecturers Submission
	function get_course_enrollments($session, $programme)
	{
	    if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		/*$session = "2020/2021";
		$programme = "58";
		$semester = "1st";*/
		
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		
		$programme = urldecode($programme);
		$programme = str_replace("_","/",$programme);
		
		$department = $this->session->get('name');
		$dept_id = $this->session->get('dept_id');
		$id = $this->session->get('id');
		$list = $this->examofficer_model->get_submitted_results($session, $programme);

			$output = "";
			$view_dialog = "";
		if($list){
		
			foreach($list as $l){
				if(strpos($l->course_id, "GSP") !== false || strpos($l->course_id, "GST") !== false){
					$l->lecturer = "GSP Coordinator";
				}else{
					$details = $this->examofficer_model->get_staff_details($l->lecturer_id);
					$l->lecturer = $details['name']; 
				}

				$cdetails = $this->examofficer_model->get_course_details($l->course_id);
				$l->course_title = $cdetails['title']; 
				
			}
			
			if(!empty($list)){
			
				$output .= "<div class='row'>
		
				<div class='col-md-12 table-responsive' > 
				<table id='example1' class='table table-bordered table-striped text-sm'>
						<thead>
					   <tr>
							<th>S/N</th> 
							<th>Course Code/Title</th>
							<th>Programme</th>
							<th>Lecturer</th>
							<th>Status</th>
							<th>Submitted On</th>
							<th>Action</th>
						</tr>
				   </thead>
				<tbody>";
				$i = 1;
				foreach($list as $sub){	
    				$pdetails = $this->examofficer_model->get_programme_name($sub->programme_id);
    				$prog = $pdetails['title']; 
    				$stat = $sub->eo_status == "Accepted" ? 'success' : ($sub->eo_status == "Rejected" ? 'danger' : 'warning');
					
					$output .= "<tr><td>".$i++."</td>";
					$output .= "<td>".$sub->course_id.":<br/>".$sub->course_title."</td>";
					$output .= "<td>".$prog."</td>";
					$output .= "<td>".$sub->lecturer."</td>";
					$output .= "<td><span class='badge badge-".$stat."'>".$sub->eo_status."</span></td>";
					$output .= "<td>".$sub->created_at."</td>";
					if($sub->submission_status == "Completed"){ 
						$id_value = "#".$sub->id;
						$stt = $sub->eo_status != "Pending" ? "disabled" : "";
						$output .= '<td><button title="View" class="btn btn-info btn-xs" data-target = '.$id_value.' data-toggle="modal" ><i class="fas fa-eye"></i></button> <button '.$stt.' title="Accept" class="btn btn-success btn-xs accept_button" data-id='.$sub->id.'><i class="fas fa-check"></i></button> <button '.$stt.' title="Reject" class="btn btn-danger btn-xs reject_button" data-id='.$sub->id.'><i class="fas fa-ban"></i></button></td>';
						
						$view_dialog .= '<div class="modal fade" id='.$sub->id.' >
								<div class="modal-dialog modal-lg">
								  <div class="modal-content">
									<div class="modal-header">
    								  <h5 class="modal-title"><span class="badge badge-secondary">Course: </span>'.$sub->course_id.': '.$sub->course_title.'<br/>
    								  <span class="badge badge-secondary">Programme: </span>'.$prog.'<br/>
    								  <span class="badge badge-secondary">Session: </span>'.$session.'</h5>
									  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
										<span aria-hidden="true">&times;</span>
									  </button>
									</div>
									<div class="modal-body">
									
									<table id="example11" class="table table1 table-bordered table-striped" width="100%">
									<thead>
									<tr>
										<th>S/N</th> 
										<th>Registration Number</th>
										<th>Full Name</th>
										<th>CA</th>
										<th>Exam</th>
										<th>Total</th>
										<th>Grade</th>
									</tr>
									</thead>
									<tbody>';
				
									$result = $this->examofficer_model->get_marks($sub->id);
									$index = 1;
									$color = '';
								if(!empty($result)){
									foreach($result as $res){
										if($res->grade == 'F'){
											$color = 'text-danger';
										}

										$view_dialog .= '<tr class="'.$color.'">';
										$view_dialog .= '<td>'.$index++.'</td>';
										$view_dialog .= '<td>'.$res->reg_no.'</td>';
										$view_dialog .= '<td>'.$res->first_name.' '.$res->middle_name.' '.$res->last_name.'</td>';
										$view_dialog .= '<td>'.$res->ca_marks.'</td>';
										$view_dialog .= '<td>'.$res->exam_marks.'</td>';
										$view_dialog .= '<td>'.$res->total_marks.'</td>';
										$view_dialog .= '<td>'.$res->grade.'</td>';
										$view_dialog .= '</tr>';
										$color = '';
									}
									
					}
									
									$view_dialog .="</tbody>
									</table>
									</div>
									</div>
									</div>
									</div>";
					}else{ 
						$output .= '<td><button disabled class="btn btn-info btn-xs"><i class="fas fa-eye"></i></button></td>';
					} 
					$output .= "</tr>";
					
					
				}							
		
				$output .="</tbody>
				</table>
				</div>
				</div>";
			}else{
				$output .= "List of Submissions Here...";
			}
		}else{
			$output .= '<div class="alert alert-danger alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                  <i class="icon fas fa-exclamation-triangle"></i> No submission yet!
                </div>';
		}
		
	
		echo $output;
		echo $view_dialog;
	}

		//View list of Lecturers Submission
	function get_lecturers_submission($session, $programme, $semester)
	{
	    
	    if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		
		/*$session = "2020/2021";
		$programme = "58";
		$semester = "1st";*/
		
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$programme = urldecode($programme);
		$semester = urldecode($semester);

		$department = $this->session->get('name');
		$dept_id = $this->session->get('dept_id');
		$id = $this->session->get('id');
		$list = $this->examofficer_model->get_submitted_results($programme, $semester, $session, $dept_id);

			$output = "";
			$view_dialog = "";
		if($list){
		
			foreach($list as $l){
				if(strpos($l->course_id, "GSP") !== false || strpos($l->course_id, "GST") !== false){
					$l->lecturer = "GSP Coordinator";
				}else{
					$details = $this->examofficer_model->get_staff_details($l->lecturer_id);
					$l->lecturer = $details['name']; 
				}

				$cdetails = $this->examofficer_model->get_course_details($l->course_id);
				$l->course_title = $cdetails['title']; 
				
			}
			
			if(!empty($list)){
			
				$output .= "<div class='row'>
		
				<div class='col-md-12 table-responsive' > 
				<table id='example1' class='table table-bordered table-striped text-sm'>
						<thead>
					   <tr>
							<th>S/N</th> 
							<th>Course Code/Title</th>
							<th>Programme</th>
							<th>Lecturer</th>
							<th>Status</th>
							<th>Submitted On</th>
							<th>Action</th>
						</tr>
				   </thead>
				<tbody>";
				$i = 1;
				foreach($list as $sub){	
    				$pdetails = $this->examofficer_model->get_programme_name($sub->programme_id);
    				$prog = $pdetails['title']; 
    				$stat = $sub->eo_status == "Accepted" ? 'success' : ($sub->eo_status == "Rejected" ? 'danger' : 'warning');
					
					$output .= "<tr><td>".$i++."</td>";
					$output .= "<td>".$sub->course_id.":<br/>".$sub->course_title."</td>";
					$output .= "<td>".$prog."</td>";
					$output .= "<td>".$sub->lecturer."</td>";
					$output .= "<td><span class='badge badge-".$stat."'>".$sub->eo_status."</span></td>";
					$output .= "<td>".$sub->created_at."</td>";
					if($sub->submission_status == "Completed"){ 
						$id_value = "#".$sub->id;
						$stt = $sub->eo_status != "Pending" ? "disabled" : "";
						$output .= '<td><button title="View" class="btn btn-info btn-xs" data-target = '.$id_value.' data-toggle="modal" ><i class="fas fa-eye"></i></button> <button '.$stt.' title="Accept" class="btn btn-success btn-xs accept_button" data-id='.$sub->id.'><i class="fas fa-check"></i></button> <button '.$stt.' title="Reject" class="btn btn-danger btn-xs reject_button" data-id='.$sub->id.'><i class="fas fa-ban"></i></button></td>';
						
						$view_dialog .= '<div class="modal fade" id='.$sub->id.' >
								<div class="modal-dialog modal-lg">
								  <div class="modal-content">
									<div class="modal-header">
    								  <h5 class="modal-title"><span class="badge badge-secondary">Course: </span>'.$sub->course_id.': '.$sub->course_title.'<br/>
    								  <span class="badge badge-secondary">Programme: </span>'.$prog.'<br/>
    								  <span class="badge badge-secondary">Session: </span>'.$session.'</h5>
									  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
										<span aria-hidden="true">&times;</span>
									  </button>
									</div>
									<div class="modal-body">
									
									<table id="example11" class="table table1 table-bordered table-striped" width="100%">
									<thead>
									<tr>
										<th>S/N</th> 
										<th>Registration Number</th>
										<th>Full Name</th>
										<th>CA</th>
										<th>Exam</th>
										<th>Total</th>
										<th>Grade</th>
									</tr>
									</thead>
									<tbody>';
				
									$result = $this->examofficer_model->get_marks($sub->id);
									$index = 1;
									$color = '';
								if(!empty($result)){
									foreach($result as $res){
										if($res->grade == 'F'){
											$color = 'text-danger';
										}

										$view_dialog .= '<tr class="'.$color.'">';
										$view_dialog .= '<td>'.$index++.'</td>';
										$view_dialog .= '<td>'.$res->reg_no.'</td>';
										$view_dialog .= '<td>'.$res->first_name.' '.$res->middle_name.' '.$res->last_name.'</td>';
										$view_dialog .= '<td>'.$res->ca_marks.'</td>';
										$view_dialog .= '<td>'.$res->exam_marks.'</td>';
										$view_dialog .= '<td>'.$res->total_marks.'</td>';
										$view_dialog .= '<td>'.$res->grade.'</td>';
										$view_dialog .= '</tr>';
										$color = '';
									}
									
					}
									
									$view_dialog .="</tbody>
									</table>
									</div>
									</div>
									</div>
									</div>";
					}else{ 
						$output .= '<td><button disabled class="btn btn-info btn-xs"><i class="fas fa-eye"></i></button></td>';
					} 
					$output .= "</tr>";
					
					
				}							
		
				$output .="</tbody>
				</table>
				</div>
				</div>";
			}else{
				$output .= "List of Submissions Here...";
			}
		}else{
			$output .= '<div class="alert alert-danger alert-dismissible">
                  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                  <i class="icon fas fa-exclamation-triangle"></i> No submission yet!
                </div>';
		}
		
	
		echo $output;
		echo $view_dialog;
	}

	public function submission_action(){
	    
	    if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
            /*$error = '';
            $success = '';
            $id = "CSC1211_58_CSC20_2020_2021";*/
		if($this->request->getMethod() == 'post'){
            $error = '';
            $success = '';
			$id = $this->request->getPost("id");
			if($this->request->getPost("action") == 'accept'){
				$data = [
					'eo_status'  => 'Accepted',
				];
				$st = $this->examofficer_model->edit_submission($data, $id);
				if($st){
					$success = "Result submission has been accepted";
				}else{
					$error = "Oops! Something went wrong. Try later.";
				}
    
	            $output = array(
	                'error'		=>	$error,
	                'success'	=>	$success
	            );
            	echo json_encode($output);
			}
			if($this->request->getPost("action") == 'reject'){
				$data = [
					'eo_status'  => 'Rejected',
					'submission_status'  => 'Rejected',
				];
				$st = $this->examofficer_model->edit_submission($data, $id);
				if($st){
					$success = "Result submission has been rejected";
				}else{
					$error = "Oops! Something went wrong. Try later.";
				}
    
	            $output = array(
	                'error'		=>	$error,
	                'success'	=>	$success
	            );
            	echo json_encode($output);
			}
		}
	}

	public function course_submitted($id)
	{
	
	if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
			
			//$id = $this->session->get('programme_id');
			$level = $this->session->get('level')."";
            //$id = str_replace(",", "/", $id);

			//$submission = $this->examofficer_model->get_programme_submitted_result('CSC20', '1st', '2020/2021');
			$data = [
				'page_title' => 'Course Submission',
				'page_subtitle' => '',
				'user' => $this->session->get('name')
			];
					
			$data['course'] =  $this->examofficer_model->get_courses("Computer Science");
			$data['submission'] = $this->examofficer_model->get_marks($id);
			$data['detail'] = $this->examofficer_model->get_course_detail_($id);
			//$data['user'] = $this->session->get('logged_hod');

			echo view('templates/examofficer_header', $data);
			echo view('examofficer/course_submitted');
			echo view('templates/examofficer_footer');
		
	}
	
	public function compute_result()
	{

		if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		$data = [
			'page_title' => 'Compute Result',
			'page_subtitle' => 'Compute Result',
			'user' => $this->session->get('name')
		];

		$session_started = $this->session->get('session_started');
		$data['session_started'] = $session_started;

		$session_collections = [];
		$session_value_collections = [];
        $sess = substr($session_started, 0, 4);
		$year = (int) $sess;
		//echo $sess."/".($year+1);
		for($i = $year; $i < $year + 6; $i++){
			$value = $i."_".($i+1);
			$display = $i."/".($i+1);
			array_push($session_collections, $display);
			array_push($session_value_collections, $value);
		}
		
		//$data['session'] =  $this->examofficer_model->get_session(58);
		$data['session_collections'] = $session_collections;
		$data['session_value_collections'] = $session_value_collections;
		
		return view('examofficer/compute_result', $data);

	}

	// get students bio data
	function get_students_biodata($session)
	{

	}

	public function add_drop()
	{
	
		if($this->request->getMethod() == 'post'){

			if(isset($_POST['add_course'])){
				echo "jhh";
			}else if(isset($_POST['drop_course'])){

			}

		}
	}

	// get semesters available
	function get_semester_submission($session)
	{
	    
	    if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}

		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$staff_no = $this->session->get('id');
		$username = $this->session->get('username');
		$programme = $this->examofficer_model->get_semester($username, $session);
		
		$value = [];
		$output = "";
		if(!empty($programme)){
			$output .= '<div class="form-group">
			<label class="label"><b>Select Semester:</b></label><br/>
			<select class="form-control select2" name="semester" id="semester" onchange="spawn_submission()" required> 
			<option>Semester</option>';
			foreach($programme as $prog){
				$output .= "<option value = ".$prog->semester.">".$prog->semester."</option>";                                            
			}
			$output .= "</select> <i></i><b class='tooltip tooltip-bottom-right'>Labels</b></section>";
		}else{
			$output .= "<br/><br/><h4>There is no result submission for this session</h4>";
		}
					
		echo $output;
	}

	// get semesters available
	function get_semester_available($session)
	{
	    if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}

		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$staff_no = $this->session->get('id');

		$username = $this->session->get('username');
		$programme = $this->examofficer_model->get_semester($username, $session);
		
		$value = [];
		$output = "";
		if(!empty($programme)){
			$output .= '<div class="form-group">
					<label class="label"><b>Select Semester:</b></label>
					<select class="form-control select2" name="semester" id="semester" onchange="spawn_result()" required> 
					<option>Semester</option>';
			foreach($programme as $prog){
				$output .= "<option value = ".$prog->semester.">".$prog->semester."</option>";                                            
			}
			$output .= "</select> <i></i><b class='tooltip tooltip-bottom-right'>Labels</b></section>";
		}else{
			$output .= "<br/><br/><h4>There is no result available for this session</h4>";
		}
					
		echo $output;
	}

	//View list course registrations
	function get_course_registrations($session)
	{
	    if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		
		$session_value = urldecode($session);
		$session = str_replace("_","/",$session_value);
		$id = $this->session->get('programme_id');
		$level = $this->session->get('level');

		$student = $this->examofficer_model->get_registered_students($id, $level, $session);
		$output = "";
		$course_registration_dialog = "";
		$add_course_dialog = "";
		
		if(!empty($session)){

			foreach($student as $stud){
				if($this->examofficer_model->get_registration_status($stud->student_id, $session)){				
					$stud->status = "Registered";
				}else{
					$stud->status = "Not Registered";
				}
			}
			
			$output .= "<div class='row'  >
	
			<div class='col-md-12 table-responsive' > 
			<table id='example1' class='table table-bordered table-striped'>
					<thead>
				   <tr>
						<th>S/N</th> 
						<th>Full Name</th>
						<th>Registration Number</th>
						<th>Status</th>
						<th>Action</th>
						
					  </tr>
			   </thead>
			<tbody>";
			$i = 1;
			foreach($student as $stud){		
				$reg_no = $stud->registration_no;
				$id_value = "#".$stud->registration_no;
				$output .= "<tr><td>".$i."</td>";
				$output .= "<td>".$stud->first_name." ".$stud->middle_name." ".$stud->last_name."</td>";
				$output .= "<td>".$stud->registration_no."</td>";
				$output .= "<td>".$stud->status."</td>";
				if($stud->status == "Not Registered"){ 
					$output .= "<td><button type = 'submit' disabled class='btn btn-success btn-xs rounded-2x' style='background:#2b89c0'><i class='fa fa-eye' disabled></i>View </button></td>";
				}else{ 
					//echo $stud->status;
					$output .= '<td><a href = '.$id_value.'  data-toggle="modal"><button  class="btn btn-success btn-xs rounded-2x" style="background:#2b89c0"><i class="fa fa-eye"></i>View</button></a></td>';
				} 
				$output .= "</tr>";
				$i++;

				$add_dialog_id = "#".$reg_no."_";
				$course_registration_dialog .= '<div class="modal hide fade in" data-backdrop="static" id='.$reg_no.' >
							<div class="modal-dialog modal-xl">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"> <h4 class="modal-title">'.$reg_no.'<br/>'.$stud->first_name.' '.$stud->middle_name.' '.$stud->last_name.'<br/></h4></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body">
								<a href = '.$add_dialog_id.' data-toggle="modal">Add Course</a><br/>
								<br/>
								<table id="example1" class="table table-bordered table-striped">
								<thead>
								<tr>
									<th>S/N</th> 
									<th >Course Code</th>
									<th >Course Title</th>
									<th >Credits Unit</th>
									<th >Semester</th>
									<th >Action</th>
									</tr>
						</thead>
						<tbody>';
								
						$courses = $this->examofficer_model->get_student_courses($reg_no);

						$index = 1;
						foreach($courses as $co){
							$course_registration_dialog .= "<tr><td>".$index++."</td>";
							$course_registration_dialog .= "<td>".$co->course_id."</td>";
							$course_registration_dialog .= "<td>".$co->title."</td>";
							$course_registration_dialog .= "<td>".$co->credit_units."</td>";
							$course_registration_dialog .= "<td>".$co->semester."</td>";
							$course_registration_dialog .= '<td><button type="submit" name = "delete_result" onclick = "return confirm(\'Are you sure you want to Drop this Course?\')"  class="btn btn-success btn-xs rounded-2x" style="background:#2b89c0"><i class="fas fa-trash">Drop Course</i></button></td>';
							$course_registration_dialog .= "</tr>";
						}
								$course_registration_dialog .="
								</tbody>
								</table>
								<div class='modal-footer justify-content-between'>
								<button type='button' class='btn btn-default' data-dismiss=modal'>Close</button>
								
								</div>
								</div>
								</div>
								</div>
								</div>";

								$all_courses = $this->examofficer_model->get_all_courses();
								$reg_value = $reg_no."_";
								$add_course_dialog .= '<div  id='.$reg_value.' class="modal hide fade in" data-backdrop="static">
							<div class="modal-dialog modal-lg">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"> <h4 class="modal-title"><br/><br/></h4></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body">

								<p><div class="form-group">
								<input type = "text" value = '.$reg_no.' hidden>
              <label class="label"><b>Select Semester:</b></label><br/>
			  <select class="form-control select2" style="width: 100%;" name="semester" id="sessionField" onchange = "spawn_allocated_courses_upload()" required>
			  <option selected="selected" value="">Select Semester</option>                   
			  <option value = "1st">1st</option>
			  <option value = "2nd">2nd</option>
			  </select>
				</div>
				</p>
				<p><div class="form-group">
						<label class="label"><b>Select Course:</b></label><br/>
						<select class="form-control select2" style="width: 100%;" name="course" id="sessionField" onchange = "spawn_allocated_courses_upload()" required>
						<option selected="selected" value="">Select Course</option> '; 
						
						foreach($all_courses as $co){
							$add_course_dialog .= '<option value = '.$co->id.'>'.$co->id.'  '.$co->title.'  '.$co->credit_unit.'</option>';
						}                 
						$add_course_dialog .= '</select>
							</div>
							</p>
								';
								
								$add_course_dialog .="
								
								<div class='modal-footer justify-content-between'>
								<button type='button' class='btn btn-default' data-dismiss=modal'>Close</button>
								<button type='submit' name = 'add_course' class='btn btn-primary'>Save Course</button>
								</div>
								</div>
								</div>
								</div>
								</div>";

			}							
	
			$output .="</tbody>
			</table>
			</div>
			</div>";


		}else{
			$output .= "List of Course Registrations Here...";
		}
	
		echo $output;
		echo $course_registration_dialog;
		echo $add_course_dialog;
	}

	//View list of submitted result
	function get_result_submitted($semester, $session)
	{
	    if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}
		
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$semester = urldecode($semester);
		$programme_id = $this->session->get("programme_id");
		$username = $this->session->get('username');
		$year_admitted = substr($username, 3, 2);
		$year_admitted = (int) "20".$year_admitted;
		$level = (int) substr($session, 0, 4) - $year_admitted + 100;
		
		$program_details = $this->examofficer_model->get_program_detail($programme_id);
		$output = "";
		$view_dialog = "";
		if(!empty($semester)){
			$submission = $this->examofficer_model->get_submission_instance($programme_id, $session, $semester, $level, $program_details['ccode']);

			foreach($submission as $sub){
				$status = $this->examofficer_model->get_submission_status_($sub->course_id, $username, $session);
				if($status){				
					$sub->status = "Submitted";
					$sub->submission_id = $status['id'];
					//$sub->result_id = $status['id'];
				}else{
					$sub->status = "Not Submitted";
				}
			}

			foreach($submission as $sub){
				$details = $this->hod_model->get_staff_details($sub->lecturer_id);
				$sub->lecturer = $details['name']; 
			}
			
			$output .= "<div class='row'>
	
			<div class='col-md-12 table-responsive' > 
			<table id='example1' class='table table-bordered table-striped'>
					<thead>
				   <tr>
						<th>S/N</th> 
						<th>Course Code</th>
						<th>Course Title</th>
						<th>Lecturer</th>
						<th>Status</th>
						<th>Action</th>
						
					  </tr>
			   </thead>
			<tbody>";
			$i = 1;
			foreach($submission as $sub){	
				
				$output .= "<tr><td>".$i++."</td>";
				$output .= "<td>".$sub->course_id."</td>";
				$output .= "<td>".$sub->title."</td>";
				$output .= "<td>".$sub->lecturer."</td>";
				$output .= "<td>".$sub->status."</td>";
				if($sub->status == "Not Submitted"){ 
					$output .= '<td><button disabled class="btn btn-success btn-xs rounded-2x" style="background:#2b89c0" data-toggle="modal" ><i class="fas fa-eye">View</i></button></td>';
				}else{ 

					$id_value = "#".$sub->submission_id;
					$output .= '<td><a class="btn btn-success btn-xs rounded-2x" style="background:#2b89c0" href = '.$id_value.' data-toggle="modal" ><i class="fas fa-eye">View</i></a></td>';
					
					$view_dialog .= '<div class="modal fade" id='.$sub->submission_id.' >
							<div class="modal-dialog modal-lg">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"> <h4 class="modal-title">'.$sub->course_id.'<br/>'.$sub->title.'<br/>'.$session.'</h4></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body">
								
								<table id="example1" class="table table-bordered table-striped">
								<thead>
								<tr>
									<th>S/N</th> 
									<th style="width:15%" >Registration Number</th>
									<th style="width:45%" >Full Name</th>
									<th>CA</th>
									<th>Exam</th>
									<th>Total</th>
									<th>Grade</th>
								</tr>
								</thead>
								<tbody>';
			
								$result = $this->lecturer_model->get_marks($sub->submission_id);
								$index = 1;
								$color = '';
							if(!empty($result)){
								foreach($result as $res){
									if($res->grade == 'F'){
										$color = 'text-danger';
									}

									$view_dialog .= '<tr class="'.$color.'">';
									$view_dialog .= '<td>'.$index++.'</td>';
									$view_dialog .= '<td>'.$res->reg_no.'</td>';
									$view_dialog .= '<td>'.$res->first_name.' '.$res->middle_name.' '.$res->last_name.'</td>';
									$view_dialog .= '<td>'.$res->ca_marks.'</td>';
									$view_dialog .= '<td>'.$res->exam_marks.'</td>';
									$view_dialog .= '<td>'.$res->total_marks.'</td>';
									$view_dialog .= '<td>'.$res->grade.'</td>';
									$view_dialog .= '</tr>';
									$color = '';
								}
								
				}
								
								$view_dialog .="</tbody>
								</table>
								</div>
								</div>
								</div>
								</div>";

				} 
				$output .= "</tr>";
				
				
			}							
	
			$output .="</tbody>
			</table>
			</div>
			</div>";
		}else{
			$output .= "List of Submmission";
		}
		
	
		echo $output;
		echo $view_dialog;
	}

	// get semesters available
	function get_result($semester, $session)
	{
	    
	    if(!session()->has('examofficer_logged')){
			return redirect()->to(base_url()."/exam-login");	
		}

		$id = $this->session->get('programme_id');
		$semester = urldecode($semester);
		$session = urldecode($session);
		$session = str_replace("_","/",$session);
		$programme_id = $this->session->get('programme_id');
		$username = $this->session->get('username');
		$year_admitted = substr($username, 3, 2);
		$year_admitted = (int) "20".$year_admitted;
		$level = (int) substr($session, 0, 4) - $year_admitted + 100;
		
		$programme = $this->examofficer_model->get_semester($programme_id, $session);
		$submission = $this->examofficer_model->get_submission_instance_result($programme_id, $session, $semester, $level);
		
		$course = $this->examofficer_model->get_submitted_result_semester($id, $username, $semester, $session);
		$student = $this->examofficer_model->get_students($id, $level);

		foreach($student as $stud){
			foreach($course as $co){
				$mark = $this->examofficer_model->get_student_marks($stud->registration_no, $co->id);
				$name = $co->course_id;
				if($mark){					
					$stud->$name = $mark['total_marks'];
				}else{
					$stud->$name = "";
				}
			}
		}
				
		$value = [];
		$output = "";
		$raw_marks_dialog = "";
		$summary_dialog = "";
		$submission_status = "";
		foreach($submission as $sub){
			if($this->examofficer_model->get_submission_status($sub->course_id, $username, $session)){				
				$submission_status = true;
			}else{
				$submission_status = false;
				break;
			}
		}

		if($semester == '1st'){

			foreach($student as $stud){
				$tcr = 0;
				$tce = 0;
				$tp = 0;
				$carry_over = "";
				$remark = "";
				//$tcr = $this->examofficer_model->get_total_credits($stud->student_id)['total_credits'];
				
				foreach($course as $co){ 
					$mark = $this->examofficer_model->get_student_marks($stud->registration_no, $co->id);
					$name = $co->course_id;

					$course_detail = $this->examofficer_model->get_course_detail($name);
					
					if($mark){		
						//$tcr += $course_detail['credit_unit'];					
						if($mark['total_marks'] == 'ABS'){
							$tcr += $course_detail['credit_unit'];
							$tp += 0 * $course_detail['credit_unit'];
							$carry_over .= $name.", ";
							$remark .= "ABS in: ".$name;
						}else if($mark['total_marks'] >= 40){
							$tcr += $course_detail['credit_unit'];
							$tce += $course_detail['credit_unit'];
							if($mark['grade'] == 'A'){
								$tp += 5 * $course_detail['credit_unit'];	
							}else if($mark['grade'] == 'B'){
								$tp += 4 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'C'){
								$tp += 3 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'D'){
								$tp += 2 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'E'){
								$tp += 1 * $course_detail['credit_unit'];
							}													
						}else if($mark['total_marks'] < 40){
							$tcr += $course_detail['credit_unit'];
							$tp += 0 * $course_detail['credit_unit'];
							$carry_over .= $name.", ";
						}else if($mark['total_marks'] == "ABS"){
							
						}else if($mark['total_marks'] == "I"){

						}
					}
					
				}
				$stud->tce = $tce;
				$stud->tcr = $tcr;	
				$gpa = (double) $tp/$tcr;
				$stud->gpa = round($gpa, 2);
				//if($gpa < 1.00)
					//$remark .= "<br/>On Probarion";
				$stud->carry_over = $carry_over;
				$stud->remark = $remark;
			}

		}else if($semester == '2nd'){


			$overall_courses = $this->examofficer_model->get_overall_courses($id, $this->session->get('username'));
		
			foreach($student as $stud){
				$tcr = 0;
				$tce = 0;
				$tp = 0;

				$overall_tcr = 0;
				$overall_tce = 0;
				$overall_tp = 0;

				$carry_over = "";
				$remark = "";
				//$tcr = $this->examofficer_model->get_total_credits($stud->student_id)['total_credits'];
				
				// Calculate Semester GPA
				foreach($course as $co){ 
					$mark = $this->examofficer_model->get_student_marks($stud->registration_no, $co->id);
					$name = $co->course_id;
					$course_detail = $this->examofficer_model->get_course_detail($name);
					
					
					if($mark){		
						//$tcr += $course_detail['credit_unit'];					
						if($mark['total_marks'] == 'ABS'){
							$tcr += $course_detail['credit_unit'];
							$tp += 0 * $course_detail['credit_unit'];
							$carry_over .= $name.", ";
							$remark .= "ABS in: ".$name;
						}else if($mark['total_marks'] >= 40){
							$tcr += $course_detail['credit_unit'];
							$tce += $course_detail['credit_unit'];
							if($mark['grade'] == 'A'){
								$tp += 5 * $course_detail['credit_unit'];	
							}else if($mark['grade'] == 'B'){
								$tp += 4 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'C'){
								$tp += 3 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'D'){
								$tp += 2 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'E'){
								$tp += 1 * $course_detail['credit_unit'];
							}													
						}else if($mark['total_marks'] < 40){
							$tcr += $course_detail['credit_unit'];
							$tp += 0 * $course_detail['credit_unit'];
							$carry_over .= $name.", ";
						}else if($mark['total_marks'] == "ABS"){
							
						}else if($mark['total_marks'] == "I"){

						}
					}
					
				}
				// Calculate CGPA
				foreach($overall_courses as $co){ 
					$mark = $this->examofficer_model->get_student_marks($stud->registration_no, $co->id);
					$name = $co->course_id;
					$course_detail = $this->examofficer_model->get_course_detail($name);
					
					
					if($mark){		
						//$tcr += $course_detail['credit_unit'];					
						if($mark['total_marks'] == 'ABS'){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tp += 0 * $course_detail['credit_unit'];
							$carry_over .= $name.", ";
							$remark .= "ABS in: ".$name;
						}else if($mark['total_marks'] >= 40){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tce += $course_detail['credit_unit'];
							if($mark['grade'] == 'A'){
								$overall_tp += 5 * $course_detail['credit_unit'];	
							}else if($mark['grade'] == 'B'){
								$overall_tp += 4 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'C'){
								$overall_tp += 3 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'D'){
								$overall_tp += 2 * $course_detail['credit_unit'];
							}else if($mark['grade'] == 'E'){
								$overall_tp += 1 * $course_detail['credit_unit'];
							}													
						}else if($mark['total_marks'] < 40){
							$overall_tcr += $course_detail['credit_unit'];
							$overall_tp += 0 * $course_detail['credit_unit'];
							//$carry_over .= $name.", ";
						}else if($mark['total_marks'] == "ABS"){
							
						}else if($mark['total_marks'] == "I"){

						}
					}
					
				}

				$stud->tce = $tce;
				$stud->tcr = $tcr;
				$gpa = 	(double) $tp/$tcr;
				$cgpa = (double) $overall_tp/$overall_tcr;
				$stud->gpa = round($gpa, 2);
				$stud->cgpa = round($cgpa, 2);
				if($cgpa < 1.00){
					$remark .= "<br/>On Probarion";
				}
					
				$stud->carry_over = $carry_over;
				$stud->remark = $remark;
			}
		}
		if($submission_status){
			
			$output .= '<div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
				<div class="form-group">
					<div class="form-line">
					<a href = "#raw_marks"  data-toggle="modal"><button  name = "raw_marks" class="btn btn-primary btn-lg" ><span class="glyphicon glyphicon-cloud-download"></span> View Raw Marks</button></a>
					</div>
				</div>
				<div class="form-group">
					<div class="form-line">
					<a href = "#summary"  data-toggle="modal"><button class="btn btn-primary btn-lg" ><span class="glyphicon glyphicon-cloud-download"></span> View Summary</button></a>
					</div>
				</div>
				</div>';

				$raw_marks_dialog .= '<div class="modal fade" id="raw_marks" >
							<div class="modal-dialog modal-xl">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"> <h4 class="modal-title"><br/><br/></h4></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body">
								<table id="example1" class="table table-bordered table-striped">
								<thead>
								<tr>
									<th>S/N</th> 
									<th >Registration Number</th>
									<th >Full Name</th>
									';
									foreach($course as $co): 
										$raw_marks_dialog .= '<th>'.$co->course_id.'</th>';
									endforeach;
									
									$raw_marks_dialog .= '</tr>
						</thead>
						<tbody>
								';
								$i = 1;
								foreach($student as $res){
									$raw_marks_dialog .= '<td>'.$i++.'</td>';
									$raw_marks_dialog .= '<td>'.$res->registration_no.'</td>';
									$raw_marks_dialog .= '<td>'.$res->first_name.' '.$res->middle_name.' '.$res->last_name.'</td>';
									foreach($course as $co){
										$course_id = $co->course_id;
										$raw_marks_dialog .= '<td>'.$res->$course_id.'</td>';
									}
									$raw_marks_dialog .= '</tr>';
								}
								
								$raw_marks_dialog .="
								</tbody>
								</table>
								<div class='modal-footer justify-content-between'>
								<button type='button' class='btn btn-default' data-dismiss=modal'>Close</button>
								<button type='submit' name = 'edit_result' class='btn btn-primary'>Save Changes</button>
								</div>
								</div>
								</div>
								</div>
								</div>";

								$summary_dialog .= '<div class="modal fade" id="summary" >
							<div class="modal-dialog modal-xl">
							  <div class="modal-content">
								<div class="modal-header">
								  <h4 class="modal-title"> <h4 class="modal-title"><br/><br/></h4></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span>
								  </button>
								</div>
								<div class="modal-body">
								<table id="example1" class="table table-bordered table-striped">
								<thead>
								<tr>
									<th>S/N</th> 
									<th >Registration Number</th>
									<th >Full Name</th>
									<th >TCR</th>
									<th >TCE</th>
									<th >GPA</th>';
									if($semester == '2nd'):
										$summary_dialog .= '<th >GPA</th>';
									endif; 
									$summary_dialog .= '
									<th>Course(s) to carry over</th>
                                    <th>Remarks</th>
									</tr> 
									</thead>
									<tbody>';
								
									$i = 0;
									foreach($student as $res):
										$summary_dialog .= '<tr>';
										$summary_dialog .= '<td>'.$i++.'</td>';
										$summary_dialog .= '<td>'.$res->registration_no.'</td>';
										$summary_dialog .= '<td>'.$res->first_name.' '.$res->middle_name.' '.$res->last_name.'</td>';
										$summary_dialog .= '<td>'.$res->tcr.'</td>';
										$summary_dialog .= '<td>'.$res->tce.'</td>';
										$summary_dialog .= '<td>'.$res->gpa.'</td>';
										if($semester == '2nd'){
											$summary_dialog .= '<td>'.$res->cgpa.'</td>';
										}
										$summary_dialog .= '<td>'.$res->carry_over.'</td>';
										$summary_dialog .= '<td>'.$res->remark.'</td>';
									endforeach;
								$summary_dialog .="
								</tbody>
								</table>
								<div class='modal-footer justify-content-between'>
								<button type='button' class='btn btn-default' data-dismiss=modal'>Close</button>
								<button type='submit' name = 'edit_result' class='btn btn-primary'>Save Changes</button>
								</div>
								</div>
								</div>
								</div>
								</div>";

								

		}else{
			$output .= "<br/><br/><strong><h4>The Lecturers did not make full submission</h4></strong>";
		}
					
		echo $output;
		echo $raw_marks_dialog;
		echo $summary_dialog;
	}		
}