<?php

namespace App\Models;

use CodeIgniter\Model;

class StudentModel extends Model
{
  public function get_hashed_password($email)
  {
    $builder = $this->db->table('students');
    $query   = $builder->getWhere(['email' => $email]);
    $row = $query->getRow();
    if($row){
      return $row->password;
    }else{
      return '';
    }
  }

  public function check_login($email)
	{
    $builder = $this->db->table('students');
    $builder->getWhere(['email' => $email]);
		return $builder->countAllResults();
	}

  public function get_tutorial($id)
  {
    $builder = $this->db->table('tutorials');
    $query   = $builder->getWhere(['id' => $id]);
    return $query->getRow();
  }

  public function get_quiz($id)
  {
    $builder = $this->db->table('quizzes');
    $query = $builder->getWhere(['id' => $id]);
    return $query->getRow();
  }

  public function get_quiz_questions($id)
  {
    $builder = $this->db->table('quiz_options');
    $query = $builder->getWhere(['quiz' => $id]);
    return $query->getResult();
  }

  public function update_password($new_password)
  {
    $builder = $this->db->table('students');
    $builder->set('password', $new_password);
    $builder->where('email', $_SESSION['current_student']);
    return $builder->update();
  }

  public function update_profile($name)
  {
    $builder = $this->db->table('students');
    $builder->set('name', $name);
    $builder->where('email', $_SESSION['current_student']);
    return $builder->update();
  }

  public function get_student_details($email)
  {
    $builder = $this->db->table('students');
    $query   = $builder->getWhere(['email' => $email]);
    return $query->getRow();
  }

  public function check_request($email)
	{
    $builder = $this->db->table('tutor_requests');
    $builder->like(['student' => $email]);
		return $builder->countAllResults();
	}

  public function submit_request($data)
	{
    $this->db->table('tutor_requests')->insert($data);
	}

  public function get_tutor()
  {
    $builder = $this->db->table('tutor_requests');
    $query   = $builder->getWhere(['student' => $_SESSION['current_student']]);
    return $query->getRow();
  }

  public function save_message($data)
	{
      $this->db->table('messenger')->insert($data);
	}

  public function get_messages()
  {
    $builder = $this->db->table('messenger');
    $query = $builder->getWhere(['student' => $_SESSION['current_student']]);
    $builder->orderBy('id', 'DESC');
    return $query->getResult();
  }

}
