<?= $this->extend("templates/lecturer_base"); ?>

<?= $this->section("content"); ?>
<?php $page_session = \Config\Services::session(); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?= base_url()?>/lecturer/dashboard">Home</a></li>
              <li class="breadcrumb-item active">Mark Attendance</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        
        <div class="row">
          <!-- Left col -->
          <div class="col-12">
            <!-- MAP & BOX PANE -->
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Select criteria to mark attendance</h3>
                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-widget="collapse">
                    <i class="fa fa-minus"></i>
                  </button>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <form method="POST" action="<?= base_url('lecturer/attendance') ?>">
                    <input type="hidden" name="action" value="search"/>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                          <label>Course</label>
                          <select class="form-control select2" style="width: 100%;" name="course" aria-hidden="true" required>
                            <option selected disabled value="">- Select Course -</option>
                            <?php
                                foreach($courses as $row){
                            ?>
                            <option value="<?=$row->id?>" <?=set_value('course')==$row->id ? 'selected' : ''?>><?=$row->id.": ".$row->title?></option>
                            <?php }?>
                          </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                          <label>Attendance Date</label>
                          <input type="date" class="form-control datepicker" name="attdate" value="<?=set_value('attdate')?>" required/>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12" align="right">
                        <button class="btn btn-sm btn-primary" type="submit"><i class="fas fa-search"></i> Search</button>
                    </div>
                </div>
                </form>
                </hr>
                <br/>
                </hr>
                <?php 
                    if(isset($resultlist) && $resultlist != ''){
                        if($resultlist){
                ?>
                <form method="POST">
                    <input type="hidden" name="course" value="save"/>
                    <input type="hidden" name="date" value="save"/>
                    <input type="hidden" name="action" value="save"/>
                <div class="row">
                    <div class="col-6">
                        <?php
                            if($att != ''){
                                echo $att;
                            }
                        ?>
                    </div>
                    <div class="col-6 pull-right" align="right">
                        <button class="btn btn-sm btn-primary submit_button" type="button" id="submit_button1" name="save"><i class="fas fa-save"></i> Save Attendance</button>
                    </div>
                <div class="col-12 table-responsive">
                  <table class="table table-hover table-striped" cellspacing="0" style="width: 100%;" >
                    <thead>
                      <tr>
                        <th>#</th>
                        <th>Registration No.</th>
                        <th>Name</th>
                        <th>Level</th>
                        <th>Attendance</th>
                      </tr>
                    </thead>
                    <tbody>
                        <?php 
                            $i = 0;
                            foreach($resultlist as $row){
                        ?>
                        <tr>
                            <td><?=++$i?></td>
                            <td><?=$row->registration_no?></td>
                            <td><?=$row->first_name.' '.$row->middle_name.' '.$row->last_name?></td>
                            <td><?=$row->level?></td>
                            <td>
                                <div class="form-group clearfix">
                                  <div class="icheck-success d-inline">
                                    <input type="radio" id="present_<?=$row->student_id?>" name="att_<?=$row->student_id?>" checked>
                                    <label for="present_<?=$row->student_id?>">
                                        Present &nbsp;&nbsp;&nbsp;
                                    </label>
                                  </div>
                                  <div class="icheck-danger d-inline">
                                    <input type="radio" id="absent_<?=$row->student_id?>" name="att_<?=$row->student_id?>">
                                    <label for="absent_<?=$row->student_id?>">
                                        Absent
                                    </label>
                                  </div>
                                </div>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                  </table>
                </div>
                    <div class="col-12 pull-right" align="right">
                        <!--<div class="col-12">-->
                            <button class="btn btn-sm btn-primary submit_button" type="button" id="submit_button2" name="save"><i class="fas fa-save"></i> Save Attendance</button>
                        <!--</div>-->
                    </div>
                </div>
                </form>
                <?php }else{ ?>
                    <div class="alert alert-danger alert-dismissible">
                        <h5><i class="icon fas fa-ban"></i> Alert!</h5>
                        No students registered for the selected course
                    </div>
                <?php } } ?>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
      </div>
    </section>
  </div>

<?= $this->endSection(); ?>