<?= $this->extend("templates/lecturer_base"); ?>

<?= $this->section("content"); ?>
<?php $page_session = \Config\Services::session(); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?= base_url()?>/lecturer/dashboard">Home</a></li>
              <li class="breadcrumb-item active">Dashboard</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">   
        <div class="row">
          <div class="col-md-12">
            <div class="timeline">
              <div class="time-label">
                <span class="bg-info">Dashboard</span>
              </div>
              <div>
                <i class="fas fa-user bg-blue"></i>
                <div class="timeline-item">
                  <h3 class="timeline-header">Account Info: </h3>
                  <div class="timeline-body">
                      <div class="row">
                          <div class="col-md-3">
                              <div class="widget-user-image">
                                <img class="img-circle elevation-2" src="<?= base_url("/../assets/img/avatar.png")?>" alt="User Avatar" width="150" height="150">
                              </div>
                          </div>
                          <div class="col-md-9">
                              <table>
                                  <tr>
                                      <td align="right"><strong>Name: &nbsp;&nbsp;</strong></td>
                                      <td align="left"><h5><?= $page_session->get('name'); ?></h5></td>
                                  </tr>
                                  <tr>
                                      <td align="right"><strong>Staff No.: &nbsp;&nbsp;</strong></td>
                                      <td align="left"><h5><?= $page_session->get('staff_id'); ?></h5></td>
                                  </tr>
                                  <tr>
                                      <td align="right"><strong>Rank: &nbsp;&nbsp;</strong></td>
                                      <td align="left"><h5><?= $page_session->get('rank'); ?></h5></td>
                                  </tr>
                                  <tr>
                                      <td align="right"><strong>Email: &nbsp;&nbsp;</strong></td>
                                      <td align="left"><h5><?= $page_session->get('email'); ?></h5></td>
                                  </tr>
                                  <tr>
                                      <td align="right"><strong>Department: &nbsp;&nbsp;</strong></td>
                                      <td align="left"><h5><?= $page_session->get('department'); ?></h5></td>
                                  </tr>
                                  <tr>
                                      <td align="right"><strong>Faculty.: &nbsp;&nbsp;</strong></td>
                                      <td align="left"><h5><?= $page_session->get('faculty'); ?></h5></td>
                                  </tr>
                              </table>
                          </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        
        <div class="row">
          <!-- Left col -->
          <div class="col-12">
            <!-- MAP & BOX PANE -->
            <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Course Allocations and Number of Students Registered for <?= $page_session->get('current_session'); ?> Academic Session</h3>
                <div class="card-tools">
                  <button type="button" class="btn btn-tool" data-widget="collapse">
                    <i class="fa fa-minus"></i>
                  </button>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="table-responsive">
                  <table id="lecturer" class="table table-bordered table-striped" cellspacing="0" width="100%">
                    <thead>
                      <tr>
                        <th>#</th>
                        <th>Course Code/Title</th>
                        <th>Level</th>
                        <th>Semester</th>
                        <th>Programmes (Enrolment)</th>
                      </tr>
                    </thead>
                    <tbody>
                        <?php 
                            $i = 0;
                            if(!empty($list)):
                            foreach($list as $row){
                        ?>
                        <tr>
                            <td><?=++$i?></td>
                            <td><?=$row->id?>:<br/><?=$row->title?></td>
                            <td><?=$row->level?></td>
                            <td><?=$row->semester?></td>
                            <?php 
                  						$programmes_array = explode(",", $row->programmes_allocated_to);
                  						$array_lenth = count($programmes_array);
                  						$counter = 1;
                  						$output = '';
                  						foreach($programmes_array as $prog){
                  							$programme_id = $lecturer_model->get_programme_detail_by_ccode($prog);
                  							$students_enrollemnt = $lecturer_model->get_enrolled_students($programme_id['id'], $row->id, $page_session->get('current_session'));
                  							
          		                  $cnt = $students_enrollemnt == false ? 0 : count($students_enrollemnt);
                                
                  							if($array_lenth == $counter){
                  								$output .= "<span class='badge badge-dark' style='font-size:12px'>".$prog." - ".$cnt."</span>";
                  							}else{
                  								$output .= "<span class='badge badge-dark' style='font-size:12px'>".$prog." - ".$cnt."</span><br/> ";
                  							}
                  							$counter++;
                  						}
                            ?>
                            <td><?=$output?></td>
                        </tr>
                        <?php }
                        endif;
                         ?>
                    </tbody>
                  </table>
                </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
      </div>
    </section>
  </div>

<?= $this->endSection(); ?>