<!DOCTYPE html>
<html lang="en">
<head>
<?php $page_session = \Config\Services::session(); ?>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?= base_url("/../assets/img/yumsuk_logo.png");?>" type="image/x-icon">
  <title>Level Coordinator | <?= $page_title ?> | <?= $page_subtitle ?></title>

  <!-- Google Font: Source Sans Pro -->
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/fontawesome-free/css/all.min.css"); ?>">
  <!-- daterange picker -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/daterangepicker/daterangepicker.css");?>">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?= base_url("/.../assets_/plugins/icheck-bootstrap/icheck-bootstrap.min.css")?>">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css")?>">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css")?>">
  <!-- Toastr -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/toastr/toastr.min.css")?>">
  <!-- Sweet Alert -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/sweetalert2/sweetalert2.min.css")?>">
  <!-- Select2 -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/select2/css/select2.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css")?>">
  <!-- Bootstrap4 Duallistbox -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css")?>">
  <!-- BS Stepper -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bs-stepper/css/bs-stepper.min.css")?>">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/dropzone/min/dropzone.min.css")?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/dist/css/adminlte.min.css")?>">

  <!-- DataTables -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-responsive/css/responsive.bootstrap4.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-buttons/css/buttons.bootstrap4.min.css")?>">

  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/icheck-bootstrap/icheck-bootstrap.min.css")?>">
  <style type="text/css">
		.loader-div {
			display: none;
			position: fixed;
			margin: 0px;
			padding: 0px;
			right: 0px;
			top: 0px;
			width: 100%;
			height: 100%;
			background-color: #fff;
			z-index: 30001;
			opacity: 0.8;
		}
		.loader-img {
			position: absolute;
			top: 0;
			bottom: 0;
			left: 0;
			right: 0;
			margin: auto;
		}
	</style>
</head>
<body class="text-sm hold-transition sidebar-mini" >
    <div class="loader-div">
    <img class="loader-img" src="<?= base_url("/../assets/img/ajax-loader.gif")?>" style="height: 120px;width: auto;" />
</div> 
<div class="wrapper">
  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?= base_url(); ?>/levelcoordinator/dashboard" class="nav-link">Home</a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?= base_url(); ?>/levelcoordinator/logout" class="nav-link">Logout</a>
      </li>
    </ul>
    
    <!-- Right navbar links -->
   <ul class="navbar-nav ml-auto">

      <li class="nav-item dropdown user-menu">
        <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
          <img src="<?= base_url("/../assets/img/avatar.png")?>" class="user-image img-circle elevation-2" alt="User Image">
          <span class="d-none d-md-inline"><?= $page_session->get('programme_name'); ?></span>
        </a>
        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
          <!-- User image -->
          <li class="user-header bg-primary">
            <img src="<?= base_url("/../assets/img/avatar.png")?>" class="img-circle elevation-2" alt="User Image">
            <p>
              Level <?= $page_session->get('level') ?> Coordinator for: 
              <small><?= $page_session->get('programme_name'); ?></small>
            </p>
          </li>
          <!-- Menu Footer-->
          <li class="user-footer">
            <a href="#" class="btn btn-default btn-flat">Profile</a>
            <a href="<?= base_url()?>/lev-logout" class="btn btn-default btn-flat float-right">logout</a>
          </li>
        </ul>
      </li>
    </ul>
  </nav>
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="#" class="brand-link">
      <img src="<?= base_url("/../assets/img/avatar.png")?>" alt="RPS Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
      <span class="brand-text font-weight-light">YUMSUK RPS</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
      <!-- Sidebar user (optional) -->
      <div class="user-panel mt-3 pb-3 mb-3 d-flex text-center">
        
        <div class="info">
          <a href="#" class="d-block">Level <?= $page_session->get('level') ?> Coordinator for: <br/><?= $page_session->get('programme_name') ?></a>
        </div>
      </div>
        <div class="user-panel mb-3 d-flex" style="background-color: #000000;">
          <div class="info">
            <a href="javascript:void(0);"><?php echo "Current Session: ".$page_session->get('current_session'); ?></a>
            <br/>
          </div>
        </div>


      <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
         
		  <li class="nav-item">
            <a href="<?= base_url(); ?>/lev-index" class="nav-link <?php echo ($page_title=='Dashboard')?'active':'' ?>">
              <i class="nav-icon fas fa-tachometer-alt"></i>
              <p>
                Dashboard
                </p>
            </a>
          </li>
          
          
          
          <li class="nav-item <?php echo ($page_title=='My Students')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='My Students')?'active':'' ?>">
              <i class="nav-icon fas fa-user"></i>
              <p>
              My Students
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url(); ?>/lev-students" class="nav-link <?php echo ($page_subtitle=='View My Students')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>View My Students</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url(); ?>/lev-transfer" class="nav-link <?php echo ($page_subtitle=='Transfer Students')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Transfer Students</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url(); ?>/lev-registrations" class="nav-link <?php echo ($page_subtitle=='Course Registrations')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Course Registrations</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url(); ?>/lev-enrollments" class="nav-link <?php echo ($page_subtitle=='Course Enrollments')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Course Enrollments</p>
                </a>
              </li>
              
              
            </ul>
          </li>

          <li class="nav-item <?php echo ($page_title=='Exam Results')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='Exam Results')?'active':'' ?>">
              <i class="nav-icon fas fa-chart-bar"></i>
              <p>
              Exam Results
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url(); ?>/lev-submissions" class="nav-link <?php echo ($page_subtitle=='Lecturers Submission')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>View Submissions</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url(); ?>/lev-results" class="nav-link <?php echo ($page_subtitle=='Results')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Results</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url(); ?>/lev-reports" class="nav-link <?php echo ($page_subtitle=='Report')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Session Report</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url(); ?>/lev-verify" class="nav-link <?php echo ($page_subtitle=='Verification')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Verification</p>
                </a>
              </li>
              
              
            </ul>
          </li>
 
          <li class="nav-item <?php echo ($page_title=='Settings')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='Settings')?'active':'' ?>">
              <i class="nav-icon fas fa-cog"></i>
              <p>
                Settings
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url(); ?>/lev-configurations" class="nav-link <?php echo ($page_subtitle=='Configurations')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Change Configurations</p>
                </a>
              </li>
              
            </ul>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url(); ?>/lev-password" class="nav-link <?php echo ($page_subtitle=='Change Password')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Change Password</p>
                </a>
              </li>
              
            </ul>
          </li>

          <li class="nav-item">
            <a href="<?= base_url(); ?>/lev-logout" class="nav-link">
              <i class="nav-icon fas fa-sign-out-alt"></i>
              <p>
                Logout
                </p>
            </a>
          </li>
          
        </ul>
      </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside>

  <?= $this->renderSection("content"); ?>
              
            <!-- /.card -->
          </div>
        </div>
        <!-- /.row -->
        
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="float-right d-none d-sm-block">
        Powered by the Directorate of ICT and Department of Computer Science.
        &nbsp; &nbsp; &nbsp; &nbsp; 
        <b>Version</b> 1.0
    </div>
    Copyright &copy; <?= "2022-".date("Y") ?> <a href="http://www.yumsuk.edu.ng">Yusuf Maitama Sule University, Kano</a>. All rights
    reserved.
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="<?= base_url("/../assets_/plugins/jquery/jquery.min.js");?>"></script>
<!-- Bootstrap 4 -->
<script src="<?= base_url("/../assets_/plugins/bootstrap/js/bootstrap.bundle.min.js");?>"></script>
<!-- Toastr -->
<script src="<?= base_url("/../assets_/plugins/toastr/toastr.min.js")?>"></script>
<!-- Sweet Alert -->
<script src="<?= base_url("/../assets_/plugins/sweetalert2/sweetalert2.min.js")?>"></script>
<!-- Select2 -->
<script src="<?= base_url("/../assets_/plugins/select2/js/select2.full.min.js");?>"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="<?= base_url("/../assets_/plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js");?>"></script>
<!-- InputMask -->
<script src="<?= base_url("/../assets_/plugins/moment/moment.min.js")?>"></script>
<script src="<?= base_url("/../assets_/plugins/inputmask/jquery.inputmask.min.js");?>"></script>
<!-- date-range-picker -->
<script src="<?= base_url("../assets_/plugins/daterangepicker/daterangepicker.js");?>"></script>
<!-- bootstrap color picker -->
<script src="<?= base_url("/../assets_/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js");?>"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="<?= base_url("/../assets_/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js");?>"></script>
<!-- Bootstrap Switch -->
<script src="<?= base_url("/../assets_/plugins/bootstrap-switch/js/bootstrap-switch.min.js");?>"></script>
<!-- BS-Stepper -->
<script src="<?= base_url("/../assets_/plugins/bs-stepper/js/bs-stepper.min.js");?>"></script>
<!-- dropzonejs -->
<script src="<?= base_url("/../assets_/plugins/dropzone/min/dropzone.min.js");?>"></script>
<!-- AdminLTE App -->
<script src="<?= base_url("/../assets_/dist/js/adminlte.min.js");?>"></script>
<!-- AdminLTE for demo purposes -->
<script src="<?= base_url("/../assets_/dist/js/demo.js");?>"></script>
<!-- jquery-validation -->
<script src="<?= base_url("/../assets_/plugins/jquery-validation/jquery.validate.min.js");?>"></script>
<script src="<?= base_url("/../assets_/plugins/jquery-validation/additional-methods.min.js");?>"></script>
<!-- Page specific script -->

<!-- DataTables  & Plugins -->
<script src="<?= base_url("/../assets_/plugins/datatables/jquery.dataTables.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-responsive/js/dataTables.responsive.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/dataTables.buttons.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/jszip/jszip.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/pdfmake/pdfmake.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/pdfmake/vfs_fonts.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.html5.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.print.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.colVis.min.js"); ?>"></script>

  <!-- Custom scripts for all pages-->
<script src="<?= base_url("/../assets/js/sb-admin-2.min.js"); ?>"></script>

<!-- Toastr -->
<script src="<?= base_url("/../assets/plugins/toastr/toastr.min.js"); ?>"></script>

<script type="text/javascript">
   jQuery(document).ready(function() {
        <?php if($page_subtitle=='Results'){?> 
            spawn_semester(); 
        <?php } 
         if($page_subtitle=='Lecturers Submission'){?> 
            spawn_semester_submission(); 
        <?php }
         if($page_subtitle=='Course Registrations'){?> 
            spawn_course_registrations(); 
        <?php }
         if($page_subtitle=='View My Students'){?> 
            spawn_students(); 
        <?php }
         if($page_subtitle=='Upload Result'){?> 
            spawn_allocated_courses_upload(); 
        <?php } ?>
        <?php if($page_subtitle=='Course Enrollments'){?> 
            spawn_course_enrollments(); 
        <?php } ?>
        <?php if($page_subtitle=='Transfer Students'){?> 
            spawn_transfer_students(); 
        <?php } ?>
       
       //spawn_allocated_courses_enrollment();
       //alert('hh');
   });


</script>
<script>
  $(function () {
    //Initialize Select2 Elements
    $('.select2').select2();

    $("#example1").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $('#modal-table').DataTable({
                             dom: 'Bfrtip',
                             buttons: ['copy','csv','excel','pdf','print']
    });
    $('#mycourse_tbl1').DataTable({
                             dom: 'Bfrtip',
                             buttons: ['copy','csv','excel','pdf','print']
    });
  });
  
  $(document).on('click', '.delete_btn', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('levelcoordinator/configuration_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'delete_course'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Deleted!', data.success, 'success');
                setTimeout(function(){
                    location.reload();
                }, 2500);
              }
            }
          })
        }
        return false;
      })
    });

  $(document).on('click', '.view_students', function(){
    var my_id = $(this).data('id');
    var data =  {my_id : my_id,};
            /*$('#std').text(my_id);
            $('#studentsModal').modal('show');*/

    $.ajax({
        type: "POST",
        url: "<?php echo base_url('levelcoordinator/get_students_biodata') ?>",
        data: data,
        dataType: "json",
        success: function(obj) {
            $('#data').html(obj);
            $('#modal_title').text('List of students reistered for the course');
            $('#studentsModal').modal('show');
        },
    });
  });

  $(document).ready(function(){
  
  <?php if($page_session->getFlashdata('saveSuccess')) { ?>
    toastr.success("<?= $page_session->getFlashdata('saveSuccess') ?>");
  <?php } ?>

  <?php if($page_session->getFlashdata('saveError')) { ?>
    toastr.error("<?= $page_session->getFlashdata('saveError') ?>");
  <?php } ?>
});
</script>



<script>
  $(document).on('click', '.view_student', function(){
    var my_id = $(this).data('id');
    var data =  {my_id : my_id,};
    $('#studentModal').modal('show');
    //$('#overlay').show();

    $.ajax({
        type: "POST",
        url: "<?php echo base_url('levelcoordinator/get_student_details') ?>",
        data: data,
        dataType: "json",
        success: function(obj) {
            $('#data').html(obj);
            //$('#studentModal').modal('show');
            $('#overlay').hide();
        },
    });
  });
</script>

<script>
  $(document).on('click', '.transfer_students', function(){
    var my_id = $(this).data('id');
    var data =  {my_id : my_id,};
    $('#studentModal').modal('show');
    //$('#overlay').show();
    
    $.ajax({
        type: "POST",
        url: "<?php echo base_url('levelcoordinator/get_transfer_courses') ?>",
        data: data,
        dataType: "json",
        success: function(obj) {
            $('#data').html(obj);
            //alert(obj.profile_id);
            $('#overlay').hide();
        },
    });
  
  });
      

</script>

<script>
  $(document).on('click', '.transfer_students_grades', function(){
    var my_id = $(this).data('id');
    var data =  {my_id : my_id,};
    $('#studentModal').modal('show');
    //$('#overlay').show();
    
    $.ajax({
        type: "POST",
        url: "<?php echo base_url('levelcoordinator/get_transfer_courses_grades') ?>",
        data: data,
        dataType: "json",
        success: function(obj) {
            $('#data').html(obj);
            //alert(obj.profile_id);
            $('#overlay').hide();
        },
    });
  
  });
      

</script>


<script>
    $(document).on('click', '.add_course_btn', function(e){
        var courses = <?php echo json_encode($courses); ?>;
        e.preventDefault();
        var newDiv = `<div class="row">
	  								<div class="col-md-8">
	  								<div class="form-group">
								    <select class="form-control select2" name="transfer_course[]" id="course" required> 
			                            <option selected disabled value="">-Course-</option>`
			                            
			                            for(let i = 0; i < courses.length; i++){
	                                        newDiv += `<option value = ${courses[i].id} >${courses[i].id} - ${courses[i].title}</option>`
	                            }
			                            
			                           newDiv += `</select>
	  								</div>
	  								</div>
	  								
	  								<div class="col-md-2">
	  								<div class="form-group">
									<select class="form-control select2" name="transfer_grade[]" id="transfer_grade[]"  required> 
			                            <option selected disabled value="">-Grade-</option>
			                            <option value="A">A</option>
			                            <option value="B">B</option>
			                            <option value="C">C</option>
			                            <option value="D">D</option>
			                            <option value="E">E</option>
			                            <option value="F">F</option>
			                            </select>
	  								</div>
	  								</div>
	  								
	  								<div class="col-md-2">
	  								    <button class ="btn btn-danger remove_course_btn">Remove</button>
	  								</div>
	  								
	  							</div>
            `
            $("#show_item").append(newDiv);
            
    });
</script>

<script>
    $("#add_form").submit(function(e){
       e.preventDefault();
       
       //$("#save_grade_btn").val("Adding...");
       alert("h");
       $.ajax({
           url: '<?php echo base_url('levelcoordinator/save_transfer_grades') ?>',
           method: 'post',
           data: $(this).serialize(),
           success: function(response){
               //alert(data);
           }
       });
    });
</script>

<script>
    $(document).on('click', '.remove_course_btn', function(e){
        let row_item = $(this).parent().parent();
        $(row_item).remove();
  });
</script>

<script>
 "initcomplete".$(function () {
    $("#example21").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example21_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });
</script>

<script>
    function spawn_student_verification(){
        $(".loader-div").show(); // show loader
        var session = document.getElementById('sessionField').value;
        //alert(session);
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('studentField').innerHTML = this.responseText;
          document.getElementById('verify_btn').innerHTML = "";
          document.getElementById('courseField').innerHTML = "";
          $(".loader-div").hide(); // hide loader
            }
      

        xhttp.open("GET","<?= base_url('levelcoordinator/get_student_verification/') ?>/"+session+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_report(){
        
        var course = document.getElementById('sessionField').value;
        //alert(course);
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('download_btn').innerHTML = this.responseText;
            }
      

        xhttp.open("GET","<?= base_url('levelcoordinator/get_download_report/') ?>/"+course+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_semester(){
        
        var course = document.getElementById('sessionField').value;
        //alert(course);
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('semesterField').innerHTML = this.responseText;
            }
      

        xhttp.open("GET","<?= base_url('levelcoordinator/get_semester_available/') ?>/"+course+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_semester_submission(){
        
        var course = document.getElementById('sessionField').value;
        //alert(course);
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('semesterField').innerHTML = this.responseText;
          document.getElementById('txtHintDeptStudents').innerHTML = "List of Submissions Here...";
            }
      

        xhttp.open("GET","<?= base_url('levelcoordinator/get_semester_submission/') ?>/"+course+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_verify_courses(){
        $(".loader-div").show(); // show loader
        var session = $('#sessionField').val();
        var student = document.getElementById('student').value;
        //alert(student);
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
            //alert(student);
          //$('#ward_area').html(this.responseText);
          document.getElementById('verify_btn').innerHTML = "";
          document.getElementById('courseField').innerHTML = this.responseText;
          $(".loader-div").hide(); // hide loader
        }
      

        xhttp.open("GET","<?= base_url('levelcoordinator/get_verification_course/') ?>/"+session+"/"+student+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_verify_grades(){
        $(".loader-div").show(); // show loader
        var session = $('#sessionField').val();
        var student = $('#student').val();
        var course = document.getElementById('course').value;
        
        //alert(student);
        
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          
          document.getElementById('verify_btn').innerHTML = this.responseText;
          $(".loader-div").hide(); // hide loader
        }
      

        xhttp.open("GET","<?= base_url('levelcoordinator/get_verification_grades/') ?>/"+session+"/"+student+"/"+course+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_result(){
            
            $(".loader-div").show(); // show loader        
            var course = $('#sessionField').val();
           
            var programme = document.getElementById('semester').value;
            const xhttp = new XMLHttpRequest();

            xhttp.onload = function() {
            document.getElementById('view_btn').innerHTML = this.responseText; 
            $(".loader-div").hide(); // hide loader
                         $("#example11").DataTable({
                          "responsive": false, "lengthChange": false, "autoWidth": true, "searching": false,
                          "buttons": ["copy", "csv", "excel", "pdf", "print"]
                        }).buttons().container().appendTo('#example11_wrapper .col-md-6:eq(0)'); 	
                         $("#example12").DataTable({
                          "responsive": false, "lengthChange": false, "searching": false,
                          "buttons": ["copy", "csv", "excel", "pdf", "print"]
                        }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');  
            }

            xhttp.open("GET","<?= base_url('levelcoordinator/get_result/') ?>/"+programme+"/"+course+"/"+"\"",true);
            xhttp.send();
             
    }    
</script>

<script>
    function spawn_submission(){
        $(".loader-div").show(); // show loader
        var session = $('#sessionField').val();
        var semester = document.getElementById('semester').value; 
        //alert(semester);     	
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                         $(".loader-div").hide(); // hide loader        
                         //stuff for data table     
                         $("#example1").DataTable({
                            "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                            $('#example2').DataTable({
                              "paging": true,
                              "lengthChange": false,
                              "searching": false,
                              "ordering": true,
                              "info": true,
                              "autoWidth": false,
                              "responsive": true,
                            }); 
                        $(".table1").DataTable({
                          dom: 'Bfrtip',
                          "responsive": false, "lengthChange": false, "autoWidth": true, "searching": false,
                          "buttons": ["csv", "excel", "pdf", "print"]
                        });  
                            
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('levelcoordinator/get_result_submitted/') ?>/"+semester+"/"+session+"/"+"\"",true);
                     xmlhttp.send();
      }

    </script>

    <script>
    function spawn_course_registrations(){
        //var session = $('#sessionField').val();
        $(".loader-div").show(); // show loader
        var session = document.getElementById('sessionField').value; 
        
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                           $(".loader-div").hide(); // hide loader      
                         //stuff for data table     
                         $("#example1").DataTable({
                            "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                            $('#example2').DataTable({
                              "paging": true,
                              "lengthChange": false,
                              "searching": false,
                              "ordering": true,
                              "info": true,
                              "autoWidth": false,
                              "responsive": true,
                            }); 
                         $("#example11").DataTable({
                          "responsive": false, "lengthChange": false, "autoWidth": true, "searching": false, "paging": false,
                          "buttons": ["copy", "csv", "excel", "pdf", "print"]
                        }).buttons().container().appendTo('#example11_wrapper .col-md-6:eq(0)');  
         
                         }else{
                             //alert(course);
                         }
                     };
                     
         
                     xmlhttp.open("GET","<?= base_url('levelcoordinator/get_course_registrations/') ?>/"+session+"/"+"\"",true);
                     xmlhttp.send();
                    
      }

    </script>
    
    <script>
    function spawn_course_enrollments(){
        //var session = $('#sessionField').val();
        $(".loader-div").show(); // show loader
        var session = document.getElementById('sessionField').value; 
        
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                           $(".loader-div").hide(); // hide loader      
                         //stuff for data table     
                         $("#example1").DataTable({
                            "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                            $('#example2').DataTable({
                              "paging": true,
                              "lengthChange": false,
                              "searching": false,
                              "ordering": true,
                              "info": true,
                              "autoWidth": false,
                              "responsive": true,
                            }); 
                         $(".table1").DataTable({
                          dom: 'Bfrtip',
                          "responsive": false, "lengthChange": false, "autoWidth": true, "searching": false,
                          "buttons": ["csv", "excel", "pdf", "print"]
                        });  
                         }else{
                             //alert(course);
                         }
                     };
                     
         
                     xmlhttp.open("GET","<?= base_url('levelcoordinator/get_course_enrollments/') ?>/"+session+"/"+"\"",true);
                     xmlhttp.send();
                    
      }

    </script>
    
    <script>
        function spawn_transfer_students(){
        //var session = $('#sessionField').val();
        //$(".loader-div").show(); // show loader
        var session = document.getElementById('sessionField').value; 
        
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                           $(".loader-div").hide(); // hide loader      
                         //stuff for data table     
                         $("#example1").DataTable({
                            "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                            $('#example2').DataTable({
                              "paging": true,
                              "lengthChange": false,
                              "searching": false,
                              "ordering": true,
                              "info": true,
                              "autoWidth": false,
                              "responsive": true,
                            }); 
                            
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('levelcoordinator/get_transfer_students/') ?>/"+session+"/"+"\"",true);
                     xmlhttp.send();
      }
    </script>

<script>
    function spawn_students(){
        //var session = $('#sessionField').val();
        $(".loader-div").show(); // show loader
        var session = document.getElementById('sessionField').value; 
        
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                           $(".loader-div").hide(); // hide loader      
                         //stuff for data table     
                         $("#example1").DataTable({
                            "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                            $('#example2').DataTable({
                              "paging": true,
                              "lengthChange": false,
                              "searching": false,
                              "ordering": true,
                              "info": true,
                              "autoWidth": false,
                              "responsive": true,
                            }); 
         
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('levelcoordinator/get_students/') ?>/"+session+"/"+"\"",true);
                     xmlhttp.send();
      }
      
      
      
    $('#pwd_form').on('submit', function(event){
      event.preventDefault();
      var pass1 = $('#pass1').val();
      var pass2 = $('#pass2').val();
      
      if($('#pass1').val() != $('#pass2').val()){
        toastr.error("Password does not match");
      }else{
          $.ajax({
            url: "<?php echo base_url('levelcoordinator/password') ?>",
            method: "POST",
            data: $(this).serialize(),
            dataType: 'json',
            beforeSend:function(){
              $('#submit_button').attr('disabled', 'disabled');
              $('#submit_button').val('Please wait...');
            },
            success:function(data){
              $('#submit_button').attr('disabled', false);
              if(data.error != ''){
                toastr.error(data.error);
                $('#submit_button').val('Submit');
              }else{
                toastr.success(data.success);
                $('#pass1').val('');
                $('#pass2').val('');
                $('#submit_button').val('Submit');
              }
            }
          })
      }
    });
    </script>
    
    <script>
    function ca_validation(){
      //alert(x);
        var ca_marks = document.getElementById('ca').value;
        var exam_marks = document.getElementById('exam').value;
        
        if(ca_marks == 'I' || ca_marks == 'ABS'){
                
        }else{
            
            if(!isNaN(ca_marks)){
            
          if(ca_marks >= 0 && ca_marks <= 30){
            
            //$total = Number(ca_marks) + Number(exam_marks);
            //document.getElementById(x+'_total').value = $total;
            
            $total = Math.round(Number(ca_marks) + Number(exam_marks));
            
            if($total >= 0 && $total <= 39){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'F';

            }else if($total >= 40 && $total <= 44){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'E';

            }else if($total >= 45 && $total <= 49){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'D';
              
            }else if($total >= 50 && $total <= 59){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'C';
              
            }else if($total >= 60 && $total <= 69){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'B';
            
            }else if($total >= 70 && $total <= 100){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'A';

            }
          }else{
            alert("CA must be less than or equal to 30");
            document.getElementById('ca').value = "";
          }
        }else{
          alert("Not a number");
          document.getElementById('ca').value = "";
        }
            
        }
        
    }    
</script>

<script>
    function exam_validation(){

        var ca_marks = document.getElementById('ca').value;
        var exam_marks = document.getElementById('exam').value;
        
        if(exam_marks == 'ABS' || exam_marks == 'I' || !isNaN(exam_marks)){
            document.getElementById('total').value = exam_marks;
            document.getElementById('grade').value = exam_marks;
        }else{
          alert("Not allowed");
          document.getElementById('exam').value = "";
        }

        if(!isNaN(exam_marks)){

          if(exam_marks >= 0 && exam_marks <= 70){
            
            $total = Math.round(Number(ca_marks) + Number(exam_marks));
            
            if($total >= 0 && $total <= 39){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'F';

            }else if($total >= 40 && $total <= 44){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'E';

            }else if($total >= 45 && $total <= 49){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'D';
              
            }else if($total >= 50 && $total <= 59){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'C';
              
            }else if($total >= 60 && $total <= 69){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'B';
            
            }else if($total >= 70 && $total <= 100){

              document.getElementById('total').value = $total;
              document.getElementById('grade').value = 'A';

            }
  
          }else{
            alert("Exam must be less than or equal to 70");
            document.getElementById('exam').value = "";
          }

        }else{
          document.getElementById('total').value = exam_marks;
          document.getElementById('grade').value = exam_marks;
        }
    }    
</script>

<script>
    function addLists() {
  if (addInput.value === '') {
    alert('Enter the list name please!!!');
  } else {
    const ul = divList.querySelector('ul');
    const li = document.createElement('li');
    li.innerHTML = addInput.value;
    addInput.value = '';
    ul.appendChild(li);
    createBtn(li);
  }
}

// add list when clicked on add item button
addBtn.addEventListener('click', () => {
  addLists();
});

</script>
