<?php
require(APPPATH .'plugins/fpdf.php');


function hex2dec($couleur = "#000000"){
    $R = substr($couleur, 1, 2);
    $rouge = hexdec($R);
    $V = substr($couleur, 3, 2);
    $vert = hexdec($V);
    $B = substr($couleur, 5, 2);
    $bleu = hexdec($B);
    $tbl_couleur = array();
    $tbl_couleur['R']=$rouge;
    $tbl_couleur['V']=$vert;
    $tbl_couleur['B']=$bleu;
    return $tbl_couleur;
}

//conversion pixel -> millimeter at 72 dpi
function px2mm($px){
    return $px*25.4/72;
}

function txtentities($html){
    $trans = get_html_translation_table(HTML_ENTITIES);
    $trans = array_flip($trans);
    return strtr($html, $trans);
}
////////////////////////////////////

class PDF extends FPDF
{
    //variables of html parser
  protected $B;
  protected $I;
  protected $U;
  protected $HREF;
  protected $fontList;
  protected $issetfont;
  protected $issetcolor;

  function __construct($orientation='P', $unit='mm', $format='A4')
  {
      //Call parent constructor
      parent::__construct($orientation,$unit,$format);
      //Initialization
      $this->B=0;
      $this->I=0;
      $this->U=0;
      $this->HREF='';
      $this->fontlist=array('arial', 'times', 'courier', 'helvetica', 'symbol');
      $this->issetfont=false;
      $this->issetcolor=false;
  }

  function WriteHTML($html)
  {
      //HTML parser
      $html=strip_tags($html,"<b><u><i><a><img><p><br><strong><em><font><tr><blockquote>"); //supprime tous les tags sauf ceux reconnus
      $html=str_replace("\n",' ',$html); //remplace retour à la ligne par un espace
      $a=preg_split('/<(.*)>/U',$html,-1,PREG_SPLIT_DELIM_CAPTURE); //éclate la chaîne avec les balises
      foreach($a as $i=>$e)
      {
          if($i%2==0)
          {
              //Text
              if($this->HREF)
                  $this->PutLink($this->HREF,$e);
              else
                  $this->Write(5,stripslashes(txtentities($e)));
          }
          else
          {
              //Tag
              if($e[0]=='/')
                  $this->CloseTag(strtoupper(substr($e,1)));
              else
              {
                  //Extract attributes
                  $a2=explode(' ',$e);
                  $tag=strtoupper(array_shift($a2));
                  $attr=array();
                  foreach($a2 as $v)
                  {
                      if(preg_match('/([^=]*)=["\']?([^"\']*)/',$v,$a3))
                          $attr[strtoupper($a3[1])]=$a3[2];
                  }
                  $this->OpenTag($tag,$attr);
              }
          }
      }
  }

  function OpenTag($tag, $attr)
  {
      //Opening tag
      switch($tag){
          case 'STRONG':
              $this->SetStyle('B',true);
              break;
          case 'EM':
              $this->SetStyle('I',true);
              break;
          case 'B':
          case 'I':
          case 'U':
              $this->SetStyle($tag,true);
              break;
          case 'A':
              $this->HREF=$attr['HREF'];
              break;
          case 'IMG':
              if(isset($attr['SRC']) && (isset($attr['WIDTH']) || isset($attr['HEIGHT']))) {
                  if(!isset($attr['WIDTH']))
                      $attr['WIDTH'] = 0;
                  if(!isset($attr['HEIGHT']))
                      $attr['HEIGHT'] = 0;
                  $this->Image($attr['SRC'], $this->GetX(), $this->GetY(), px2mm($attr['WIDTH']), px2mm($attr['HEIGHT']));
              }
              break;
          case 'TR':
          case 'BLOCKQUOTE':
          case 'BR':
              $this->Ln(5);
              break;
          case 'P':
              $this->Ln(10);
              break;
          case 'FONT':
              if (isset($attr['COLOR']) && $attr['COLOR']!='') {
                  $coul=hex2dec($attr['COLOR']);
                  $this->SetTextColor($coul['R'],$coul['V'],$coul['B']);
                  $this->issetcolor=true;
              }
              if (isset($attr['FACE']) && in_array(strtolower($attr['FACE']), $this->fontlist)) {
                  $this->SetFont(strtolower($attr['FACE']));
                  $this->issetfont=true;
              }
              break;
      }
  }

  function CloseTag($tag)
  {
      //Closing tag
      if($tag=='STRONG')
          $tag='B';
      if($tag=='EM')
          $tag='I';
      if($tag=='B' || $tag=='I' || $tag=='U')
          $this->SetStyle($tag,false);
      if($tag=='A')
          $this->HREF='';
      if($tag=='FONT'){
          if ($this->issetcolor==true) {
              $this->SetTextColor(0);
          }
          if ($this->issetfont) {
              $this->SetFont('arial');
              $this->issetfont=false;
          }
      }
  }

  function SetStyle($tag, $enable)
  {
      //Modify style and select corresponding font
      $this->$tag+=($enable ? 1 : -1);
      $style='';
      foreach(array('B','I','U') as $s)
      {
          if($this->$s>0)
              $style.=$s;
      }
      $this->SetFont('',$style);
  }

  function PutLink($URL, $txt)
  {
      //Put a hyperlink
      $this->SetTextColor(0,0,255);
      $this->SetStyle('U',true);
      $this->Write(5,$txt,$URL);
      $this->SetStyle('U',false);
      $this->SetTextColor(0);
  }

	function Header()
	{
		// Logoi
		$this->Image(base_url('assets/img/JJJJJ.jpeg'),  0, 0, 211, 295);

		$this->SetAlpha(0.1);

		if($_SESSION['current_school_applied'] == "School of Basic Midwifery, Kano" || $_SESSION['current_school_applied'] == "School of Basic Midwifery, Dambatta" || $_SESSION['current_school_applied'] == "School of Basic Midwifery, Gwarzo" || $_SESSION['current_school_applied'] == "School of Nursing, Kano" || $_SESSION['current_school_applied'] == "School of Nursing, Madobi" || $_SESSION['current_school_applied'] == "School of Post Basic Nursing Anaesthesia" || $_SESSION['current_school_applied'] == "School of Post Basic Midwifery, Gezawa"){
			$this->Image(base_url('assets/img/nursing.jpg'), 30, 70, 150, 150);
		}

		if($_SESSION['current_school_applied'] == "School of Health Technology Kano"){
			$this->Image(base_url('assets/img/sht_kano_logo.jpg'), 30, 70, 150, 150);
		}

		if($_SESSION['current_school_applied'] == "School of Health Technology Bebeji, Kano"){
			$this->Image(base_url('assets/img/bbj_logo.jpg'), 30, 50, 150, 150);
		}

    if($_SESSION['current_school_applied'] == "School of Hygiene, Kano"){
			$this->Image(base_url('assets/img/hygiene_logo.jpg'), 30, 50, 150, 150);
		}

		$this->SetAlpha(1);
	}

	function Footer()
	{
	    // Go to 1.5 cm from bottom
	    $this->SetY(-15);
	    // Select Arial italic 8
	    $this->SetFont('Arial','I',8);
	   	$this->setTextColor(0, 0, 0);
	    // Print centered page number

	}

	protected $extgstates = array();

	 // alpha: real value from 0 (transparent) to 1 (opaque)
	 // bm:    blend mode, one of the following:
	 //          Normal, Multiply, Screen, Overlay, Darken, Lighten, ColorDodge, ColorBurn,
	 //          HardLight, SoftLight, Difference, Exclusion, Hue, Saturation, Color, Luminosity
	 function SetAlpha($alpha, $bm='Normal')
	 {
			 // set alpha for stroking (CA) and non-stroking (ca) operations
			 $gs = $this->AddExtGState(array('ca'=>$alpha, 'CA'=>$alpha, 'BM'=>'/'.$bm));
			 $this->SetExtGState($gs);
	 }

	 function AddExtGState($parms)
	 {
			 $n = count($this->extgstates)+1;
			 $this->extgstates[$n]['parms'] = $parms;
			 return $n;
	 }

	 function SetExtGState($gs)
	 {
			 $this->_out(sprintf('/GS%d gs', $gs));
	 }

	 function _enddoc()
	 {
			 if(!empty($this->extgstates) && $this->PDFVersion<'1.4')
					 $this->PDFVersion='1.4';
			 parent::_enddoc();
	 }

	 function _putextgstates()
	 {
			 for ($i = 1; $i <= count($this->extgstates); $i++)
			 {
					 $this->_newobj();
					 $this->extgstates[$i]['n'] = $this->n;
					 $this->_put('<</Type /ExtGState');
					 $parms = $this->extgstates[$i]['parms'];
					 $this->_put(sprintf('/ca %.3F', $parms['ca']));
					 $this->_put(sprintf('/CA %.3F', $parms['CA']));
					 $this->_put('/BM '.$parms['BM']);
					 $this->_put('>>');
					 $this->_put('endobj');
			 }
	 }

	 function _putresourcedict()
	 {
			 parent::_putresourcedict();
			 $this->_put('/ExtGState <<');
			 foreach($this->extgstates as $k=>$extgstate)
					 $this->_put('/GS'.$k.' '.$extgstate['n'].' 0 R');
			 $this->_put('>>');
	 }

	 function _putresources()
	 {
			 $this->_putextgstates();
			 parent::_putresources();
	 }

   function ClippingText($x, $y, $txt, $outline=false)
    {
        $op=$outline ? 5 : 7;
        $this->_out(sprintf('q BT %.2F %.2F Td %d Tr (%s) Tj ET',
            $x*$this->k,
            ($this->h-$y)*$this->k,
            $op,
            $this->_escape($txt)));
    }

    function ClippingRect($x, $y, $w, $h, $outline=false)
    {
        $op=$outline ? 'S' : 'n';
        $this->_out(sprintf('q %.2F %.2F %.2F %.2F re W %s',
            $x*$this->k,
            ($this->h-$y)*$this->k,
            $w*$this->k,-$h*$this->k,
            $op));
    }

    function _Arc($x1, $y1, $x2, $y2, $x3, $y3)
    {
        $h = $this->h;
        $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c ', $x1*$this->k, ($h-$y1)*$this->k,
            $x2*$this->k, ($h-$y2)*$this->k, $x3*$this->k, ($h-$y3)*$this->k));
    }

    function ClippingRoundedRect($x, $y, $w, $h, $r, $outline=false)
    {
        $k = $this->k;
        $hp = $this->h;
        $op=$outline ? 'S' : 'n';
        $MyArc = 4/3 * (sqrt(2) - 1);

        $this->_out(sprintf('q %.2F %.2F m',($x+$r)*$k,($hp-$y)*$k ));
        $xc = $x+$w-$r ;
        $yc = $y+$r;
        $this->_out(sprintf('%.2F %.2F l', $xc*$k,($hp-$y)*$k ));

        $this->_Arc($xc + $r*$MyArc, $yc - $r, $xc + $r, $yc - $r*$MyArc, $xc + $r, $yc);
        $xc = $x+$w-$r ;
        $yc = $y+$h-$r;
        $this->_out(sprintf('%.2F %.2F l',($x+$w)*$k,($hp-$yc)*$k));
        $this->_Arc($xc + $r, $yc + $r*$MyArc, $xc + $r*$MyArc, $yc + $r, $xc, $yc + $r);
        $xc = $x+$r ;
        $yc = $y+$h-$r;
        $this->_out(sprintf('%.2F %.2F l',$xc*$k,($hp-($y+$h))*$k));
        $this->_Arc($xc - $r*$MyArc, $yc + $r, $xc - $r, $yc + $r*$MyArc, $xc - $r, $yc);
        $xc = $x+$r ;
        $yc = $y+$r;
        $this->_out(sprintf('%.2F %.2F l',($x)*$k,($hp-$yc)*$k ));
        $this->_Arc($xc - $r, $yc - $r*$MyArc, $xc - $r*$MyArc, $yc - $r, $xc, $yc - $r);
        $this->_out(' W '.$op);
    }

    function ClippingEllipse($x, $y, $rx, $ry, $outline=false)
    {
        $op=$outline ? 'S' : 'n';
        $lx=4/3*(M_SQRT2-1)*$rx;
        $ly=4/3*(M_SQRT2-1)*$ry;
        $k=$this->k;
        $h=$this->h;
        $this->_out(sprintf('q %.2F %.2F m %.2F %.2F %.2F %.2F %.2F %.2F c',
            ($x+$rx)*$k,($h-$y)*$k,
            ($x+$rx)*$k,($h-($y-$ly))*$k,
            ($x+$lx)*$k,($h-($y-$ry))*$k,
            $x*$k,($h-($y-$ry))*$k));
        $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c',
            ($x-$lx)*$k,($h-($y-$ry))*$k,
            ($x-$rx)*$k,($h-($y-$ly))*$k,
            ($x-$rx)*$k,($h-$y)*$k));
        $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c',
            ($x-$rx)*$k,($h-($y+$ly))*$k,
            ($x-$lx)*$k,($h-($y+$ry))*$k,
            $x*$k,($h-($y+$ry))*$k));
        $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c W %s',
            ($x+$lx)*$k,($h-($y+$ry))*$k,
            ($x+$rx)*$k,($h-($y+$ly))*$k,
            ($x+$rx)*$k,($h-$y)*$k,
            $op));
    }

    function ClippingCircle($x, $y, $r, $outline=false)
    {
        $this->ClippingEllipse($x, $y, $r, $r, $outline);
    }

    function ClippingPolygon($points, $outline=false)
    {
        $op=$outline ? 'S' : 'n';
        $h = $this->h;
        $k = $this->k;
        $points_string = '';
        for($i=0; $i<count($points); $i+=2){
            $points_string .= sprintf('%.2F %.2F', $points[$i]*$k, ($h-$points[$i+1])*$k);
            if($i==0)
                $points_string .= ' m ';
            else
                $points_string .= ' l ';
        }
        $this->_out('q '.$points_string . 'h W '.$op);
    }

    function UnsetClipping()
    {
        $this->_out('Q');
    }

    function ClippedCell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
    {
        if($border || $fill || $this->y+$h>$this->PageBreakTrigger)
        {
            $this->Cell($w,$h,'',$border,0,'',$fill);
            $this->x-=$w;
        }
        $this->ClippingRect($this->x,$this->y,$w,$h);
        $this->Cell($w,$h,$txt,'',$ln,$align,false,$link);
        $this->UnsetClipping();
    }

}

?>
