<!DOCTYPE html>
<html lang="en">

<head>

  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="">
  <meta name="author" content="">
  <link rel="shortcut icon" href="../assets/img/logo.png" type="image/x-icon">

  <title>Fresh Student Authentication</title>

  <!-- Custom fonts for this template-->
  <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
  <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

  <!-- Custom styles for this template-->
  <link href="../assets/css/sb-admin-2.css" rel="stylesheet" type = "text/css">

</head>

<body class="bg-gradient-primary">

  <div class="container">

    <!-- Outer Row -->
    <div class="row justify-content-center">

      <div class="col-xl-6 col-lg-6 col-md-9">

        <div class="card o-hidden border-0 shadow-lg my-5">
          <div class="card-body p-0">
            <!-- Nested Row within Card Body -->
            <div class="row">
              <div class="col-lg-6 d-none d-lg-block bg-login-image"></div>
              <div class="col-lg-12">
                <div class="p-5">
                  
                  <div class="text-center">
                    <a href="#"><img src="../assets/img/logo.png" alt="" width = "100" height ="100"></a>
                    <h1 class="h4 text-gray-900 mb-4">Fresh Authentication
                    </h1>

                  </div>
                  <?php $page_session = \Config\Services::session(); ?>
                  <?php

                  if($page_session->getTempdata('authenticationError')):       
                  ?>
                  <div class = "alert alert-danger">
                       <?= $page_session->getTempdata('authenticationError'); ?>
                  </div>
                  <?php 
                  endif;
                  ?>

                   <?php $page_session = \Config\Services::session(); ?>
                  <?php

                  if($page_session->getTempdata('registerSuccess')):       
                  ?>
                  <div class = "alert alert-success">
                       <?= $page_session->getTempdata('registerSuccess'); ?>
                  </div>
                  <?php 
                  endif;
                  ?>
				  <?php $page_session = \Config\Services::session(); ?>
				  <?php
				  if($page_session->getTempdata('passwordChanged')):       
                  ?>
                  <div class = "alert alert-success">
                       <?= $page_session->getTempdata('passwordChanged'); ?>
                  </div>
                  <?php 
                  endif;
                  ?>
                  
                  <form class="user" action = "<?= base_url('student/f_authentication') ?>" method = "post">
                    <div class="form-group">
                      <label>Application Number</label>
                      <input type="text" class="form-control form-control-user" name = "appNumber" id="exampleInputText" placeholder="Enter Application Number...">
                    </div>
                    <div class="form-group">
                      <label>Programme</label>
                      <select class="form-control" name = "programme" id = "programme" required>
                      <option value = "">Select Your Programme</option>
                      <?php foreach($result as $res): ?>
                            <option value = "<?= $res->program ?>"><?= $res->program ?></option>
                        <?php endforeach ?>
									
									
									</select>
                    </div>
                    <div class="form-group">
                      <label>PIN Number</label>
                      <input type="password" class="form-control form-control-user" name = "pin" id="exampleInputPassword" placeholder="Enter PIN...">
                    </div>
                    
                    <button class="btn btn-primary btn-user btn-block">
                      Authenticate
                    </button>
                    
                  </form>
                  <hr>
                
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>

    </div>

  </div>

  <!-- Bootstrap core JavaScript-->
  <script src="../assets/vendor/jquery/jquery.min.js"></script>
  <script src="../assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

  <!-- Core plugin JavaScript-->
  <script src="../assets/vendor/jquery-easing/jquery.easing.min.js"></script>

  <!-- Custom scripts for all pages-->
  <script src="../assets/js/sb-admin-2.min.js"></script>

</body>

</html>
