<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?= base_url("/../assets_/img/yumsuk_logo.png");?>" type="image/x-icon">
  <title>HOD | <?= $page_title ?> | <?= $page_subtitle ?></title>
  <?php $page_session = \Config\Services::session(); ?>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/fontawesome-free/css/all.min.css"); ?>">
  <!-- daterange picker -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/daterangepicker/daterangepicker.css");?>">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?= base_url("/.../assets_/plugins/icheck-bootstrap/icheck-bootstrap.min.css")?>">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css")?>">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css")?>">
  <!-- Toastr -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/toastr/toastr.min.css")?>">
  <!-- Sweet Alert -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/sweetalert2/sweetalert2.min.css")?>">
  <!-- Select2 -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/select2/css/select2.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css")?>">
  <!-- Bootstrap4 Duallistbox -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css")?>">
  <!-- BS Stepper -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bs-stepper/css/bs-stepper.min.css")?>">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/dropzone/min/dropzone.min.css")?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/dist/css/adminlte.min.css")?>">

  <!-- DataTables -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-responsive/css/responsive.bootstrap4.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-buttons/css/buttons.bootstrap4.min.css")?>">

  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/icheck-bootstrap/icheck-bootstrap.min.css")?>">
  
  <link rel ="stylesheet" type="text/css" href= "https://gyrocode.github.io/jquery-datatables-checkboxes/1.2.12/css/dataTables.min.js" >
  
  <style type="text/css">
		.loader-div {
			display: none;
			position: fixed;
			margin: 0px;
			padding: 0px;
			right: 0px;
			top: 0px;
			width: 100%;
			height: 100%;
			background-color: #fff;
			z-index: 30001;
			opacity: 0.8;
		}
		.loader-img {
			position: absolute;
			top: 0;
			bottom: 0;
			left: 0;
			right: 0;
			margin: auto;
		}
	</style>
</head>
<body class="text-sm hold-transition sidebar-mini" >
    <div class="loader-div">
    <img class="loader-img" src="<?= base_url("/../assets/img/ajax-loader.gif")?>" style="height: 120px;width: auto;" />
</div>
<div class="wrapper">
  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?= base_url()?>/head-index" class="nav-link">Home</a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?= base_url()?>/head-logout" class="nav-link">Logout</a>
      </li>
    </ul>

    <!-- Right navbar links -->
    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">

      <li class="nav-item dropdown user-menu">
        <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
          <img src="<?= base_url()?>/assets_/img/nwu_logo.jpg" class="user-image img-circle elevation-2" alt="User Image">
          <span class="d-none d-md-inline">YUMSUK - Department of <?= $page_session->get('name'); ?></span>
        </a>
        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
          <!-- User image -->
          <li class="user-header bg-primary">
            <img src="<?= base_url()?>/assets_/img/nwu_logo.jpg" class="img-circle elevation-2" alt="User Image">
            <p>
              YUMSUK - Department of <?= $page_session->get('name'); ?>
              <small></small>
            </p>
          </li>
          <!-- Menu Footer-->
          <li class="user-footer">
            <a href="#" class="btn btn-default btn-flat">Profile</a>
            <a href="<?= base_url()?>/head-logout" class="btn btn-default btn-flat float-right">logout</a>
          </li>
        </ul>
      </li>
    </ul>
  </nav>
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?= base_url()?>/hod/dashboard" class="brand-link">
      <img src="<?= base_url()?>/assets_/img/nwu_logo.jpg" alt="RPS Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
      <span class="brand-text font-weight-light">YUMSUK RPS</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
      <!-- Sidebar user (optional) -->
      <div class="user-panel mt-3 pb-3 mb-3 d-flex text-center">
        <div class="info">
          <a href="#" class="d-block">YUMSUK<br/>Department of <?= $page_session->get('name'); ?></a>
        </div>
      </div>
        <div class="user-panel mb-3 d-flex" style="background-color: #000000;">
          <div class="info">
            <a href="javascript:void(0);"><?php echo "Current Session: ".$page_session->get('current_session'); ?></a>
            <br/>
          </div>
        </div>

       <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
          <li class="nav-item">
            <a href="<?= base_url()?>/head-index" class="nav-link <?php echo ($page_title=='Dashboard')?'active':'' ?>">
              <i class="nav-icon fas fa-tachometer-alt"></i>
              <p>
                Dashboard
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="<?= base_url()?>/head-staff" class="nav-link <?php echo ($page_title=='Departmental Staff')?'active':'' ?>">
              <i class="nav-icon fas fa-users"></i>
              <p>
                Staff
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="<?= base_url()?>/head-examofficers" class="nav-link <?php echo ($page_title=='Exam Officers')?'active':'' ?>">
              <i class="nav-icon fas fa-edit"></i>
              <p>
                Exam Officers
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="<?= base_url()?>/head-levelcoordinators" class="nav-link <?php echo ($page_title=='Level Coordinators')?'active':'' ?>">
              <i class="nav-icon fas fa-cubes"></i>
              <p>
                Level Coordinators
              </p>
            </a>
          </li>
          <li class="nav-item">
            <a href="<?= base_url()?>/head-students" class="nav-link <?php echo ($page_title=='Departmental Students')?'active':'' ?>">
              <i class="nav-icon fas fa-graduation-cap"></i>
              <p>
                Students
              </p>
            </a>
          </li>
          <li class="nav-item <?php echo ($page_title=='Courses')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='Courses')?'active':'' ?>">
              <i class="nav-icon fas fa-list-alt"></i>
              <p>
                Courses
                <i class="right fas fa-angle-left"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url()?>/head-courses" class="nav-link <?php echo ($page_subtitle=='View Courses')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>View All Courses</p>
                </a>
              </li>
              <!--<li class="nav-item">
                <a href="#" class="nav-link <?php echo ($page_subtitle=='Student Course Registrations')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Student Course Registrations</p>
                </a>
              </li>-->
              <li class="nav-item">
                <a href="<?= base_url()?>/head-allocate" class="nav-link <?php echo ($page_subtitle=='Allocate Courses')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Allocate Courses</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url()?>/head-allocations" class="nav-link <?php echo ($page_subtitle=='Course Allocations')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>List of Allocations</p>
                </a>
              </li>
            </ul>
          </li>
          <li class="nav-item <?php echo ($page_title=='Exam Results')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='Exam Results')?'active':'' ?>">
              <i class="nav-icon fas fa-chart-bar"></i>
              <p>
                Exam Results
                <i class="right fas fa-angle-left"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url()?>/head-submissions" class="nav-link <?php echo ($page_subtitle=='Approve Submissions')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Lecturers Submissions</p>
                </a>
              </li>
              <!-- <li class="nav-item">
                <a href="<?= base_url()?>/hod/results" class="nav-link <?php echo ($page_subtitle=='Results')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Results</p>
                </a>
              </li> -->
            </ul>
          </li>
          <li class="nav-item">
            <a href="<?= base_url()?>/head-profile" class="nav-link <?php echo ($page_title=='Manage Profile')?'active':'' ?>">
              <i class="nav-icon fas fa-user-cog"></i>
              <p>
                Manage Profile
              </p>
            </a>
          </li>
          <!--<li class="nav-item <?php echo ($page_title=='Manage Profile')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='Manage Profile')?'active':'' ?>">
              <i class="nav-icon fas fa-user"></i>
              <p>
                Manage Profile
                <i class="right fas fa-angle-left"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="#" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Edit Profile</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url()?>/hod/password" class="nav-link <?php echo ($page_subtitle=='Change Password')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Change Password</p>
                </a>
              </li>
            </ul>
          </li>-->
        </ul>
      </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside>

  <?= $this->renderSection("content"); ?>
              
            <!-- /.card -->
          </div>
        </div>
        <!-- /.row -->
        
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="float-right d-none d-sm-block">
        Powered by the Directorate of ICT and Department of Computer Science.
        &nbsp; &nbsp; &nbsp; &nbsp; 
        <b>Version</b> 1.0
    </div>
    Copyright &copy; <?= "2022-".date("Y") ?> <a href="http://www.yumsuk.edu.ng">Yusuf Maitama Sule University, Kano</a>. All rights
    reserved.
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="<?= base_url("/../assets_/plugins/jquery/jquery.min.js");?>"></script>
<!-- Bootstrap 4 -->
<script src="<?= base_url("/../assets_/plugins/bootstrap/js/bootstrap.bundle.min.js");?>"></script>
<!-- Toastr -->
<script src="<?= base_url("/../assets_/plugins/toastr/toastr.min.js")?>"></script>
<!-- Sweet Alert -->
<script src="<?= base_url("/../assets_/plugins/sweetalert2/sweetalert2.min.js")?>"></script>
<!-- Select2 -->
<script src="<?= base_url("/../assets_/plugins/select2/js/select2.full.min.js");?>"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="<?= base_url("/../assets_/plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js");?>"></script>
<!-- InputMask -->
<script src="<?= base_url("/../assets_/plugins/moment/moment.min.js")?>"></script>
<script src="<?= base_url("/../assets_/plugins/inputmask/jquery.inputmask.min.js");?>"></script>
<!-- date-range-picker -->
<script src="<?= base_url("../assets_/plugins/daterangepicker/daterangepicker.js");?>"></script>
<!-- bootstrap color picker -->
<script src="<?= base_url("/../assets_/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js");?>"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="<?= base_url("/../assets_/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js");?>"></script>
<!-- Bootstrap Switch -->
<script src="<?= base_url("/../assets_/plugins/bootstrap-switch/js/bootstrap-switch.min.js");?>"></script>
<!-- BS-Stepper -->
<script src="<?= base_url("/../assets_/plugins/bs-stepper/js/bs-stepper.min.js");?>"></script>
<!-- dropzonejs -->
<script src="<?= base_url("/../assets_/plugins/dropzone/min/dropzone.min.js");?>"></script>
<!-- AdminLTE App -->
<script src="<?= base_url("/../assets_/dist/js/adminlte.min.js");?>"></script>
<!-- AdminLTE for demo purposes -->
<script src="<?= base_url("/../assets_/dist/js/demo.js");?>"></script>
<!-- jquery-validation -->
<script src="<?= base_url("/../assets_/plugins/jquery-validation/jquery.validate.min.js");?>"></script>
<script src="<?= base_url("/../assets_/plugins/jquery-validation/additional-methods.min.js");?>"></script>
<!-- Page specific script -->

<!-- DataTables  & Plugins -->
<script src="<?= base_url("/../assets_/plugins/datatables/jquery.dataTables.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-responsive/js/dataTables.responsive.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/dataTables.buttons.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/jszip/jszip.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/pdfmake/pdfmake.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/pdfmake/vfs_fonts.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.html5.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.print.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.colVis.min.js"); ?>"></script>

  <!-- Custom scripts for all pages-->
<script src="<?= base_url("/../assets/js/sb-admin-2.min.js"); ?>"></script>

<!-- Toastr -->
<script src="<?= base_url("/../assets/plugins/toastr/toastr.min.js"); ?>"></script>
<script type="text/javascript" src ="https://gyrocode.github.io/jquery-datatables-checkboxes/1.2.12/js/dataTables.checkboxes.min.js"></script>

<script>
   $(document).ready(function(){
        $('#example1').DataTable({
            alert("jjjj")
        });
    });
</script>
<script type="text/javascript">
   jQuery(document).ready(function() {
        $('.select2').select2();

        $('#staff_tbl').DataTable({
            dom: 'Bfrtip',
            buttons: ['copy','csv','excel','pdf','print']
        });
        $('#eo_tbl').DataTable({
            dom: 'Bfrtip',
            buttons: ['copy','csv','excel','pdf','print']
        });

        <?php if($page_subtitle=='Course Allocations'){?> 
          spawn_allocations(); 
        <?php } 
         if($page_subtitle=='Approve Submissions'){?> 
            spawn_available_semester(); 
        <?php }
         if($page_subtitle=='Results'){?> 
            spawn_available_programmes_result(); 
        <?php }
         if($page_subtitle=='My Students'){?> 
            spawn_students(); 
        <?php }
         if($page_subtitle=='Upload Result'){?> 
            spawn_allocated_courses_upload(); 
        <?php } ?>
       
       //spawn_allocated_courses_enrollment();
       //alert('hh');
   });
   
   $(document).ready(function(){
  
  <?php if($page_session->getFlashdata('allocationSuccess')) { ?>
    toastr.success("<?= $page_session->getFlashdata('allocationSuccess') ?>");
  <?php } ?>

  <?php if($page_session->getFlashdata('allocationError')) { ?>
    toastr.error("<?= $page_session->getFlashdata('allocationError') ?>");
  <?php } ?>
});
</script>

<script>
  $(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
    $(".example3").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
    });
  });
</script>

<script>
    function spawn_lecturers(){
        $(".loader-div").show(); // show loader
        var course = document.getElementById('courseField').value;
        const xhttp = new XMLHttpRequest();
         
        xhttp.onreadystatechange = function() {
          $('#lecturerField').select2();
        }

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
        $('#lecturerField').select2();
          document.getElementById('availableLecturerField').innerHTML = this.responseText;
          $(".loader-div").hide(); // show loader
            }
      

        xhttp.open("GET","<?= base_url('hod/get_lecturer/') ?>/"+course+"/"+"\"",true);
      	xhttp.send();
    }    
    
    function spawn_allocation_button(){
        $(".loader-div").show(); // show loader
        var lecturer = document.getElementById('lecturerField').value;
        var course = $('#courseField').val();
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('buttonField').innerHTML = this.responseText;
          $(".loader-div").hide(); // show loader
            }
      

        xhttp.open("GET","<?= base_url('hod/allocation_button/') ?>/"+course+"/"+"\"",true);
      	xhttp.send();
    }    

    function spawn_semester(){
        $(".loader-div").show(); // show loader
        var course = document.getElementById('sessionField').value;
        //alert(course);
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('semesterField').innerHTML = this.responseText;
          $(".loader-div").hide(); // show loader
            }
      

        xhttp.open("GET","<?= base_url('levelcoordinator/get_semester_available/') ?>/"+course+"/"+"\"",true);
      	xhttp.send();
    }    

    function spawn_semester_submission(){
        $(".loader-div").show(); // show loader
        var session = document.getElementById('sessionField').value;
        //alert(course);
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('semesterField').innerHTML = this.responseText;
          $(".loader-div").hide(); // show loader
          document.getElementById('txtHintDeptStudents').innerHTML = "List of Submissions Here...";
            }
      

        xhttp.open("GET","<?= base_url('levelcoordinator/get_semester_submission/') ?>/"+session+"/"+"\"",true);
      	xhttp.send();
    }  

    function spawn_result(){
            $(".loader-div").show(); // show loader
            var course = $('#sessionField').val();
           
            var programme = document.getElementById('semester').value;
            const xhttp = new XMLHttpRequest();

            xhttp.onload = function() {
            document.getElementById('view_btn').innerHTML = this.responseText;  $(".loader-div").hide(); // show loader      	
            }

            xhttp.open("GET","<?= base_url('levelcoordinator/get_result/') ?>/"+programme+"/"+course+"/"+"\"",true);
            xhttp.send();
    }    

    function spawn_allocations(){
        $(".loader-div").show(); // show loader
        //var programme = $('#progammes').val();
        var session = document.getElementById('sessionField').value; 
        
           	
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                             $(".loader-div").hide(); // show loader
                                 
                         //stuff for data table     
                         $("#example1").DataTable({
                            "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                            $('#example2').DataTable({
                              "paging": true,
                              "lengthChange": false,
                              "searching": false,
                              "ordering": true,
                              "info": true,
                              "autoWidth": false,
                              "responsive": true,
                            });
                            
                             $(".table1").DataTable({
                          dom: 'Bfrtip',
                          "responsive": false, "lengthChange": false, "autoWidth": true, "searching": false,
                          "buttons": ["csv", "excel", "pdf", "print"]
                        }); 
                            
         
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('hod/get_course_allocations/') ?>/"+session+"/"+"\"",true);
                     xmlhttp.send();
      }


    function spawn_submission(){
        $(".loader-div").show(); // show loader
        var session = $('#sessionField').val();
        var semester = document.getElementById('semester').value; 
        //alert(semester);     	
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                               $(".loader-div").hide(); // show loader  
                         //stuff for data table     
                         $("#example1").DataTable({
                            "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                            $('#example2').DataTable({
                              "paging": true,
                              "lengthChange": false,
                              "searching": false,
                              "ordering": true,
                              "info": true,
                              "autoWidth": false,
                              "responsive": true,
                            }); 
                            
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('levelcoordinator/get_result_submitted/') ?>/"+semester+"/"+session+"/"+"\"",true);
                     xmlhttp.send();
      }


    function spawn_available_programmes(){
        $(".loader-div").show(); // show loader
            var session = document.getElementById('sessionField').value;
            
            const xhttp = new XMLHttpRequest();

            xhttp.onload = function() {
            document.getElementById('programmeField').innerHTML = this.responseText;    
            $(".loader-div").hide(); // show loader
            }

            xhttp.open("GET","<?= base_url('hod/get_programme/') ?>/"+session+"/"+"\"",true);
            xhttp.send();
    }    

    function spawn_available_semester(){
        //$(".loader-div").show(); // show loader
            var session = document.getElementById('sessionField').value;
            
            const xhttp = new XMLHttpRequest();

            xhttp.onload = function() {
            document.getElementById('semesterField').innerHTML = this.responseText;  
            $(".loader-div").hide(); // show loader
            }

            xhttp.open("GET","<?= base_url('hod/get_submitted_semester/') ?>/"+session+"/"+"\"",true);
            xhttp.send();
    }    

    function spawn_available_programmes_result(){
            $(".loader-div").show(); // show loader
            var session = document.getElementById('sessionField').value;
            const xhttp = new XMLHttpRequest();

            xhttp.onload = function() {
            document.getElementById('programmeField').innerHTML = this.responseText;   
            $(".loader-div").hide(); // show loader
            }

            xhttp.open("GET","<?= base_url('hod/get_departmental_programmes/') ?>/"+session+"/"+"\"",true);
            xhttp.send();
    }    

    function spawn_available_semester_result(){
        
            var session = document.getElementById('programme').value;
            
            const xhttp = new XMLHttpRequest();

            xhttp.onload = function() {
            document.getElementById('semesterField').innerHTML = this.responseText;        	
            }

            xhttp.open("GET","<?= base_url('hod/get_semester_results/') ?>/"+session+"/"+"\"",true);
            xhttp.send();
    }    

    function spawn_students_result(){
        $(".loader-div").show(); // show loader
        var session = $('#sessionField').val();
        var programme = $('#programme').val();
        var semester = document.getElementById('semester').value;
        	
            if (window.XMLHttpRequest) {
                    // code for IE7+, Firefox, Chrome, Opera, Safari
                    xmlhttp = new XMLHttpRequest();
                } else {
                    // code for IE6, IE5
                    xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                }
    
            xmlhttp.onreadystatechange = function() {
                    
                    if (this.readyState == 4 && this.status == 200) {
                        
                      document.getElementById("submittedProgrammeField").innerHTML = "";
                        document.getElementById("submittedProgrammeField").innerHTML = this.responseText;
                            $(".loader-div").show(); // show loader
                    //stuff for data table     
                    $("#example1").DataTable({
                      "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                      }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                      $('#example2').DataTable({
                        "paging": true,
                        "lengthChange": false,
                        "searching": false,
                        "ordering": true,
                        "info": true,
                        "autoWidth": false,
                        "responsive": true,
                      }); 
                         $(".table1").DataTable({
                          "responsive": false, "lengthChange": false, "autoWidth": true, "searching": false,
                          "buttons": ["csv", "excel", "pdf", "print"]
                        }).buttons().container().appendTo('#example11_wrapper .col-md-6:eq(0)'); 

                    }else{
                        //alert(course);
                    }
                };
    
                xmlhttp.open("GET","<?= base_url('hod/get_lecturers_submission/') ?>/"+session+"/"+programme+"/"+semester+"/"+"\"",true);
                xmlhttp.send();
      }

    function spawn_lecturers_submission(){
        $(".loader-div").show(); // show loader
        var session = $('#sessionField').val();
        var programme = $('#programme').val();
        var semester = document.getElementById('semester').value;

         	
            if (window.XMLHttpRequest) {
                    // code for IE7+, Firefox, Chrome, Opera, Safari
                    xmlhttp = new XMLHttpRequest();
                } else {
                    // code for IE6, IE5
                    xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                }
    
            xmlhttp.onreadystatechange = function() {
                    
                    if (this.readyState == 4 && this.status == 200) {
                        
                      document.getElementById("submittedProgrammeField").innerHTML = "";
                        document.getElementById("submittedProgrammeField").innerHTML = this.responseText;
                          $(".loader-div").hide(); // show loader  
                    //stuff for data table     
                    $("#example1").DataTable({
                      "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                      }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                      $('#example2').DataTable({
                        "paging": true,
                        "lengthChange": false,
                        "searching": false,
                        "ordering": true,
                        "info": true,
                        "autoWidth": false,
                        "responsive": true,
                      }); 
                         $(".table1").DataTable({
                          "responsive": false, "lengthChange": false, "autoWidth": true, "searching": false,
                          "buttons": ["csv", "excel", "pdf", "print"]
                        }).buttons().container().appendTo('#example11_wrapper .col-md-6:eq(0)'); 

                    }else{
                        //alert(course);
                    }
                };
    
                xmlhttp.open("GET","<?= base_url('hod/get_lecturers_submission/') ?>/"+session+"/"+programme+"/"+semester+"/"+"\"",true);
                xmlhttp.send();
      }

    function spawn_course_registrations(){
        //var session = $('#sessionField').val();
        var session = document.getElementById('sessionField').value; 
        
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                                 
                         //stuff for data table     
                         $("#example1").DataTable({
                            "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                            $('#example2').DataTable({
                              "paging": true,
                              "lengthChange": false,
                              "searching": false,
                              "ordering": true,
                              "info": true,
                              "autoWidth": false,
                              "responsive": true,
                            }); 
         
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('levelcoordinator/get_course_registrations/') ?>/"+session+"/"+"\"",true);
                     xmlhttp.send();
      }

    function spawn_students(){
        var programme = $('#programme').val();
        var level = $('#level').val();
        var gender = $('#gender').val();
        //var session = document.getElementById('sessionField').value; 
        
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                                 
                         //stuff for data table 
                          $('#student_tbl').DataTable({
                              dom: 'Bfrtip',
                              buttons: ['copy','csv','excel','pdf','print']
                          });
         
                         }else{
                             //alert(course);
                         }
                     };
         
                    xmlhttp.open("GET","<?= base_url('hod/get_students/') ?>/"+programme+"/"+level+"/"+gender+"/"+"\"",true);
                     xmlhttp.send();
      }

  $(document).on('change', '#level', function(){
        if($('#programme').val() != '' && $('#gender').val() != ''){
          spawn_students();
        }

  });

  $(document).on('change', '#programme', function(){
        if($('#level').val() != '' && $('#gender').val() != ''){
          spawn_students();
        }

  });

    $(document).on('click', '.delete_btn', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('hod/exam_officers_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'delete'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Deleted!', data.success, 'success');
                setTimeout(function(){
                    location.reload();
                }, 2500);
              }
            }
          })
        }
        return false;
      })
    });

    $(document).on('click', '.delete_btn2', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('hod/level_coordinators_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'delete'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Deleted!', data.success, 'success');
                setTimeout(function(){
                    location.reload();
                }, 2500);
              }
            }
          })
        }
        return false;
      })
    });
    
    
    $(document).on('click', '.delete_allocation', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('hod/course_allocation_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'delete_allocation'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Deleted!', data.success, 'success');
                setTimeout(function(){
                    location.reload();
                }, 2500);
              }
            }
          })
        }
        return false;
      })
    });
   
   
  $(document).on('click', '.view_student', function(){
    var my_id = $(this).data('id');
    var data =  {my_id : my_id,};
    $('#studentModal').modal('show');
    //$('#overlay').show();

    $.ajax({
        type: "POST",
        url: "<?php echo base_url('hod/get_student_details') ?>",
        data: data,
        dataType: "json",
        success: function(obj) {
            $('#data').html(obj);
            //$('#studentModal').modal('show');
            $('#overlay').hide();
        },
    });
  });

  $(document).on('click', '.view_students_by_stat', function(){
    var stat = $(this).data('id');
    var data =  {stat : stat,};
    $('#viewModal').modal('show');
    $('#modal_title1').text(stat + ' Students');

    $.ajax({
        type: "POST",
        url: "<?php echo base_url('hod/get_students_by_stat') ?>",
        data: data,
        dataType: "json",
        success: function(obj) {
            $('#data1').html(obj);
            $('#overlay1').hide();
        },
    });
  });

    

  function previewImage(input, previewDom) {

    if (input.files && input.files[0]) {

      $(previewDom).show();

      var reader = new FileReader();

      reader.onload = function(e) {
        $(previewDom).find('img').attr('src', e.target.result);
      }

      reader.readAsDataURL(input.files[0]);
    }else{
      $(previewDom).hide();
    }

  }
  
    $('#sign_form').on('submit', function(event){
      event.preventDefault();
      $.ajax({
        url: "<?php echo base_url('hod/profile') ?>",
        type: "POST",
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData: false,
        beforeSend:function(){
          $('#submit').attr('disabled', 'disabled');
          $('#submit').val('Uploading...');
        },
        success:function(data){
          $('#submit').attr('disabled', false);
          $('#submit').val('Submit');
          if(data == 1 || parseInt(data) == 1){
            Swal.fire('Success!', "Signature has been Updated Successfully", 'success');
            setTimeout(function(){
                location.reload();
            }, 2000);
          }else{
            toastr.error("Server Error Occured while Uploading Image !");
          }
        }
      })
    });
      
      
      
    $(document).on('click', '.accept_button', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, accept it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('hod/submission_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'accept'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Accepted!', data.success, 'success');
                location.reload();
              }
            }
          })
        }
        return false;
      })
    });

    $(document).on('click', '.reject_button', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, reject it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('hod/submission_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'reject'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Rejected!', data.success, 'success');
                location.reload();
              }
            }
          })
        }
        return false;
      })
    });

    $(document).on('click', '.return_button', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure?",
        text: "The selected result will be returned to the lecturer for editing!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, return it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('hod/submission_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'return'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Returned!', data.success, 'success');
                location.reload();
              }
            }
          })
        }
        return false;
      })
    });
    
    $('#pwd_form').on('submit', function(event){
      event.preventDefault();
      var pass1 = $('#pass1').val();
      var pass2 = $('#pass2').val();
      
      if($('#pass1').val() != $('#pass2').val()){
        toastr.error("Password does not match");
      }else{
          $.ajax({
            url: "<?php echo base_url('hod/password') ?>",
            method: "POST",
            data: $(this).serialize(),
            dataType: 'json',
            beforeSend:function(){
              $('#submit_button').attr('disabled', 'disabled');
              $('#submit_button').val('Please wait...');
            },
            success:function(data){
              $('#submit_button').attr('disabled', false);
              if(data.error != ''){
                toastr.error(data.error);
                $('#submit_button').val('Submit');
              }else{
                //toastr.success(data.success);
                Swal.fire('Success!', data.success, 'success');
                $('#pass1').val('');
                $('#pass2').val('');
                $('#submit_button').val('Submit');
              }
            }
          })
      }
    });
    </script>